/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.item;

import cech12.ceramicbucket.api.item.CeramicBucketItems;
import cech12.ceramicbucket.item.AbstractCeramicBucketItem;
import cech12.ceramicbucket.item.FilledCeramicBucketFluidHandler;
import cech12.ceramicbucket.util.CeramicBucketUtils;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FilledCeramicBucketItem
extends AbstractCeramicBucketItem {
    public FilledCeramicBucketItem(Item.Properties builder) {
        super((Supplier<? extends Fluid>)Fluids.field_204541_a.delegate, builder);
    }

    @Override
    @Nonnull
    FluidHandlerItemStack getNewFluidHandlerInstance(@Nonnull ItemStack stack) {
        return new FilledCeramicBucketFluidHandler(stack);
    }

    public ItemStack getFilledInstance(@Nonnull Fluid fluid) {
        return this.fill(new ItemStack((IItemProvider)this), new FluidStack(fluid, 1000));
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        return this.getFilledInstance((Fluid)Fluids.field_204546_a);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ArrayList<Fluid> addedFluids = new ArrayList<Fluid>();
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                Fluid bucketFluid;
                Item bucket = fluid.func_204524_b();
                if (!(bucket instanceof BucketItem) || CeramicBucketUtils.isMilkFluid(fluid, false) || addedFluids.contains(bucketFluid = ((BucketItem)bucket).getFluid())) continue;
                items.add((Object)this.getFilledInstance(bucketFluid));
                addedFluids.add(bucketFluid);
            }
        }
    }

    @Nonnull
    public String func_77658_a() {
        return Util.func_200697_a((String)"item", (ResourceLocation)CeramicBucketItems.CERAMIC_BUCKET.getRegistryName());
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        if (this.getFluid(stack) == Fluids.field_204541_a) {
            return new TranslationTextComponent("item.ceramicbucket.ceramic_bucket");
        }
        Object fluidText = this.getFluid(stack) == Fluids.field_204546_a || this.getFluid(stack) == Fluids.field_204547_b ? this.getFluid(stack).func_207188_f().func_206883_i().func_177230_c().func_235333_g_() : new TranslationTextComponent(Util.func_200697_a((String)"fluid", (ResourceLocation)ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.getFluid(stack))));
        return new TranslationTextComponent("item.ceramicbucket.filled_ceramic_bucket", new Object[]{fluidText});
    }

    public int getBurnTime(ItemStack itemStack) {
        int burnTime = CeramicBucketUtils.getBurnTimeOfFluid(this.getFluid(itemStack));
        if (burnTime >= 0) {
            return burnTime;
        }
        return super.getBurnTime(itemStack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        Fluid fluid = this.getFluid(stack);
        return fluid != Fluids.field_204541_a && !CeramicBucketUtils.isFluidTooHotForCeramicBucket(fluid);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (this.hasContainerItem(itemStack)) {
            return new ItemStack((IItemProvider)CeramicBucketItems.CERAMIC_BUCKET);
        }
        return null;
    }
}

