/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.jei;

import cech12.ceramicbucket.api.item.CeramicBucketItems;
import cech12.ceramicbucket.util.CeramicBucketUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    private static ResourceLocation ID = new ResourceLocation("ceramicbucket", "jei_plugin");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{CeramicBucketItems.FILLED_CERAMIC_BUCKET});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ArrayList<Fluid> addedFluids = new ArrayList<Fluid>();
        LinkedList<ItemStack> fuelBuckets = new LinkedList<ItemStack>();
        for (Fluid fluid : ForgeRegistries.FLUIDS) {
            Fluid bucketFluid;
            Item bucket = fluid.func_204524_b();
            if (!(bucket instanceof BucketItem) || CeramicBucketUtils.getBurnTimeOfFluid(fluid) <= 0 || addedFluids.contains(bucketFluid = ((BucketItem)bucket).getFluid())) continue;
            fuelBuckets.add(CeramicBucketUtils.getFilledCeramicBucket(bucketFluid));
            addedFluids.add(bucketFluid);
        }
        registration.addRecipes(fuelBuckets, VanillaRecipeCategoryUid.FUEL);
    }
}

