/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public class NBTHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersionOfStructureFile(File file) {
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));){
            NBTBase nbtbase;
            String key;
            if (input.readByte() != 10) {
                String string = null;
                return string;
            }
            input.readUTF();
            do {
                byte id;
                if ((id = input.readByte()) == 0) return null;
                key = input.readUTF();
                nbtbase = NBTTagCompound.func_152449_a((byte)id, (String)key, (DataInput)input, (int)0, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            } while (!key.equals("cqr_file_version"));
            String string = nbtbase instanceof NBTTagString ? ((NBTTagString)nbtbase).func_150285_a_() : null;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

