/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured;

import java.io.File;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import team.cqr.cqrepoured.command.CommandChangeReputation;
import team.cqr.cqrepoured.command.CommandExport;
import team.cqr.cqrepoured.command.CommandGetProtectedRegion;
import team.cqr.cqrepoured.customtextures.TextureSetManager;
import team.cqr.cqrepoured.factions.FactionRegistry;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRCapabilities;
import team.cqr.cqrepoured.init.CQRDispenseBehaviors;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.init.CQRMaterials;
import team.cqr.cqrepoured.init.CQRMessages;
import team.cqr.cqrepoured.init.CQRSerializers;
import team.cqr.cqrepoured.objects.banners.BannerHelper;
import team.cqr.cqrepoured.objects.banners.EBannerPatternsCQ;
import team.cqr.cqrepoured.objects.banners.EBanners;
import team.cqr.cqrepoured.objects.entity.boss.EntityCQRNetherDragon;
import team.cqr.cqrepoured.proxy.IProxy;
import team.cqr.cqrepoured.structuregen.DungeonRegistry;
import team.cqr.cqrepoured.structuregen.WorldDungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.structuregen.thewall.WorldWallGenerator;
import team.cqr.cqrepoured.structureprot.ProtectedRegionHelper;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.CopyHelper;
import team.cqr.cqrepoured.util.handlers.GuiHandler;

@Mod(modid="cqrepoured", version="2.3.0B", acceptedMinecraftVersions="[1.12,1.12.2]")
public class CQRMain {
    @Mod.Instance
    public static CQRMain INSTANCE;
    public static final SimpleNetworkWrapper NETWORK;
    @SidedProxy(clientSide="team.cqr.cqrepoured.proxy.ClientProxy", serverSide="team.cqr.cqrepoured.proxy.ServerProxy")
    public static IProxy proxy;
    public static Logger logger;
    public static File CQ_CONFIG_FOLDER;
    public static File CQ_DUNGEON_FOLDER;
    public static File CQ_STRUCTURE_FILES_FOLDER;
    public static File CQ_EXPORT_FILES_FOLDER;
    public static File CQ_CHEST_FOLDER;
    public static File CQ_FACTION_FOLDER;
    public static File CQ_INHABITANT_FOLDER;
    public static File CQ_ITEM_FOLDER;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_SETS;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_ROOT;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC;
    public static boolean isPhosphorInstalled;
    public static boolean isEntityCullingInstalled;
    public static final CreativeTabs CQR_ITEMS_TAB;
    public static final CreativeTabs CQR_BLOCKS_TAB;
    public static final CreativeTabs CQR_CREATIVE_TOOL_TAB;
    public static final CreativeTabs CQR_BANNERS_TAB;
    public static final CreativeTabs CQR_DUNGEON_PLACER_TAB;
    public static final CreativeTabs CQR_EXPORTER_CHEST_TAB;
    public static final CreativeTabs CQR_SPAWN_EGG_TAB;
    public static final WorldDungeonGenerator DUNGEON_GENERATOR;
    public static final WorldWallGenerator WALL_GENERATOR;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.initConfigFolder(event);
        proxy.preInit();
        GameRegistry.registerWorldGenerator((IWorldGenerator)DUNGEON_GENERATOR, (int)100);
        GameRegistry.registerWorldGenerator((IWorldGenerator)WALL_GENERATOR, (int)101);
        EBannerPatternsCQ.values();
        EBanners.values();
        MinecraftForge.EVENT_BUS.register(CQRSerializers.class);
        CQRMessages.registerMessages();
        CQRCapabilities.registerCapabilities();
        CQRLoottables.registerLootTables();
    }

    private void initConfigFolder(FMLPreInitializationEvent event) {
        CQ_CONFIG_FOLDER = new File(event.getModConfigurationDirectory(), "CQR");
        CQ_DUNGEON_FOLDER = new File(CQ_CONFIG_FOLDER, "dungeons");
        CQ_CHEST_FOLDER = new File(CQ_CONFIG_FOLDER, "lootconfigs");
        CQ_STRUCTURE_FILES_FOLDER = new File(CQ_CONFIG_FOLDER, "structures");
        CQ_EXPORT_FILES_FOLDER = new File(CQ_CONFIG_FOLDER, "exporter_output");
        CQ_FACTION_FOLDER = new File(CQ_CONFIG_FOLDER, "factions");
        CQ_INHABITANT_FOLDER = new File(CQ_CONFIG_FOLDER, "dungeon_inhabitants");
        CQ_ITEM_FOLDER = new File(CQ_CONFIG_FOLDER, "items");
        CQ_CUSTOM_TEXTURES_FOLDER_ROOT = new File(CQ_CONFIG_FOLDER, "textures");
        CQ_CUSTOM_TEXTURES_FOLDER_SETS = new File(CQ_CUSTOM_TEXTURES_FOLDER_ROOT, "texture_sets");
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES = new File(CQ_CUSTOM_TEXTURES_FOLDER_ROOT, "textures");
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC = new File(CQ_CUSTOM_TEXTURES_FOLDER_ROOT, "sync");
        File[] subfolders = new File[]{CQ_DUNGEON_FOLDER, CQ_CHEST_FOLDER, CQ_STRUCTURE_FILES_FOLDER, CQ_EXPORT_FILES_FOLDER, CQ_FACTION_FOLDER, CQ_INHABITANT_FOLDER, CQ_ITEM_FOLDER, CQ_CUSTOM_TEXTURES_FOLDER_ROOT, CQ_CUSTOM_TEXTURES_FOLDER_SETS, CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES, CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC};
        if (!CQ_CONFIG_FOLDER.exists() || CQRConfig.general.reinstallDefaultConfigs) {
            CopyHelper.copyFromJarOrWorkspace("/assets/cqrepoured/defaultConfigs", CQ_CONFIG_FOLDER, true);
        }
        int i = CQ_CONFIG_FOLDER.getAbsolutePath().length();
        for (File folder : subfolders) {
            CopyHelper.copyFromJarOrWorkspace("/assets/cqrepoured/defaultConfigs/" + folder.getAbsolutePath().substring(i), folder, false);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        CQRMaterials.setRepairItemsForMaterials();
        BlockFire.func_149843_e();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        isPhosphorInstalled = CQRMain.class.getResource("").getProtocol().equals("jar") && Loader.isModLoaded((String)"phosphor-lighting");
        isEntityCullingInstalled = Loader.isModLoaded((String)"entity_culling");
        DungeonRegistry.getInstance().loadDungeonFiles();
        CQStructure.checkAndUpdateStructureFiles();
        CQStructure.updateSpecialBlocks();
        CQStructure.updateSpecialEntities();
        ProtectedRegionHelper.updateWhitelists();
        CQRDispenseBehaviors.registerDispenseBehaviors();
        EntityCQRNetherDragon.reloadBreakableBlocks();
        DungeonInhabitantManager.instance().loadDungeonInhabitants();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.OrderedLoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            }

            public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
                return Collections.emptyList();
            }
        });
    }

    @Mod.EventHandler
    public static void onFMLServerStartingEvent(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandExport());
        event.registerServerCommand((ICommand)new CommandChangeReputation());
        event.registerServerCommand((ICommand)new CommandGetProtectedRegion());
        TextureSetManager.loadTextureSetsFromFolder(CQ_CUSTOM_TEXTURES_FOLDER_SETS);
        FactionRegistry.instance().loadFactions();
        CQStructure.cacheFiles();
    }

    @Mod.EventHandler
    public static void onFMLServerStoppingEvent(FMLServerStoppingEvent event) {
        FactionRegistry.instance().saveAllReputationData(true);
        CQStructure.clearCache();
    }

    static {
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("cqrepoured");
        logger = null;
        CQ_CONFIG_FOLDER = null;
        CQ_DUNGEON_FOLDER = null;
        CQ_STRUCTURE_FILES_FOLDER = null;
        CQ_EXPORT_FILES_FOLDER = null;
        CQ_CHEST_FOLDER = null;
        CQ_FACTION_FOLDER = null;
        CQ_INHABITANT_FOLDER = null;
        CQ_ITEM_FOLDER = null;
        CQ_CUSTOM_TEXTURES_FOLDER_SETS = null;
        CQ_CUSTOM_TEXTURES_FOLDER_ROOT = null;
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES = null;
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC = null;
        CQR_ITEMS_TAB = new CreativeTabs("cqrepoured_items"){

            public ItemStack func_78016_d() {
                return new ItemStack(CQRItems.BOOTS_CLOUD);
            }
        };
        CQR_BLOCKS_TAB = new CreativeTabs("cqrepoured_blocks"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)CQRBlocks.TABLE_OAK);
            }
        };
        CQR_CREATIVE_TOOL_TAB = new CreativeTabs("cqrepoured_creative_tools"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)CQRBlocks.EXPORTER);
            }
        };
        CQR_BANNERS_TAB = new CreativeTabs("cqrepoured_banners"){

            public ItemStack func_78016_d() {
                return EBanners.WALKER_ORDO.getBanner();
            }

            public void func_78018_a(NonNullList<ItemStack> itemList) {
                super.func_78018_a(itemList);
                List<ItemStack> banners = BannerHelper.addBannersToTabs();
                for (ItemStack stack : banners) {
                    itemList.add((Object)stack);
                }
            }
        };
        CQR_DUNGEON_PLACER_TAB = new CreativeTabs("cqrepoured_dungeon_placers"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cqrepoured", "dungeon_placer_d5")));
            }
        };
        CQR_EXPORTER_CHEST_TAB = new CreativeTabs("cqrepoured_exporter_chests"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)CQRBlocks.EXPORTER_CHEST_VALUABLE);
            }
        };
        CQR_SPAWN_EGG_TAB = new CreativeTabs("cqrepoured_spawn_eggs"){

            public ItemStack func_78016_d() {
                return new ItemStack(Items.field_151063_bx);
            }
        };
        DUNGEON_GENERATOR = new WorldDungeonGenerator();
        WALL_GENERATOR = new WorldWallGenerator();
    }
}

