/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.capability.armor;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.capability.SerializableCapabilityProvider;
import team.cqr.cqrepoured.capability.armor.CapabilityCooldownHandler;
import team.cqr.cqrepoured.capability.armor.CapabilityCooldownHandlerStorage;
import team.cqr.cqrepoured.network.server.packet.SPacketArmorCooldownSync;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class CapabilityCooldownHandlerProvider
extends SerializableCapabilityProvider<CapabilityCooldownHandler> {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("cqrepoured", "item_cooldown_handler");
    @CapabilityInject(value=CapabilityCooldownHandler.class)
    public static final Capability<CapabilityCooldownHandler> CAPABILITY_ITEM_COOLDOWN_CQR = null;

    public CapabilityCooldownHandlerProvider(Capability<CapabilityCooldownHandler> capability, CapabilityCooldownHandler instance) {
        super(capability, instance);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(CapabilityCooldownHandler.class, (Capability.IStorage)new CapabilityCooldownHandlerStorage(), CapabilityCooldownHandler::new);
    }

    public static CapabilityCooldownHandlerProvider createProvider() {
        return new CapabilityCooldownHandlerProvider(CAPABILITY_ITEM_COOLDOWN_CQR, new CapabilityCooldownHandler());
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        CapabilityCooldownHandler icapability = (CapabilityCooldownHandler)entity.getCapability(CAPABILITY_ITEM_COOLDOWN_CQR, null);
        for (Item item : icapability.getItemCooldownMap().keySet()) {
            icapability.reduceCooldown(item);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            CapabilityCooldownHandler icapability = (CapabilityCooldownHandler)event.player.getCapability(CAPABILITY_ITEM_COOLDOWN_CQR, null);
            CQRMain.NETWORK.sendTo((IMessage)new SPacketArmorCooldownSync(icapability.getItemCooldownMap()), (EntityPlayerMP)event.player);
        }
    }
}

