/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.gui.GuiNumberTextField;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.network.client.packet.CPacketAddPathNode;
import team.cqr.cqrepoured.objects.entity.pathfinding.Path;
import team.cqr.cqrepoured.objects.items.ItemPathTool;

@SideOnly(value=Side.CLIENT)
public class GuiAddPathNode
extends GuiScreen {
    private final EnumHand hand;
    private final int rootNodeIndex;
    private final BlockPos pos;
    private final List<GuiTextField> textFieldList = new ArrayList<GuiTextField>();
    private GuiButtonExt buttonConfirm;
    private GuiButtonExt buttonCancel;
    private GuiNumberTextField textFieldX;
    private GuiNumberTextField textFieldY;
    private GuiNumberTextField textFieldZ;
    private GuiNumberTextField textFieldWaitingTimeMin;
    private GuiNumberTextField textFieldWaitingTimeMax;
    private GuiNumberTextField textFieldWaitingRotation;
    private GuiNumberTextField textFieldWeight;
    private GuiNumberTextField textFieldTimeMin;
    private GuiNumberTextField textFieldTimeMax;
    private GuiCheckBox checkBoxBidirectional;
    private final IntList blacklistedPrevNodes = new IntArrayList();
    private int x;
    private int y;
    private int z;
    private int pathMapX;
    private int pathMapY;
    private int pathMapWidth;
    private int pathMapHeight;
    private int centerOffsetX;
    private int centerOffsetY;
    private boolean pathMapClicked;
    private int lastMouseX;
    private int lastMouseY;
    private float mouseOverheadX;
    private float mouseOverheadY;

    public GuiAddPathNode(EnumHand hand, int rootNode, BlockPos pos) {
        this.hand = hand;
        this.rootNodeIndex = rootNode;
        this.pos = pos;
    }

    public void func_73866_w_() {
        this.textFieldList.clear();
        super.func_73866_w_();
        int id = 0;
        int xOffset = -43;
        int yOffset = -80;
        int i = 0;
        this.textFieldX = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, true, false);
        this.textFieldY = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, true, false);
        this.textFieldZ = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, true, false);
        this.textFieldWaitingTimeMin = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, false, false);
        this.textFieldWaitingTimeMax = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, false, false);
        this.textFieldWaitingRotation = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, false, false);
        this.textFieldWeight = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, false, false);
        this.textFieldTimeMin = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, false, false);
        this.textFieldTimeMax = new GuiNumberTextField(id++, this.field_146289_q, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, 40, 12, false, false);
        this.checkBoxBidirectional = new GuiCheckBox(id++, this.field_146294_l / 2 + 1 + xOffset, this.field_146295_m / 2 + 1 + yOffset + i++ * 16, "Bidirectional", true);
        this.buttonConfirm = new GuiButtonExt(id++, this.field_146294_l / 2 - 102, this.field_146295_m - 36, 100, 16, "Confirm");
        this.buttonCancel = new GuiButtonExt(id++, this.field_146294_l / 2 + 2, this.field_146295_m - 36, 100, 16, "Cancel");
        this.textFieldX.func_146180_a(String.valueOf(this.pos.func_177958_n()));
        this.textFieldY.func_146180_a(String.valueOf(this.pos.func_177956_o()));
        this.textFieldZ.func_146180_a(String.valueOf(this.pos.func_177952_p()));
        this.textFieldWaitingTimeMin.func_146180_a("0");
        this.textFieldWaitingTimeMax.func_146180_a("0");
        this.textFieldWaitingRotation.func_146180_a("0");
        this.textFieldWeight.func_146180_a("10");
        this.textFieldTimeMin.func_146180_a("0");
        this.textFieldTimeMax.func_146180_a("24000");
        this.field_146292_n.add(this.buttonConfirm);
        this.field_146292_n.add(this.buttonCancel);
        this.textFieldList.add(this.textFieldX);
        this.textFieldList.add(this.textFieldY);
        this.textFieldList.add(this.textFieldZ);
        this.textFieldList.add(this.textFieldWaitingTimeMin);
        this.textFieldList.add(this.textFieldWaitingTimeMax);
        this.textFieldList.add(this.textFieldWaitingRotation);
        this.textFieldList.add(this.textFieldWeight);
        this.textFieldList.add(this.textFieldTimeMin);
        this.textFieldList.add(this.textFieldTimeMax);
        this.field_146292_n.add(this.checkBoxBidirectional);
        this.blacklistedPrevNodes.clear();
        this.x = this.pos.func_177958_n();
        this.y = this.pos.func_177956_o();
        this.z = this.pos.func_177952_p();
        this.pathMapX = this.field_146294_l / 2 - 192;
        this.pathMapY = this.field_146295_m / 2 - 80;
        this.pathMapWidth = 130;
        this.pathMapHeight = 130;
        ItemStack stack = this.field_146297_k.field_71439_g.func_184586_b(this.hand);
        Path path = ItemPathTool.getPath(stack);
        if (path != null) {
            Path.PathNode rootNode = path.getNode(this.rootNodeIndex);
            if (rootNode != null) {
                this.centerOffsetX = rootNode.getPos().func_177958_n();
                this.centerOffsetY = rootNode.getPos().func_177952_p();
            } else {
                this.centerOffsetX = this.pos.func_177958_n();
                this.centerOffsetY = this.pos.func_177952_p();
            }
        } else {
            this.centerOffsetX = this.pos.func_177958_n();
            this.centerOffsetY = this.pos.func_177952_p();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean textFieldFocused = false;
        for (GuiTextField textField : this.textFieldList) {
            if (!textField.func_146206_l()) continue;
            textFieldFocused = true;
            break;
        }
        if (textFieldFocused) {
            if (keyCode == 1) {
                for (GuiTextField textField : this.textFieldList) {
                    textField.func_146195_b(false);
                }
            } else {
                for (GuiTextField textField : this.textFieldList) {
                    textField.func_146201_a(typedChar, keyCode);
                }
                if (this.textFieldX.func_146206_l()) {
                    try {
                        this.x = Integer.parseInt(this.textFieldX.func_146179_b());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.textFieldY.func_146206_l()) {
                    try {
                        this.y = Integer.parseInt(this.textFieldY.func_146179_b());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.textFieldZ.func_146206_l()) {
                    try {
                        this.z = Integer.parseInt(this.textFieldZ.func_146179_b());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int deltaWheel = Mouse.getEventDWheel();
        if (deltaWheel != 0) {
            int number2;
            int scrollAmount = deltaWheel / 120;
            int i = new ScaledResolution(this.field_146297_k).func_78325_e();
            int mouseX = Mouse.getX() / i;
            int mouseY = this.field_146295_m - Mouse.getY() / i;
            if (mouseX >= this.textFieldX.field_146209_f && mouseX <= this.textFieldX.field_146209_f + this.textFieldX.field_146218_h && mouseY >= this.textFieldX.field_146210_g && mouseY <= this.textFieldX.field_146210_g + this.textFieldX.field_146219_i) {
                try {
                    number2 = Integer.parseInt(this.textFieldX.func_146179_b()) + scrollAmount;
                    this.textFieldX.func_146180_a(String.valueOf(number2));
                    this.x = number2;
                }
                catch (NumberFormatException number2) {
                    // empty catch block
                }
            }
            if (mouseX >= this.textFieldY.field_146209_f && mouseX <= this.textFieldY.field_146209_f + this.textFieldY.field_146218_h && mouseY >= this.textFieldY.field_146210_g && mouseY <= this.textFieldY.field_146210_g + this.textFieldY.field_146219_i) {
                try {
                    number2 = Integer.parseInt(this.textFieldY.func_146179_b()) + scrollAmount;
                    this.textFieldY.func_146180_a(String.valueOf(number2));
                    this.y = number2;
                }
                catch (NumberFormatException number3) {
                    // empty catch block
                }
            }
            if (mouseX >= this.textFieldZ.field_146209_f && mouseX <= this.textFieldZ.field_146209_f + this.textFieldZ.field_146218_h && mouseY >= this.textFieldZ.field_146210_g && mouseY <= this.textFieldZ.field_146210_g + this.textFieldZ.field_146219_i) {
                try {
                    int number4 = Integer.parseInt(this.textFieldZ.func_146179_b()) + scrollAmount;
                    this.textFieldZ.func_146180_a(String.valueOf(number4));
                    this.z = number4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.pathMapClicked && clickedMouseButton == 0) {
            float deltaX = (float)(mouseX - this.lastMouseX) * 0.5f + this.mouseOverheadX;
            float deltaY = (float)(mouseY - this.lastMouseY) * 0.5f + this.mouseOverheadY;
            this.centerOffsetX -= (int)deltaX;
            this.centerOffsetY -= (int)deltaY;
            this.mouseOverheadX = deltaX % 1.0f;
            this.mouseOverheadY = deltaY % 1.0f;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        Path path;
        Path.PathNode rootNode;
        Path.PathNode clickedNode;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiTextField textField : this.textFieldList) {
            textField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        int minX = this.pathMapX;
        int minY = this.pathMapY;
        int maxX = this.pathMapX + this.pathMapWidth;
        int maxY = this.pathMapY + this.pathMapHeight;
        if (mouseButton == 0 && mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
            this.pathMapClicked = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        } else {
            this.pathMapClicked = false;
        }
        if (mouseButton == 0 && (clickedNode = this.getNodeAt(mouseX, mouseY)) != null && (rootNode = (path = ItemPathTool.getPath(this.field_146297_k.field_71439_g.func_184586_b(this.hand))).getNode(this.rootNodeIndex)) != null && clickedNode.getConnectedNodes().contains(this.rootNodeIndex)) {
            if (!this.blacklistedPrevNodes.contains(clickedNode.getIndex())) {
                this.blacklistedPrevNodes.add(clickedNode.getIndex());
            } else {
                this.blacklistedPrevNodes.rem(clickedNode.getIndex());
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField textField : this.textFieldList) {
            textField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Add Path Node (Index: " + ItemPathTool.getPath(this.field_146297_k.field_71439_g.func_184586_b(this.hand)).getSize() + ")", this.field_146294_l / 2, 20, 0xFFFFFF);
        for (GuiTextField textField : this.textFieldList) {
            textField.func_146194_f();
        }
        int xOffset = 1;
        int yOffset = -77;
        int i = 0;
        GuiHelper.drawString(this.field_146289_q, "Node X", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Node Y", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Node Z", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Waiting Time Min", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Waiting Time Max", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Waiting Rotation", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Weight", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Time Min", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Time Max", this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset + i++ * 16, 0xE0E0E0, false, true);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawPathMap(this.pathMapX, this.pathMapY, this.pathMapWidth, this.pathMapHeight, this.centerOffsetX, this.centerOffsetY);
        GuiHelper.drawString(this.field_146289_q, "Help?", this.pathMapX, this.pathMapY + this.pathMapHeight + 4, 0xE0E0E0, false, true);
        Path.PathNode selectedNode = this.getNodeAt(mouseX, mouseY);
        if (selectedNode != null) {
            this.func_146279_a(String.format("Index: %d, %s", selectedNode.getIndex(), selectedNode.getPos()), mouseX, mouseY);
        }
        if (mouseX >= this.pathMapX && mouseX <= this.pathMapX + this.field_146289_q.func_78256_a("Help?") && mouseY >= this.pathMapY + this.pathMapHeight + 4 && mouseY <= this.pathMapY + this.pathMapHeight + 12) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("The path map shows the current path from above and visualizes the 'new node'.");
            tooltip.add("Also it allows you to select 'blacklisted previous nodes' for the 'new node'. That means when an entity is at one of the nodes connected with the 'new node' and comes from a 'blacklisted previous node' it won't go to the 'new node'.");
            tooltip.add("");
            tooltip.add("Blue Node: New Node");
            tooltip.add("Black Node: Selected Node");
            tooltip.add("Grey Node: Normal Node");
            tooltip.add("Red Node: Blacklisted Previous Node");
            this.func_146283_a(tooltip, mouseX, mouseY);
        }
        if (this.textFieldWaitingTimeMin.isMouseOver(mouseX, mouseY)) {
            this.func_146279_a("When reaching this node this defines how long the entity waits at least before walking to the next node. (min: 0, max: 24000 ticks)", mouseX, mouseY);
        }
        if (this.textFieldWaitingTimeMax.isMouseOver(mouseX, mouseY)) {
            this.func_146279_a("When reaching this node this defines how long the entity waits at most before walking to the next node. (min: 0, max: 24000 ticks)", mouseX, mouseY);
        }
        if (this.textFieldWaitingRotation.isMouseOver(mouseX, mouseY)) {
            this.func_146279_a("When waiting at this node this defines where the entity should look. (min: 0, max: 360 degree)", mouseX, mouseY);
        }
        if (this.textFieldWeight.isMouseOver(mouseX, mouseY)) {
            this.func_146279_a("The weight that this node is selected as the next node when there are multiple options. (min: 1, max: 10000)", mouseX, mouseY);
        }
        if (this.textFieldTimeMin.isMouseOver(mouseX, mouseY)) {
            this.func_146279_a("The node can only be selected as the next node when the time is between 'Time Min' and 'Time Max'. (0=morning, 6000=noon, 12000=evening, 18000=midnight) (min: 0, max: 24000 ticks)", mouseX, mouseY);
        }
        if (this.textFieldTimeMax.isMouseOver(mouseX, mouseY)) {
            this.func_146279_a("The node can only be selected as the next node when the time is between 'Time Min' and 'Time Max'. (0=morning, 6000=noon, 12000=evening, 18000=midnight) (min: 0, max: 24000 ticks)", mouseX, mouseY);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.buttonConfirm) {
            try {
                int posX = this.textFieldX.getInt();
                int posY = this.textFieldY.getInt();
                int posZ = this.textFieldZ.getInt();
                int waitingTimeMin = this.textFieldWaitingTimeMin.getInt();
                int waitingTimeMax = this.textFieldWaitingTimeMax.getInt();
                float waitingRotation = this.textFieldWaitingRotation.getInt();
                int weight = this.textFieldWeight.getInt();
                int timeMin = this.textFieldTimeMin.getInt();
                int timeMax = this.textFieldTimeMax.getInt();
                boolean bidirectional = this.checkBoxBidirectional.isChecked();
                CQRMain.NETWORK.sendToServer((IMessage)new CPacketAddPathNode(this.hand, this.rootNodeIndex, new BlockPos(posX, posY, posZ), waitingTimeMin, waitingTimeMax, waitingRotation, weight, timeMin, timeMax, bidirectional, (IntCollection)this.blacklistedPrevNodes));
            }
            catch (NumberFormatException e) {
                this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Invalid path node arguments!"));
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (button == this.buttonCancel) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_146284_a(button);
        }
    }

    @Nullable
    private Path.PathNode getNodeAt(int mouseX, int mouseY) {
        if (mouseX < this.pathMapX || mouseX > this.pathMapX + this.pathMapWidth) {
            return null;
        }
        if (mouseY < this.pathMapY || mouseY > this.pathMapY + this.pathMapHeight) {
            return null;
        }
        Path path = ItemPathTool.getPath(this.field_146297_k.field_71439_g.func_184586_b(this.hand));
        Path.PathNode clickedNode = null;
        int posX = (mouseX - this.pathMapX - this.pathMapWidth / 2) / 2 + this.centerOffsetX;
        int posY = (mouseY - this.pathMapY - this.pathMapHeight / 2) / 2 + this.centerOffsetY;
        for (Path.PathNode node : path.getNodes()) {
            if (node.getPos().func_177958_n() != posX || node.getPos().func_177952_p() != posY) continue;
            clickedNode = node;
            break;
        }
        for (Path.PathNode node : path.getNodes()) {
            int nodeX = node.getPos().func_177958_n();
            int nodeZ = node.getPos().func_177952_p();
            if (Math.abs(nodeX - posX) > 1 || Math.abs(nodeZ - posY) > 1) continue;
            clickedNode = node;
            break;
        }
        return clickedNode;
    }

    private void drawPathMap(int x, int y, int width, int height, int centerX, int centerY) {
        boolean flag;
        int offsetZ;
        int offsetX;
        int radiusX = (width /= 2) / 2;
        int radiusY = (height /= 2) / 2;
        Path path = ItemPathTool.getPath(this.field_146297_k.field_71439_g.func_184586_b(this.hand));
        Path.PathNode rootNode = path.getNode(this.rootNodeIndex);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)2.0, (double)2.0, (double)1.0);
        GL11.glDisable((int)3553);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)height);
        GL11.glVertex2d((double)width, (double)height);
        GL11.glVertex2d((double)width, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glEnd();
        GL11.glTranslated((double)((double)radiusX + 0.5), (double)((double)radiusY + 0.5), (double)0.0);
        GL11.glColor4d((double)0.5, (double)0.5, (double)0.5, (double)1.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glLineWidth((float)new ScaledResolution(this.field_146297_k).func_78325_e());
        GL11.glBegin((int)1);
        for (Path.PathNode node : path.getNodes()) {
            offsetX = node.getPos().func_177958_n() - centerX;
            offsetZ = node.getPos().func_177952_p() - centerY;
            flag = offsetX < -radiusX || offsetX > radiusX || offsetZ < -radiusY || offsetZ > radiusY;
            IntListIterator intListIterator = node.getConnectedNodes().iterator();
            while (intListIterator.hasNext()) {
                int index = (Integer)intListIterator.next();
                Path.PathNode connectedNode = path.getNode(index);
                int offsetX2 = connectedNode.getPos().func_177958_n() - centerX;
                int offsetZ2 = connectedNode.getPos().func_177952_p() - centerY;
                boolean flag2 = offsetX2 < -radiusX || offsetX2 > radiusX || offsetZ2 < -radiusY || offsetZ2 > radiusY;
                Vec2f start = null;
                Vec2f end = null;
                start = flag ? this.calculateIntercept(offsetX2, offsetZ2, offsetX, offsetZ, -radiusX - 1, -radiusY - 1, radiusX + 1, radiusY + 1) : new Vec2f((float)offsetX, (float)offsetZ);
                end = flag2 ? this.calculateIntercept(offsetX, offsetZ, offsetX2, offsetZ2, -radiusX - 1, -radiusY - 1, radiusX + 1, radiusY + 1) : new Vec2f((float)offsetX2, (float)offsetZ2);
                if (start == null || end == null) continue;
                GL11.glVertex2d((double)start.field_189982_i, (double)start.field_189983_j);
                GL11.glVertex2d((double)end.field_189982_i, (double)end.field_189983_j);
            }
        }
        if (rootNode != null) {
            GL11.glColor4d((double)0.0, (double)0.35, (double)0.7, (double)0.5);
            int offsetX2 = this.x - centerX;
            int offsetZ2 = this.z - centerY;
            int offsetX22 = rootNode.getPos().func_177958_n() - centerX;
            int offsetZ22 = rootNode.getPos().func_177952_p() - centerY;
            flag = offsetX2 < -radiusX || offsetX2 > radiusX || offsetZ2 < -radiusY || offsetZ2 > radiusY;
            boolean flag2 = offsetX22 < -radiusX || offsetX22 > radiusX || offsetZ22 < -radiusY || offsetZ22 > radiusY;
            Vec2f start = null;
            Vec2f end = null;
            start = flag ? this.calculateIntercept(offsetX22, offsetZ22, offsetX2, offsetZ2, -radiusX - 1, -radiusY - 1, radiusX + 1, radiusY + 1) : new Vec2f((float)offsetX2, (float)offsetZ2);
            end = flag2 ? this.calculateIntercept(offsetX2, offsetZ2, offsetX22, offsetZ22, -radiusX - 1, -radiusY - 1, radiusX + 1, radiusY + 1) : new Vec2f((float)offsetX22, (float)offsetZ22);
            if (start != null && end != null) {
                GL11.glVertex2d((double)start.field_189982_i, (double)start.field_189983_j);
                GL11.glVertex2d((double)end.field_189982_i, (double)end.field_189983_j);
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("cqrepoured", "textures/gui/path_map.png"));
        GL11.glBegin((int)7);
        for (Path.PathNode node : path.getNodes()) {
            offsetX = node.getPos().func_177958_n() - centerX;
            offsetZ = node.getPos().func_177952_p() - centerY;
            if (offsetX < -radiusX || offsetX > radiusX || offsetZ < -radiusY || offsetZ > radiusY) continue;
            if (node == rootNode) {
                this.drawnRootNode(offsetX, offsetZ);
                continue;
            }
            if (this.blacklistedPrevNodes.contains(node.getIndex())) {
                this.drawSelectedNode(offsetX, offsetZ);
                continue;
            }
            this.drawNode(offsetX, offsetZ);
        }
        int offsetX3 = this.x - centerX;
        int offsetZ3 = this.z - centerY;
        if (offsetX3 >= -radiusX && offsetX3 <= radiusX && offsetZ3 >= -radiusY && offsetZ3 <= radiusY) {
            this.drawNewNode(offsetX3, offsetZ3);
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    @Nullable
    private Vec2f calculateIntercept(float x1, float y1, float x2, float y2, float minX, float minY, float maxX, float maxY) {
        Vec2f result = null;
        Vec2f vec = this.intersectionPoint(x1, y1, x2, y2, minX, minY, minX, maxY);
        if (vec != null && this.isInside(vec, minX, minY, maxX, maxY)) {
            result = vec;
        }
        if ((vec = this.intersectionPoint(x1, y1, x2, y2, minX, minY, maxX, minY)) != null && this.isInside(vec, minX, minY, maxX, maxY)) {
            result = this.getNearest(x2, y2, vec, result);
        }
        if ((vec = this.intersectionPoint(x1, y1, x2, y2, minX, maxY, maxX, maxY)) != null && this.isInside(vec, minX, minY, maxX, maxY)) {
            result = this.getNearest(x2, y2, vec, result);
        }
        if ((vec = this.intersectionPoint(x1, y1, x2, y2, maxX, minY, maxX, maxY)) != null && this.isInside(vec, minX, minY, maxX, maxY)) {
            result = this.getNearest(x2, y2, vec, result);
        }
        return result;
    }

    @Nullable
    private Vec2f intersectionPoint(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float f1 = x2 - x1;
        float f4 = y4 - y3;
        float f2 = y2 - y1;
        float f3 = x4 - x3;
        float f5 = f1 * f4 - f2 * f3;
        if (f5 == 0.0f) {
            return null;
        }
        float f6 = x1 * y2 - y1 * x2;
        float f7 = x3 * y4 - y3 * x4;
        float f8 = 1.0f / f5;
        return new Vec2f((f7 * f1 - f6 * f3) * f8, (f7 * f2 - f6 * f4) * f8);
    }

    @Nullable
    private Vec2f getNearest(float x1, float y1, @Nullable Vec2f vec1, @Nullable Vec2f vec2) {
        if (vec1 == null) {
            return vec2;
        }
        if (vec2 == null) {
            return vec1;
        }
        float f1 = vec1.field_189982_i - x1;
        float f2 = vec1.field_189983_j - y1;
        float f3 = f1 * f1 + f2 * f2;
        float f4 = (f1 = vec2.field_189982_i - x1) * f1 + (f2 = vec2.field_189983_j - y1) * f2;
        if (f3 <= f4) {
            return vec1;
        }
        return vec2;
    }

    private boolean isInside(Vec2f vec, float minX, float minY, float maxX, float maxY) {
        return vec.field_189982_i >= minX - 0.001f && vec.field_189982_i <= maxX + 0.001f && vec.field_189983_j >= minY - 0.001f && vec.field_189983_j <= maxY + 0.001f;
    }

    private void drawNode(double x, double y) {
        GL11.glTexCoord2d((double)0.0, (double)0.5);
        GL11.glVertex2d((double)(x - 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)0.5, (double)0.5);
        GL11.glVertex2d((double)(x + 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)0.5, (double)0.0);
        GL11.glVertex2d((double)(x + 1.0), (double)(y - 1.0));
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)(x - 1.0), (double)(y - 1.0));
    }

    private void drawSelectedNode(double x, double y) {
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)(x - 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)0.5, (double)1.0);
        GL11.glVertex2d((double)(x + 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)0.5, (double)0.5);
        GL11.glVertex2d((double)(x + 1.0), (double)(y - 1.0));
        GL11.glTexCoord2d((double)0.0, (double)0.5);
        GL11.glVertex2d((double)(x - 1.0), (double)(y - 1.0));
    }

    private void drawnRootNode(double x, double y) {
        GL11.glTexCoord2d((double)0.5, (double)0.5);
        GL11.glVertex2d((double)(x - 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)1.0, (double)0.5);
        GL11.glVertex2d((double)(x + 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)(x + 1.0), (double)(y - 1.0));
        GL11.glTexCoord2d((double)0.5, (double)0.0);
        GL11.glVertex2d((double)(x - 1.0), (double)(y - 1.0));
    }

    private void drawNewNode(double x, double y) {
        GL11.glTexCoord2d((double)0.5, (double)1.0);
        GL11.glVertex2d((double)(x - 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)(x + 1.0), (double)(y + 1.0));
        GL11.glTexCoord2d((double)1.0, (double)0.5);
        GL11.glVertex2d((double)(x + 1.0), (double)(y - 1.0));
        GL11.glTexCoord2d((double)0.5, (double)0.5);
        GL11.glVertex2d((double)(x - 1.0), (double)(y - 1.0));
    }
}

