/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.tileentity.TileEntityExporter;

@SideOnly(value=Side.CLIENT)
public class GuiExporter
extends GuiScreen {
    private boolean saveStructOnExit = false;
    private TileEntityExporter exporter;
    private GuiButtonExt btnExport;
    private GuiTextField edtName;
    private GuiTextField edtEndX;
    private GuiTextField edtEndY;
    private GuiTextField edtEndZ;
    private GuiTextField edtStartX;
    private GuiTextField edtStartY;
    private GuiTextField edtStartZ;
    private GuiTextField edtUnprotectedBlocks;
    private GuiCheckBox chbxRelativeMode;
    private GuiCheckBox chbxIgnoreEntities;

    public GuiExporter(TileEntityExporter exporter) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.exporter = exporter;
    }

    public void sync() {
        this.edtEndX.func_146180_a(String.valueOf(this.exporter.getEndX()));
        this.edtEndY.func_146180_a(String.valueOf(this.exporter.getEndY()));
        this.edtEndZ.func_146180_a(String.valueOf(this.exporter.getEndZ()));
        this.edtStartX.func_146180_a(String.valueOf(this.exporter.getStartX()));
        this.edtStartY.func_146180_a(String.valueOf(this.exporter.getStartY()));
        this.edtStartZ.func_146180_a(String.valueOf(this.exporter.getStartZ()));
        this.edtName.func_146180_a(this.exporter.getStructureName());
        this.chbxRelativeMode.setIsChecked(this.exporter.isRelativeMode());
        this.chbxIgnoreEntities.setIsChecked(this.exporter.isIgnoreEntities());
        StringBuilder sb = new StringBuilder();
        BlockPos[] arr = this.exporter.getUnprotectedBlocks();
        if (arr.length > 0) {
            sb.append(arr[0].func_177958_n());
            sb.append(',');
            sb.append(arr[0].func_177956_o());
            sb.append(',');
            sb.append(arr[0].func_177952_p());
            for (int i = 1; i < arr.length; ++i) {
                sb.append(';');
                sb.append(' ');
                sb.append(arr[i].func_177958_n());
                sb.append(',');
                sb.append(arr[i].func_177956_o());
                sb.append(',');
                sb.append(arr[i].func_177952_p());
            }
        }
        this.edtUnprotectedBlocks.func_146180_a(sb.toString());
    }

    public void func_73866_w_() {
        int index = 0;
        this.edtName = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70, this.field_146295_m / 2 - 70, 140, 20);
        this.edtName.func_146180_a(this.exporter.getStructureName());
        this.edtEndX = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 10, 40, 20);
        this.edtEndX.func_146180_a(String.valueOf(this.exporter.getEndX()));
        this.edtEndY = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70 + 50, this.field_146295_m / 2 + 10, 40, 20);
        this.edtEndY.func_146180_a(String.valueOf(this.exporter.getEndY()));
        this.edtEndZ = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70 + 50 + 50, this.field_146295_m / 2 + 10, 40, 20);
        this.edtEndZ.func_146180_a(String.valueOf(this.exporter.getEndZ()));
        this.edtStartX = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70, this.field_146295_m / 2 - 30, 40, 20);
        this.edtStartX.func_146180_a(String.valueOf(this.exporter.getStartX()));
        this.edtStartY = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70 + 50, this.field_146295_m / 2 - 30, 40, 20);
        this.edtStartY.func_146180_a(String.valueOf(this.exporter.getStartY()));
        this.edtStartZ = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70 + 50 + 50, this.field_146295_m / 2 - 30, 40, 20);
        this.edtStartZ.func_146180_a(String.valueOf(this.exporter.getStartZ()));
        this.chbxRelativeMode = new GuiCheckBox(index++, this.field_146294_l / 2 + 30, this.field_146295_m / 2 + 40, "Use Relative Mode", this.exporter.isRelativeMode());
        this.chbxIgnoreEntities = new GuiCheckBox(index++, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 40, "Ignore Entities", this.exporter.isIgnoreEntities());
        this.edtUnprotectedBlocks = new GuiTextField(index++, this.field_146289_q, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 60, 140, 20);
        StringBuilder sb = new StringBuilder();
        BlockPos[] arr = this.exporter.getUnprotectedBlocks();
        if (arr.length > 0) {
            sb.append(arr[0].func_177958_n());
            sb.append(',');
            sb.append(arr[0].func_177956_o());
            sb.append(',');
            sb.append(arr[0].func_177952_p());
            for (int i = 1; i < arr.length; ++i) {
                sb.append(';');
                sb.append(' ');
                sb.append(arr[i].func_177958_n());
                sb.append(',');
                sb.append(arr[i].func_177956_o());
                sb.append(',');
                sb.append(arr[i].func_177952_p());
            }
        }
        this.edtUnprotectedBlocks.func_146180_a(sb.toString());
        this.btnExport = new GuiButtonExt(index++, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 90, 140, 20, "Export");
        this.field_146292_n.add(this.chbxRelativeMode);
        this.field_146292_n.add(this.chbxIgnoreEntities);
        this.field_146292_n.add(this.btnExport);
    }

    public void func_146281_b() {
        try {
            BlockPos[] unprotectedBlocks;
            String structName = this.edtName.func_146179_b();
            if (structName.isEmpty()) {
                throw new IllegalArgumentException();
            }
            int startX = Integer.parseInt(this.edtStartX.func_146179_b());
            int startY = Integer.parseInt(this.edtStartY.func_146179_b());
            int startZ = Integer.parseInt(this.edtStartZ.func_146179_b());
            int endX = Integer.parseInt(this.edtEndX.func_146179_b());
            int endY = Integer.parseInt(this.edtEndY.func_146179_b());
            int endZ = Integer.parseInt(this.edtEndZ.func_146179_b());
            if (!this.edtUnprotectedBlocks.func_146179_b().isEmpty()) {
                String[] arr = this.edtUnprotectedBlocks.func_146179_b().split(";");
                unprotectedBlocks = new BlockPos[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    String[] arr1 = arr[i].split(",");
                    unprotectedBlocks[i] = new BlockPos(Integer.parseInt(arr1[0].trim()), Integer.parseInt(arr1[1].trim()), Integer.parseInt(arr1[2].trim()));
                }
            } else {
                unprotectedBlocks = new BlockPos[]{};
            }
            this.exporter.setValues(structName, startX, startY, startZ, endX, endY, endZ, this.chbxRelativeMode.isChecked(), this.chbxIgnoreEntities.isChecked(), unprotectedBlocks);
            if (this.saveStructOnExit) {
                this.exporter.saveStructure((EntityPlayer)this.field_146297_k.field_71439_g);
            }
        }
        catch (Exception e) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Invalid exporter arguments"));
        }
        super.func_146281_b();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.edtName.func_146206_l() || this.edtStartX.func_146206_l() || this.edtStartY.func_146206_l() || this.edtStartZ.func_146206_l() || this.edtEndX.func_146206_l() || this.edtEndY.func_146206_l() || this.edtEndZ.func_146206_l() || this.edtUnprotectedBlocks.func_146206_l()) {
            if (keyCode == 1) {
                this.edtName.func_146195_b(false);
                this.edtStartX.func_146195_b(false);
                this.edtStartY.func_146195_b(false);
                this.edtStartZ.func_146195_b(false);
                this.edtEndX.func_146195_b(false);
                this.edtEndY.func_146195_b(false);
                this.edtEndZ.func_146195_b(false);
                this.edtUnprotectedBlocks.func_146195_b(false);
            } else {
                this.edtName.func_146201_a(typedChar, keyCode);
                if (GuiHelper.isValidCharForNumberTextField(typedChar, keyCode, true, false)) {
                    this.edtStartX.func_146201_a(typedChar, keyCode);
                    this.edtStartY.func_146201_a(typedChar, keyCode);
                    this.edtStartZ.func_146201_a(typedChar, keyCode);
                    this.edtEndX.func_146201_a(typedChar, keyCode);
                    this.edtEndY.func_146201_a(typedChar, keyCode);
                    this.edtEndZ.func_146201_a(typedChar, keyCode);
                }
                this.edtUnprotectedBlocks.func_146201_a(typedChar, keyCode);
            }
        } else if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.edtName.func_146192_a(mouseX, mouseY, mouseButton);
        this.edtEndX.func_146192_a(mouseX, mouseY, mouseButton);
        this.edtEndY.func_146192_a(mouseX, mouseY, mouseButton);
        this.edtEndZ.func_146192_a(mouseX, mouseY, mouseButton);
        this.edtStartX.func_146192_a(mouseX, mouseY, mouseButton);
        this.edtStartY.func_146192_a(mouseX, mouseY, mouseButton);
        this.edtStartZ.func_146192_a(mouseX, mouseY, mouseButton);
        this.edtUnprotectedBlocks.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.edtName.func_146178_a();
        this.edtEndX.func_146178_a();
        this.edtEndY.func_146178_a();
        this.edtEndZ.func_146178_a();
        this.edtStartX.func_146178_a();
        this.edtStartY.func_146178_a();
        this.edtStartZ.func_146178_a();
        this.edtUnprotectedBlocks.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"tile.exporter.name", (Object[])new Object[0]), this.field_146294_l / 2, 20, 0xFFFFFF);
        this.edtName.func_146194_f();
        this.edtEndX.func_146194_f();
        this.edtEndY.func_146194_f();
        this.edtEndZ.func_146194_f();
        this.edtStartX.func_146194_f();
        this.edtStartY.func_146194_f();
        this.edtStartZ.func_146194_f();
        this.edtUnprotectedBlocks.func_146194_f();
        this.func_73731_b(this.field_146289_q, "Structure Name", this.field_146294_l / 2 - 70, this.field_146295_m / 2 - 80, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "Start X", this.field_146294_l / 2 - 70, this.field_146295_m / 2 - 40, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "Start Y", this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 40, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "Start Z", this.field_146294_l / 2 + 30, this.field_146295_m / 2 - 40, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "End X", this.field_146294_l / 2 - 70, this.field_146295_m / 2, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "End Y", this.field_146294_l / 2 - 20, this.field_146295_m / 2, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "End Z", this.field_146294_l / 2 + 30, this.field_146295_m / 2, 0xA0A0A0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.chbxRelativeMode.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_exporter_relative_mode.name", (Object[])new Object[0]), mouseX, mouseY);
        } else if (this.chbxIgnoreEntities.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_exporter_ignore_entities.name", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.btnExport) {
            this.saveStructOnExit = true;
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_146284_a(button);
            if (button == this.chbxRelativeMode) {
                boolean flag = this.chbxRelativeMode.isChecked();
                BlockPos pos = this.exporter.func_174877_v();
                try {
                    this.edtStartX.func_146180_a(Integer.toString(Integer.parseInt(this.edtStartX.func_146179_b()) + (flag ? -pos.func_177958_n() : pos.func_177958_n())));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.edtStartY.func_146180_a(Integer.toString(Integer.parseInt(this.edtStartY.func_146179_b()) + (flag ? -pos.func_177956_o() : pos.func_177956_o())));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.edtStartZ.func_146180_a(Integer.toString(Integer.parseInt(this.edtStartZ.func_146179_b()) + (flag ? -pos.func_177952_p() : pos.func_177952_p())));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.edtEndX.func_146180_a(Integer.toString(Integer.parseInt(this.edtEndX.func_146179_b()) + (flag ? -pos.func_177958_n() : pos.func_177958_n())));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.edtEndY.func_146180_a(Integer.toString(Integer.parseInt(this.edtEndY.func_146179_b()) + (flag ? -pos.func_177956_o() : pos.func_177956_o())));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.edtEndZ.func_146180_a(Integer.toString(Integer.parseInt(this.edtEndZ.func_146179_b()) + (flag ? -pos.func_177952_p() : pos.func_177952_p())));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

