/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.client.gui.GuiButtonCustom;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.tileentity.TileEntityMap;

@SideOnly(value=Side.CLIENT)
public class GuiMapPlaceholder
extends GuiScreen {
    private final TileEntityMap tileEntity;
    private GuiTextField scale;
    private GuiButtonOrientation orientation;
    private GuiCheckBox lockOrientation;
    private GuiTextField originX;
    private GuiTextField originZ;
    private GuiTextField offsetX;
    private GuiTextField offsetZ;
    private GuiCheckBox fillMap;
    private GuiTextField fillRadius;

    public GuiMapPlaceholder(TileEntityMap tileEntity) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.tileEntity = tileEntity;
    }

    public void sync() {
        this.scale.func_146180_a(String.valueOf(this.tileEntity.getScale()));
        this.orientation.setDisplayString(this.tileEntity.getOrientation());
        this.lockOrientation.setIsChecked(this.tileEntity.lockOrientation());
        this.originX.func_146180_a(String.valueOf(this.tileEntity.getOriginX()));
        this.originZ.func_146180_a(String.valueOf(this.tileEntity.getOriginZ()));
        this.offsetX.func_146180_a(String.valueOf(this.tileEntity.getOffsetX()));
        this.offsetZ.func_146180_a(String.valueOf(this.tileEntity.getOffsetZ()));
        this.fillMap.setIsChecked(this.tileEntity.fillMap());
        this.fillRadius.func_146180_a(String.valueOf(this.tileEntity.getFillRadius()));
    }

    public void func_73866_w_() {
        this.scale = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 1 - 38, this.field_146295_m / 2 + 1 - 72, 38, 12);
        this.orientation = new GuiButtonOrientation(1, this.field_146294_l / 2 - 38, this.field_146295_m / 2 - 72 + 16, 40, 14, this.tileEntity.getOrientation());
        this.lockOrientation = new GuiCheckBox(2, this.field_146294_l / 2 + 1 - 38, this.field_146295_m / 2 + 1 - 72 + 32, "Lock Orientation", this.tileEntity.lockOrientation());
        this.originX = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 2 + 1 - 38, this.field_146295_m / 2 + 1 - 72 + 48, 38, 12);
        this.originZ = new GuiTextField(4, this.field_146289_q, this.field_146294_l / 2 + 1 - 38, this.field_146295_m / 2 + 1 - 72 + 64, 38, 12);
        this.offsetX = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 2 + 1 - 38, this.field_146295_m / 2 + 1 - 72 + 80, 38, 12);
        this.offsetZ = new GuiTextField(6, this.field_146289_q, this.field_146294_l / 2 + 1 - 38, this.field_146295_m / 2 + 1 - 72 + 96, 38, 12);
        this.fillMap = new GuiCheckBox(7, this.field_146294_l / 2 - 1 - 38, this.field_146295_m / 2 + 1 - 72 + 112, "Fill Map", this.tileEntity.fillMap());
        this.fillRadius = new GuiTextField(8, this.field_146289_q, this.field_146294_l / 2 + 1 - 38, this.field_146295_m / 2 + 1 - 72 + 128, 38, 12);
        this.sync();
        this.field_146292_n.add(this.orientation);
        this.field_146292_n.add(this.lockOrientation);
        this.field_146292_n.add(this.fillMap);
    }

    public void func_146281_b() {
        try {
            int scale = Integer.parseInt(this.scale.func_146179_b());
            EnumFacing orientation = this.orientation.getDirection();
            boolean lockOrientation = this.lockOrientation.isChecked();
            int originX = Integer.parseInt(this.originX.func_146179_b());
            int originZ = Integer.parseInt(this.originZ.func_146179_b());
            int offsetX = Integer.parseInt(this.offsetX.func_146179_b());
            int offsetZ = Integer.parseInt(this.offsetZ.func_146179_b());
            boolean fillMap = this.fillMap.isChecked();
            int fillRadius = Integer.parseInt(this.fillRadius.func_146179_b());
            this.tileEntity.set(scale, orientation, lockOrientation, originX, originZ, offsetX, offsetZ, fillMap, fillRadius);
        }
        catch (IllegalArgumentException e) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments"));
        }
        super.func_146281_b();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.scale.func_146206_l() || this.originX.func_146206_l() || this.originZ.func_146206_l() || this.offsetX.func_146206_l() || this.offsetZ.func_146206_l() || this.fillRadius.func_146206_l()) {
            if (keyCode == 1) {
                this.scale.func_146195_b(false);
                this.originX.func_146195_b(false);
                this.originZ.func_146195_b(false);
                this.offsetX.func_146195_b(false);
                this.offsetZ.func_146195_b(false);
                this.fillRadius.func_146195_b(false);
            } else if (GuiHelper.isValidCharForNumberTextField(typedChar, keyCode, true, false)) {
                this.scale.func_146201_a(typedChar, keyCode);
                this.originX.func_146201_a(typedChar, keyCode);
                this.originZ.func_146201_a(typedChar, keyCode);
                this.offsetX.func_146201_a(typedChar, keyCode);
                this.offsetZ.func_146201_a(typedChar, keyCode);
                this.fillRadius.func_146201_a(typedChar, keyCode);
            }
        } else if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.scale.func_146192_a(mouseX, mouseY, mouseButton);
        this.originX.func_146192_a(mouseX, mouseY, mouseButton);
        this.originZ.func_146192_a(mouseX, mouseY, mouseButton);
        this.offsetX.func_146192_a(mouseX, mouseY, mouseButton);
        this.offsetZ.func_146192_a(mouseX, mouseY, mouseButton);
        this.fillRadius.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.orientation.func_146115_a() && (mouseButton == 0 || mouseButton == 1)) {
            if (mouseButton == 1) {
                this.orientation.func_146113_a(this.field_146297_k.func_147118_V());
            }
            this.orientation.onMouseClick(mouseButton == 0);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.scale.func_146178_a();
        this.originX.func_146178_a();
        this.originZ.func_146178_a();
        this.offsetX.func_146178_a();
        this.offsetZ.func_146178_a();
        this.fillRadius.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.scale.func_146194_f();
        this.originX.func_146194_f();
        this.originZ.func_146194_f();
        this.offsetX.func_146194_f();
        this.offsetZ.func_146194_f();
        this.fillRadius.func_146194_f();
        GuiHelper.drawString(this.field_146289_q, "Scale", this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 72 + 3, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Orientation", this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 72 + 3 + 16, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Origin X", this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 72 + 3 + 48, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Origin Z", this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 72 + 3 + 64, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Offset X", this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 72 + 3 + 80, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Offset Z", this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 72 + 3 + 96, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Fill Radius", this.field_146294_l / 2 + 4, this.field_146295_m / 2 - 72 + 3 + 128, 0xE0E0E0, false, true);
        GuiHelper.drawString(this.field_146289_q, "Map", this.field_146294_l / 2, this.field_146295_m / 2 - 96, 0xFFFFFF, true, true);
    }

    public boolean func_73868_f() {
        return false;
    }

    public class GuiButtonOrientation
    extends GuiButtonCustom {
        private final String[] displayStrings;
        private int index;

        public GuiButtonOrientation(int buttonId, int x, int y, int width, int height, EnumFacing orientation) {
            super(buttonId, x, y, width, height, "");
            this.displayStrings = new String[]{"North", "East", "South", "West"};
            this.index = 0;
            this.setDisplayString(orientation);
        }

        public void onMouseClick(boolean leftClick) {
            this.index = leftClick ? (this.index < this.displayStrings.length - 1 ? this.index + 1 : 0) : (this.index > 0 ? this.index - 1 : this.displayStrings.length - 1);
            this.field_146126_j = this.displayStrings[this.index];
        }

        public void setDisplayString(EnumFacing orientation) {
            switch (orientation) {
                case EAST: {
                    this.index = 1;
                    break;
                }
                case SOUTH: {
                    this.index = 2;
                    break;
                }
                case WEST: {
                    this.index = 3;
                    break;
                }
                default: {
                    this.index = 0;
                }
            }
            this.field_146126_j = this.displayStrings[this.index];
        }

        public EnumFacing getDirection() {
            switch (this.index) {
                case 1: {
                    return EnumFacing.EAST;
                }
                case 2: {
                    return EnumFacing.SOUTH;
                }
                case 3: {
                    return EnumFacing.WEST;
                }
            }
            return EnumFacing.NORTH;
        }
    }
}

