/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui.npceditor;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.gui.npceditor.GuiButtonReputation;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.network.client.packet.CPacketEditTrade;
import team.cqr.cqrepoured.network.client.packet.CPacketOpenMerchantGui;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.npc.trading.Trade;
import team.cqr.cqrepoured.objects.npc.trading.TradeInput;

@SideOnly(value=Side.CLIENT)
public class GuiMerchantEditTrade
extends GuiContainer {
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("cqrepoured", "textures/gui/container/gui_merchant_edit_trade.png");
    private final AbstractEntityCQR entity;
    private final int tradeIndex;
    @Nullable
    private final Trade trade;
    private final GuiCheckBox[] ignoreMetaCheckBoxes = new GuiCheckBox[4];
    private final GuiCheckBox[] ignoreNBTCheckBoxes = new GuiCheckBox[4];
    private GuiCheckBox stockCheckBox;
    private GuiTextField restockTextField;
    private GuiTextField inStockTextField;
    private GuiTextField maxStockTextField;
    private GuiButtonReputation reputationButton;
    private GuiTextField advancementTextField;

    public GuiMerchantEditTrade(Container container, AbstractEntityCQR entity, int tradeIndex) {
        super(container);
        this.entity = entity;
        this.tradeIndex = tradeIndex;
        this.trade = entity.getTrades().get(tradeIndex);
        this.field_146999_f = 304;
        this.field_147000_g = 166;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new GuiButton(0, this.field_147003_i + 155, this.field_147009_r + 139, 142, 20, "Cancel"));
        this.func_189646_b(new GuiButton(1, this.field_147003_i + 7, this.field_147009_r + 139, 142, 20, "Apply"));
        List tradeInputs = this.trade != null ? this.trade.getInputItems() : Collections.emptyList();
        for (int i = 0; i < this.ignoreMetaCheckBoxes.length; ++i) {
            this.ignoreMetaCheckBoxes[i] = (GuiCheckBox)this.func_189646_b((GuiButton)new GuiCheckBox(i * 2 + 2, this.field_147003_i + i * 26 + 76, this.field_147009_r + 31, "", i < tradeInputs.size() && ((TradeInput)tradeInputs.get(i)).ignoreMeta()));
            this.ignoreMetaCheckBoxes[i].field_146120_f = 11;
            this.ignoreNBTCheckBoxes[i] = (GuiCheckBox)this.func_189646_b((GuiButton)new GuiCheckBox(i * 2 + 3, this.field_147003_i + i * 26 + 76, this.field_147009_r + 44, "", i < tradeInputs.size() && ((TradeInput)tradeInputs.get(i)).ignoreNBT()));
            this.ignoreNBTCheckBoxes[i].field_146120_f = 11;
        }
        this.reputationButton = (GuiButtonReputation)this.func_189646_b(new GuiButtonReputation(30, this.field_147003_i + 7, this.field_147009_r + 72));
        this.reputationButton.setReputationIndex(this.trade != null ? this.trade.getRequiredReputation() : Integer.MIN_VALUE);
        this.advancementTextField = new GuiTextField(40, this.field_146289_q, this.field_147003_i + 8, this.field_147009_r + 103, 58, 10);
        this.advancementTextField.func_146180_a(this.trade != null && this.trade.getRequiredAdvancement() != null ? this.trade.getRequiredAdvancement().toString() : "");
        this.stockCheckBox = (GuiCheckBox)this.func_189646_b((GuiButton)new GuiCheckBox(20, this.field_147003_i + 237, this.field_147009_r + 17, "", this.trade != null && this.trade.hasLimitedStock()));
        this.stockCheckBox.field_146120_f = 11;
        this.restockTextField = new GuiTextField(21, this.field_146289_q, this.field_147003_i + 238, this.field_147009_r + 43, 38, 10);
        this.restockTextField.func_146180_a(this.trade != null ? Integer.toString(this.trade.getRestockRate()) : "0");
        this.restockTextField.func_146184_c(this.stockCheckBox.isChecked());
        this.inStockTextField = new GuiTextField(21, this.field_146289_q, this.field_147003_i + 238, this.field_147009_r + 69, 38, 10);
        this.inStockTextField.func_146180_a(this.trade != null ? Integer.toString(this.trade.getInStock()) : "0");
        this.inStockTextField.func_146184_c(this.stockCheckBox.isChecked());
        this.maxStockTextField = new GuiTextField(22, this.field_146289_q, this.field_147003_i + 238, this.field_147009_r + 95, 38, 10);
        this.maxStockTextField.func_146180_a(this.trade != null ? Integer.toString(this.trade.getMaxStock()) : "0");
        this.maxStockTextField.func_146184_c(this.stockCheckBox.isChecked());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.advancementTextField.func_146194_f();
        this.restockTextField.func_146194_f();
        this.inStockTextField.func_146194_f();
        this.maxStockTextField.func_146194_f();
        this.func_191948_b(mouseX, mouseY);
        for (i = 0; i < this.ignoreMetaCheckBoxes.length; ++i) {
            if (!this.ignoreMetaCheckBoxes[i].func_146115_a()) continue;
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.ignore_meta_check_box.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        for (i = 0; i < this.ignoreNBTCheckBoxes.length; ++i) {
            if (!this.ignoreNBTCheckBoxes[i].func_146115_a()) continue;
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.ignore_nbt_check_box.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (this.reputationButton.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.reputation_button.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (GuiHelper.isMouseOver(mouseX, mouseY, this.advancementTextField)) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.advancement_text_field.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (this.stockCheckBox.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.stock_check_box.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (GuiHelper.isMouseOver(mouseX, mouseY, this.restockTextField)) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.restock_text_field.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (GuiHelper.isMouseOver(mouseX, mouseY, this.inStockTextField)) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.in_stock_text_field.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (GuiHelper.isMouseOver(mouseX, mouseY, this.maxStockTextField)) {
            this.func_146279_a(I18n.func_135052_a((String)"description.gui_merchant_edit_trade.max_stock_text_field.name", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.advancementTextField.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.stockCheckBox.isChecked()) {
            this.restockTextField.func_146192_a(mouseX, mouseY, mouseButton);
            this.inStockTextField.func_146192_a(mouseX, mouseY, mouseButton);
            this.maxStockTextField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (mouseButton == 1 && this.reputationButton.func_146115_a()) {
            this.reputationButton.func_146113_a(this.field_146297_k.func_147118_V());
            this.reputationButton.updateReputationIndex(false);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE);
        GuiHelper.drawTexture(this.field_147003_i, this.field_147009_r, 0.0, 0.0, this.field_146999_f, this.field_147000_g, (double)this.field_146999_f / 512.0, (double)this.field_147000_g / 256.0);
        this.field_146289_q.func_78276_b("Ignore Meta", this.field_147003_i + 7, this.field_147009_r + 33, 0x404040);
        this.field_146289_q.func_78276_b("Ignore NBT", this.field_147003_i + 7, this.field_147009_r + 46, 0x404040);
        this.field_146289_q.func_78276_b("Reputation", this.field_147003_i + 7, this.field_147009_r + 62, 0x404040);
        this.field_146289_q.func_78276_b("Advancement", this.field_147003_i + 7, this.field_147009_r + 92, 0x404040);
        this.field_146289_q.func_78276_b("Stock", this.field_147003_i + 237, this.field_147009_r + 7, 0x404040);
        this.field_146289_q.func_78276_b("Restock", this.field_147003_i + 237, this.field_147009_r + 32, 0x404040);
        this.field_146289_q.func_78276_b("In Stock", this.field_147003_i + 237, this.field_147009_r + 58, 0x404040);
        this.field_146289_q.func_78276_b("Max Stock", this.field_147003_i + 237, this.field_147009_r + 84, 0x404040);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.advancementTextField.func_146178_a();
        if (this.stockCheckBox.isChecked()) {
            this.restockTextField.func_146178_a();
            this.inStockTextField.func_146178_a();
            this.maxStockTextField.func_146178_a();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            CQRMain.NETWORK.sendToServer((IMessage)new CPacketOpenMerchantGui(this.entity.func_145782_y()));
        } else if (button.field_146127_k == 1) {
            boolean[] ignoreMeta = new boolean[this.ignoreMetaCheckBoxes.length];
            for (int i = 0; i < ignoreMeta.length; ++i) {
                ignoreMeta[i] = this.ignoreMetaCheckBoxes[i].isChecked();
            }
            boolean[] ignoreNBT = new boolean[this.ignoreNBTCheckBoxes.length];
            for (int i = 0; i < ignoreNBT.length; ++i) {
                ignoreNBT[i] = this.ignoreNBTCheckBoxes[i].isChecked();
            }
            String reputation = this.reputationButton.field_146126_j;
            String advancement = this.advancementTextField.func_146179_b();
            boolean stock = this.stockCheckBox.isChecked();
            int restock = 0;
            try {
                restock = Integer.parseInt(this.restockTextField.func_146179_b());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int inStock = 0;
            try {
                inStock = Integer.parseInt(this.inStockTextField.func_146179_b());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int maxStock = 0;
            try {
                maxStock = Integer.parseInt(this.maxStockTextField.func_146179_b());
            }
            catch (Exception exception) {
                // empty catch block
            }
            CQRMain.NETWORK.sendToServer((IMessage)new CPacketEditTrade(this.entity.func_145782_y(), this.tradeIndex, ignoreMeta, ignoreNBT, reputation, advancement, stock, restock, inStock, maxStock));
            CQRMain.NETWORK.sendToServer((IMessage)new CPacketOpenMerchantGui(this.entity.func_145782_y()));
        } else if (button == this.stockCheckBox) {
            this.restockTextField.func_146184_c(this.stockCheckBox.isChecked());
            this.restockTextField.func_146195_b(false);
            this.inStockTextField.func_146184_c(this.stockCheckBox.isChecked());
            this.inStockTextField.func_146195_b(false);
            this.maxStockTextField.func_146184_c(this.stockCheckBox.isChecked());
            this.maxStockTextField.func_146195_b(false);
        } else if (button == this.reputationButton) {
            this.reputationButton.updateReputationIndex(true);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.advancementTextField.func_146206_l() || this.stockCheckBox.isChecked() && (this.restockTextField.func_146206_l() || this.inStockTextField.func_146206_l() || this.maxStockTextField.func_146206_l())) {
            if (keyCode == 1) {
                this.advancementTextField.func_146195_b(false);
                this.restockTextField.func_146195_b(false);
                this.inStockTextField.func_146195_b(false);
                this.maxStockTextField.func_146195_b(false);
            } else {
                this.advancementTextField.func_146201_a(typedChar, keyCode);
                if (Character.isDigit(typedChar) || keyCode == 14 || keyCode == 211 || keyCode == 203 || keyCode == 205 || keyCode == 199 || keyCode == 207) {
                    this.restockTextField.func_146201_a(typedChar, keyCode);
                    this.inStockTextField.func_146201_a(typedChar, keyCode);
                    this.maxStockTextField.func_146201_a(typedChar, keyCode);
                }
            }
        } else if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            CQRMain.NETWORK.sendToServer((IMessage)new CPacketOpenMerchantGui(this.entity.func_145782_y()));
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }
}

