/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.reflection.ReflectionField;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="cqrepoured", value={Side.CLIENT})
public class EntityRenderManager {
    private static final ReflectionField<List<?>> FIELD_RENDER_INFOS = new ReflectionField(RenderGlobal.class, "field_72755_R", "renderInfos");
    private static final ReflectionField<RenderChunk> FIELD_RENDER_CHUNK = new ReflectionField("net.minecraft.client.renderer.RenderGlobal$ContainerLocalRenderInformation", "field_178036_a", "renderChunk");
    private static boolean shouldRenderAll = false;
    private static final Set<AbstractEntityCQR> ENTITIES_TO_RENDER = new HashSet<AbstractEntityCQR>();
    private static final Comparator<Entity> ENTITY_SORTER = (entity1, entity2) -> {
        double distance2;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double distance1 = player.func_70068_e(entity1);
        if (distance1 < (distance2 = player.func_70068_e(entity2))) {
            return -1;
        }
        if (distance1 > distance2) {
            return 1;
        }
        return 0;
    };

    public static Iterable<RenderChunk> getRenderChunks() {
        return () -> new Iterator<RenderChunk>(){
            private int index;
            private List renderInfos;
            {
                this.renderInfos = (List)FIELD_RENDER_INFOS.get(Minecraft.func_71410_x().field_71438_f);
            }

            @Override
            public boolean hasNext() {
                return this.index < this.renderInfos.size();
            }

            @Override
            public RenderChunk next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (RenderChunk)FIELD_RENDER_CHUNK.get(this.renderInfos.get(this.index++));
            }
        };
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        shouldRenderAll = true;
        if (!ENTITIES_TO_RENDER.isEmpty()) {
            ENTITIES_TO_RENDER.clear();
        }
        if (CQRMain.isEntityCullingInstalled) {
            return;
        }
        if (!CQRConfig.advanced.limitEntityRendering) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        ArrayList<AbstractEntityCQR> list = new ArrayList<AbstractEntityCQR>();
        for (RenderChunk renderChunk : EntityRenderManager.getRenderChunks()) {
            BlockPos pos = renderChunk.func_178568_j();
            Chunk chunk = mc.field_71441_e.func_175726_f(pos);
            for (Entity entity : chunk.func_177429_s()[pos.func_177956_o() >> 4]) {
                if (!(entity instanceof AbstractEntityCQR) || !entity.func_184222_aU()) continue;
                list.add((AbstractEntityCQR)entity);
            }
        }
        if (list.size() >= CQRConfig.advanced.limitEntityRenderingCount) {
            shouldRenderAll = false;
            list.sort(ENTITY_SORTER);
            for (int i = 0; i < CQRConfig.advanced.limitEntityRenderingCount; ++i) {
                ENTITIES_TO_RENDER.add((AbstractEntityCQR)((Object)list.get(i)));
            }
        }
    }

    public static boolean shouldEntityBeRendered(AbstractEntityCQR entity) {
        Vec3d end;
        if (CQRMain.isEntityCullingInstalled) {
            return true;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        if (CQRConfig.advanced.limitEntityRendering && !shouldRenderAll && !ENTITIES_TO_RENDER.contains((Object)entity)) {
            return false;
        }
        if (!CQRConfig.advanced.skipHiddenEntityRendering) {
            return true;
        }
        int maxDiff = CQRConfig.advanced.skipHiddenEntityRenderingDiff * CQRConfig.advanced.skipHiddenEntityRenderingDiff;
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d start = mc.field_71439_g.func_174824_e(mc.func_184121_ak());
        if (start.func_72436_e(end = entity.func_174824_e(mc.func_184121_ak())) <= (double)maxDiff) {
            return true;
        }
        RayTraceResult result1 = EntityRenderManager.rayTraceBlocks((World)mc.field_71441_e, start, end, false, true);
        if (result1 == null || result1.field_72307_f.func_72436_e(end) <= (double)maxDiff) {
            return true;
        }
        RayTraceResult result2 = EntityRenderManager.rayTraceBlocks((World)mc.field_71441_e, end, start, false, true);
        if (result2 == null) {
            return true;
        }
        return result1.field_72307_f.func_72436_e(result2.field_72307_f) <= (double)maxDiff;
    }

    @Nullable
    private static RayTraceResult rayTraceBlocks(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos);
                Block block = iblockstate.func_177230_c();
                if (iblockstate.func_185914_p() && iblockstate.func_185890_d((IBlockAccess)world, (BlockPos)blockpos) != Block.field_185506_k && block.func_176209_a(iblockstate, stopOnLiquid) && (raytraceresult = iblockstate.func_185910_a(world, (BlockPos)blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                int k1 = 200;
                double x = vec31.field_72450_a;
                double y = vec31.field_72448_b;
                double z = vec31.field_72449_c;
                while (k1-- >= 0) {
                    RayTraceResult raytraceresult1;
                    EnumFacing enumfacing;
                    if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - x;
                    double d7 = vec32.field_72448_b - y;
                    double d8 = vec32.field_72449_c - z;
                    if (flag2) {
                        d3 = (d0 - x) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - y) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - z) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        x = d0;
                        y += d7 * d3;
                        z += d8 * d3;
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        x += d6 * d4;
                        y = d1;
                        z += d8 * d4;
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        x += d6 * d5;
                        y += d7 * d5;
                        z = d2;
                    }
                    l = MathHelper.func_76128_c((double)x) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)y) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)z) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos.func_181079_c(l, i1, j1);
                    iblockstate = world.func_180495_p((BlockPos)blockpos);
                    block = iblockstate.func_177230_c();
                    if (!iblockstate.func_185914_p() || iblockstate.func_185890_d((IBlockAccess)world, (BlockPos)blockpos) == Block.field_185506_k || !block.func_176209_a(iblockstate, stopOnLiquid) || (raytraceresult1 = iblockstate.func_185910_a(world, (BlockPos)blockpos, new Vec3d(x, y, z), vec32)) == null) continue;
                    return raytraceresult1;
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

