/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import team.cqr.cqrepoured.client.models.entities.ModelCQRBiped;
import team.cqr.cqrepoured.client.render.EntityRenderManager;
import team.cqr.cqrepoured.client.render.entity.layers.LayerCQREntityArmor;
import team.cqr.cqrepoured.client.render.entity.layers.LayerCQREntityCape;
import team.cqr.cqrepoured.client.render.entity.layers.LayerCQREntityPotion;
import team.cqr.cqrepoured.client.render.entity.layers.LayerCQRHeldItem;
import team.cqr.cqrepoured.client.render.entity.layers.LayerCQRLeaderFeather;
import team.cqr.cqrepoured.client.render.entity.layers.LayerCQRSpeechbubble;
import team.cqr.cqrepoured.client.render.entity.layers.LayerShoulderEntity;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.items.ItemHookshotBase;
import team.cqr.cqrepoured.objects.items.guns.ItemMusket;
import team.cqr.cqrepoured.objects.items.guns.ItemMusketKnife;
import team.cqr.cqrepoured.objects.items.guns.ItemRevolver;

public class RenderCQREntity<T extends AbstractEntityCQR>
extends RenderLiving<T> {
    public ResourceLocation texture;
    public double widthScale;
    public double heightScale;
    private final String entityName;

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName) {
        this(rendermanagerIn, textureName, 1.0, 1.0, false);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName, boolean hasExtraLayer) {
        this(rendermanagerIn, textureName, 1.0, 1.0, hasExtraLayer);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName, double widthScale, double heightScale) {
        this(rendermanagerIn, textureName, widthScale, heightScale, false);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, String textureName, double widthScale, double heightScale, boolean hasExtraLayer) {
        this(rendermanagerIn, (ModelBase)new ModelCQRBiped(64, 64, hasExtraLayer), 0.5f, textureName, widthScale, heightScale);
    }

    public RenderCQREntity(RenderManager rendermanagerIn, ModelBase model, float shadowSize, String textureName, double widthScale, double heightScale) {
        super(rendermanagerIn, model, shadowSize);
        this.entityName = textureName;
        this.texture = new ResourceLocation("cqrepoured", "textures/entity/" + this.entityName + ".png");
        this.widthScale = widthScale;
        this.heightScale = heightScale;
        this.func_177094_a((LayerRenderer)new LayerCQREntityArmor((RenderLivingBase<?>)this));
        this.func_177094_a((LayerRenderer)new LayerCQRHeldItem((RenderLivingBase<?>)this));
        this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
        this.func_177094_a(new LayerCQREntityCape(this));
        this.func_177094_a(new LayerCQREntityPotion(this));
        if (model instanceof ModelCQRBiped) {
            this.func_177094_a(new LayerCQRLeaderFeather(this, ((ModelCQRBiped)model).field_78116_c));
            this.func_177094_a(new LayerCQRSpeechbubble(this));
            this.func_177094_a((LayerRenderer)new LayerCustomHead(((ModelCQRBiped)model).field_78116_c));
            this.func_177094_a(new LayerShoulderEntity(this));
        }
    }

    protected double getWidthScale(T entity) {
        return this.widthScale * (double)((AbstractEntityCQR)((Object)entity)).getSizeVariation();
    }

    protected double getHeightScale(T entity) {
        return this.heightScale * (double)((AbstractEntityCQR)((Object)entity)).getSizeVariation();
    }

    protected void preRenderCallback(T entitylivingbaseIn, float partialTickTime) {
        double width = this.getWidthScale(entitylivingbaseIn);
        double height = this.getHeightScale(entitylivingbaseIn);
        GL11.glScaled((double)width, (double)height, (double)width);
        super.func_77041_b(entitylivingbaseIn, partialTickTime);
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!EntityRenderManager.shouldEntityBeRendered(entity)) {
            return;
        }
        if (this.field_77045_g instanceof ModelBiped) {
            EnumAction action;
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            ModelBiped model = (ModelBiped)this.field_77045_g;
            ItemStack itemMainHand = entity.func_184614_ca();
            ItemStack itemOffHand = entity.func_184592_cb();
            ModelBiped.ArmPose armPoseMain = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose armPoseOff = ModelBiped.ArmPose.EMPTY;
            boolean dontRenderOffItem = false;
            boolean dontRenderMainItem = false;
            boolean flagMain = false;
            boolean flagOff = false;
            if (!itemMainHand.func_190926_b()) {
                if (itemMainHand.func_77973_b() instanceof ItemMusket || itemMainHand.func_77973_b() instanceof ItemMusketKnife) {
                    armPoseMain = ModelBiped.ArmPose.BOW_AND_ARROW;
                    dontRenderOffItem = true;
                } else if (itemMainHand.func_77973_b() instanceof ItemRevolver || itemMainHand.func_77973_b() instanceof ItemHookshotBase) {
                    flagMain = true;
                } else if (entity.func_184605_cv() > 0) {
                    action = itemMainHand.func_77975_n();
                    switch (action) {
                        case DRINK: 
                        case EAT: {
                            armPoseMain = ModelBiped.ArmPose.ITEM;
                            break;
                        }
                        case BOW: {
                            armPoseMain = ModelBiped.ArmPose.BOW_AND_ARROW;
                            dontRenderOffItem = true;
                            break;
                        }
                        case BLOCK: {
                            armPoseMain = ModelBiped.ArmPose.BLOCK;
                            break;
                        }
                    }
                }
            }
            if (!itemOffHand.func_190926_b()) {
                if (itemOffHand.func_77973_b() instanceof ItemMusket || itemOffHand.func_77973_b() instanceof ItemMusketKnife) {
                    armPoseOff = ModelBiped.ArmPose.BOW_AND_ARROW;
                    dontRenderMainItem = true;
                } else if (itemMainHand.func_77973_b() instanceof ItemRevolver || itemOffHand.func_77973_b() instanceof ItemHookshotBase) {
                    flagOff = true;
                } else if (entity.func_184605_cv() > 0) {
                    action = itemOffHand.func_77975_n();
                    switch (action) {
                        case DRINK: 
                        case EAT: {
                            armPoseOff = ModelBiped.ArmPose.ITEM;
                            break;
                        }
                        case BOW: {
                            armPoseOff = ModelBiped.ArmPose.BOW_AND_ARROW;
                            dontRenderMainItem = true;
                            break;
                        }
                        case BLOCK: {
                            armPoseOff = ModelBiped.ArmPose.BLOCK;
                            break;
                        }
                    }
                }
            }
            if (entity.func_184591_cq() == EnumHandSide.LEFT) {
                ModelBiped.ArmPose tmp = armPoseMain;
                armPoseMain = armPoseOff;
                armPoseOff = tmp;
                boolean tmp2 = dontRenderMainItem;
                dontRenderMainItem = dontRenderOffItem;
                dontRenderOffItem = tmp2;
            }
            if (!flagMain) {
                model.field_187076_m = armPoseMain;
            }
            if (!flagOff) {
                model.field_187075_l = armPoseOff;
            }
            if (dontRenderMainItem) {
                model.field_187076_m = ModelBiped.ArmPose.EMPTY;
            }
            if (dontRenderOffItem) {
                model.field_187075_l = ModelBiped.ArmPose.EMPTY;
            }
        }
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        if (this.field_77045_g instanceof ModelBiped) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
    }

    protected void renderModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (this.field_77045_g.field_78093_q) {
            GL11.glTranslatef((float)0.0f, (float)0.6f, (float)0.0f);
        }
        super.func_77036_a(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        if (((AbstractEntityCQR)((Object)entity)).hasTextureOverride()) {
            return ((AbstractEntityCQR)((Object)entity)).getTextureOverride();
        }
        return ((AbstractEntityCQR)((Object)entity)).getTextureCount() > 1 ? new ResourceLocation("cqrepoured", "textures/entity/" + this.entityName + "_" + ((AbstractEntityCQR)((Object)entity)).getTextureIndex() + ".png") : this.texture;
    }

    public void func_76979_b(Entity entityIn, double x, double y, double z, float yaw, float partialTicks) {
        this.field_76989_e *= ((AbstractEntityCQR)entityIn).getSizeVariation();
        super.func_76979_b(entityIn, x, y, z, yaw, partialTicks);
        this.field_76989_e /= ((AbstractEntityCQR)entityIn).getSizeVariation();
    }

    public void setupHeadOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupBodyOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupRightArmOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupLeftArmOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupRightLegOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupLeftLegOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupHeadwearOffsets(ModelRenderer modelRenderer, EntityEquipmentSlot slot) {
    }

    public void setupPotionOffsets(ModelRenderer modelRenderer) {
    }

    protected void applyTranslations(ModelRenderer modelRenderer) {
        GlStateManager.func_179109_b((float)modelRenderer.field_82906_o, (float)modelRenderer.field_82908_p, (float)modelRenderer.field_82907_q);
        GlStateManager.func_179109_b((float)(modelRenderer.field_78800_c * 0.0625f), (float)(modelRenderer.field_78797_d * 0.0625f), (float)(modelRenderer.field_78798_e * 0.0625f));
    }

    protected void resetTranslations(ModelRenderer modelRenderer) {
        GlStateManager.func_179109_b((float)(-modelRenderer.field_78800_c * 0.0625f), (float)(-modelRenderer.field_78797_d * 0.0625f), (float)(-modelRenderer.field_78798_e * 0.0625f));
        GlStateManager.func_179109_b((float)(-modelRenderer.field_82906_o), (float)(-modelRenderer.field_82908_p), (float)(-modelRenderer.field_82907_q));
    }

    protected void applyRotations(ModelRenderer modelRenderer) {
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected void resetRotations(ModelRenderer modelRenderer) {
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78795_f)), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78796_g)), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(modelRenderer.field_78808_h)), (float)0.0f, (float)0.0f, (float)-1.0f);
    }
}

