/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.entity;

import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.MatrixStack;
import team.cqr.cqrepoured.client.util.MatrixUtil;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;

public abstract class RenderCQREntityGeo<T extends AbstractEntityCQR>
extends GeoEntityRenderer<T> {
    private String entityName;
    private ResourceLocation texture;
    public static final ResourceLocation TEXTURES_ARMOR = new ResourceLocation("cqrepoured", "textures/entity/magic_armor/mages.png");
    protected double widthScale;
    protected double heightScale;
    private int renderPass = 0;
    private T currentEntityBeingRendered;
    private static Matrix4f matrix = new Matrix4f();

    protected RenderCQREntityGeo(RenderManager renderManager, AnimatedGeoModel<T> modelProvider, String entityName) {
        this(renderManager, modelProvider, entityName, 1.0, 1.0, 0.0f);
    }

    protected RenderCQREntityGeo(RenderManager renderManager, AnimatedGeoModel<T> modelProvider, String entityName, double widthScale, double heightScale, float shadowSize) {
        super(renderManager, modelProvider);
        this.field_76989_e = shadowSize;
        this.entityName = entityName;
        this.widthScale = widthScale;
        this.heightScale = heightScale;
        this.texture = new ResourceLocation("cqrepoured", "textures/entity/" + this.entityName + ".png");
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.renderPass = 0;
        super.doRender(entity, x, y, z, entityYaw, partialTicks);
        if (((AbstractEntityCQR)((Object)entity)).isMagicArmorActive()) {
            GlStateManager.func_179094_E();
            this.renderPass = 1;
            GlStateManager.func_179132_a((!entity.func_82150_aj() ? 1 : 0) != 0);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f = (float)((AbstractEntityCQR)((Object)entity)).field_70173_aa + partialTicks;
            float f1 = MathHelper.func_76134_b((float)(f * 0.02f)) * 3.0f;
            float f2 = f * 0.01f;
            GlStateManager.func_179109_b((float)f1, (float)f2, (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            super.doRender(entity, x, y, z, entityYaw, partialTicks);
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    protected double getWidthScale(T entity) {
        return this.widthScale * (double)((AbstractEntityCQR)((Object)entity)).getSizeVariation();
    }

    protected double getHeightScale(T entity) {
        return this.heightScale * (double)((AbstractEntityCQR)((Object)entity)).getSizeVariation();
    }

    public void renderEarly(T animatable, float ticks, float red, float green, float blue, float partialTicks) {
        double width = this.getWidthScale(animatable);
        double height = this.getHeightScale(animatable);
        GlStateManager.func_179139_a((double)width, (double)height, (double)width);
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (this.renderPass != 0) {
            return TEXTURES_ARMOR;
        }
        if (((AbstractEntityCQR)((Object)entity)).hasTextureOverride()) {
            return ((AbstractEntityCQR)((Object)entity)).getTextureOverride();
        }
        return ((AbstractEntityCQR)((Object)entity)).getTextureCount() > 1 ? new ResourceLocation("cqrepoured", "textures/entity/" + this.entityName + "_" + ((AbstractEntityCQR)((Object)entity)).getTextureIndex() + ".png") : this.texture;
    }

    public void renderLate(T animatable, float ticks, float red, float green, float blue, float partialTicks) {
        super.renderLate(animatable, ticks, red, green, blue, partialTicks);
        this.currentEntityBeingRendered = animatable;
    }

    public void renderRecursively(BufferBuilder builder, GeoBone bone, float red, float green, float blue, float alpha) {
        boolean customTextureMarker;
        boolean bl = customTextureMarker = this.getTextureForBone(bone.getName(), this.currentEntityBeingRendered) != null;
        if (customTextureMarker) {
            this.func_110776_a(this.getTextureForBone(bone.getName(), this.currentEntityBeingRendered));
        }
        if (this.renderPass == 0) {
            ItemStack boneItem = this.getHeldItemForBone(bone.getName(), this.currentEntityBeingRendered);
            IBlockState boneBlock = this.getHeldBlockForBone(bone.getName(), this.currentEntityBeingRendered);
            if (boneItem != null || boneBlock != null) {
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179094_E();
                RenderCQREntityGeo.multiplyMatrix(IGeoRenderer.MATRIX_STACK, bone);
                if (boneItem != null) {
                    this.preRenderItem(boneItem, bone.getName(), this.currentEntityBeingRendered);
                    Minecraft.func_71410_x().func_175597_ag().func_178099_a(this.currentEntityBeingRendered, boneItem, ItemCameraTransforms.TransformType.NONE);
                    this.postRenderItem(boneItem, bone.getName(), this.currentEntityBeingRendered);
                }
                if (boneBlock != null) {
                    this.preRenderBlock(boneBlock, bone.getName(), this.currentEntityBeingRendered);
                    this.renderBlock(boneBlock, (Entity)this.currentEntityBeingRendered);
                    this.postRenderBlock(boneBlock, bone.getName(), this.currentEntityBeingRendered);
                }
                GlStateManager.func_179121_F();
                this.func_110776_a(this.getEntityTexture((EntityLivingBase)this.currentEntityBeingRendered));
                builder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            }
        }
        super.renderRecursively(builder, bone, red, green, blue, alpha);
        if (customTextureMarker) {
            this.func_110776_a(this.getEntityTexture((EntityLivingBase)this.currentEntityBeingRendered));
        }
    }

    private void renderBlock(IBlockState iBlockState, Entity currentEntity) {
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.25f, (float)-0.25f, (float)0.25f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        int i = currentEntity.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_110776_a(TextureMap.field_110575_b);
        blockrendererdispatcher.func_175016_a(iBlockState, 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
    }

    public static void multiplyMatrix(MatrixStack stack, GeoBone bone) {
        matrix.set(stack.getModelMatrix());
        matrix.transpose();
        MatrixUtil.matrixToFloat(MatrixUtil.floats, matrix);
        MatrixUtil.buffer.clear();
        MatrixUtil.buffer.put(MatrixUtil.floats);
        MatrixUtil.buffer.flip();
        GlStateManager.func_179110_a((FloatBuffer)MatrixUtil.buffer);
        GlStateManager.func_179109_b((float)(bone.rotationPointX / 16.0f), (float)(bone.rotationPointY / 16.0f), (float)(bone.rotationPointZ / 16.0f));
    }

    @Nullable
    protected abstract ItemStack getHeldItemForBone(String var1, T var2);

    @Nullable
    protected abstract IBlockState getHeldBlockForBone(String var1, T var2);

    protected abstract void preRenderItem(ItemStack var1, String var2, T var3);

    protected abstract void preRenderBlock(IBlockState var1, String var2, T var3);

    protected abstract void postRenderItem(ItemStack var1, String var2, T var3);

    protected abstract void postRenderBlock(IBlockState var1, String var2, T var3);

    @Nullable
    protected abstract ResourceLocation getTextureForBone(String var1, T var2);
}

