/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.entity.boss;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import team.cqr.cqrepoured.client.models.entities.boss.ModelNetherDragonBodyParts;
import team.cqr.cqrepoured.objects.entity.boss.subparts.EntityCQRNetherDragonSegment;

public class RenderCQRNetherDragonSegment
extends Render<EntityCQRNetherDragonSegment> {
    public static final ResourceLocation TEXTURES_NORMAL = new ResourceLocation("cqrepoured", "textures/entity/boss/nether_dragon.png");
    public static final ResourceLocation TEXTURES_SKELETAL = new ResourceLocation("cqrepoured", "textures/entity/boss/nether_dragon_skeletal.png");
    private final ModelBase modelNormal = new ModelNetherDragonBodyParts.ModelNetherDragonBodyPart();
    private final ModelBase modelSkeletal = new ModelNetherDragonBodyParts.ModelNetherDragonBodyPartSkeletal();
    private final ModelBase modelTail = new ModelNetherDragonBodyParts.ModelNetherDragonBodyTailStart();
    private final ModelBase modelTailTip = new ModelNetherDragonBodyParts.ModelNetherDragonBodyTailTip();

    public RenderCQRNetherDragonSegment(RenderManager manager) {
        super(manager);
    }

    public void doRender(EntityCQRNetherDragonSegment entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        ModelBase model = null;
        if (entity.isSkeletal()) {
            model = this.modelSkeletal;
            if (entity.field_70173_aa % 5 == 0) {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                double dx = entity.field_70165_t + (-0.25 + 0.5 * world.field_73012_v.nextDouble());
                double dy = 0.5 + entity.field_70163_u + (-0.25 + 0.5 * world.field_73012_v.nextDouble());
                double dz = entity.field_70161_v + (-0.25 + 0.5 * world.field_73012_v.nextDouble());
                world.func_175688_a(EnumParticleTypes.FLAME, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            model = this.modelNormal;
            if (entity.getPartIndex() <= 1) {
                model = entity.getPartIndex() <= 0 ? this.modelTailTip : this.modelTail;
            }
        }
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        float yawDiff = entity.field_70177_z - entity.field_70126_B;
        if (yawDiff > 180.0f) {
            yawDiff -= 360.0f;
        } else if (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        }
        float yaw = entity.field_70126_B + yawDiff * partialTicks;
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        this.func_110776_a(this.getEntityTexture(entity));
        if (entity.getParent() != null && entity.getParent().deathTicks > 0 && entity.getParent().deathTicks % 5 == 0) {
            float f = (entity.getParent().func_70681_au().nextFloat() - 0.5f) * 8.0f;
            float f1 = (entity.getParent().func_70681_au().nextFloat() - 0.5f) * 4.0f;
            float f2 = (entity.getParent().func_70681_au().nextFloat() - 0.5f) * 8.0f;
            Minecraft.func_71410_x().field_71441_e.func_175688_a(entity.getParent().getDeathAnimParticles(), entity.field_70165_t + (double)f, entity.field_70163_u + 2.0 + (double)f1, entity.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!entity.func_82150_aj()) {
            model.func_78088_a((Entity)entity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GlStateManager.func_179121_F();
    }

    public boolean shouldRender(EntityCQRNetherDragonSegment livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return super.func_177071_a((Entity)livingEntity, camera, camX, camY, camZ) && !livingEntity.field_70128_L;
    }

    protected ResourceLocation getEntityTexture(EntityCQRNetherDragonSegment entity) {
        if (!entity.isSkeletal()) {
            if (entity.getParent() != null && entity.getParent().hasTextureOverride()) {
                return entity.getParent().getTextureOverride();
            }
            return TEXTURES_NORMAL;
        }
        return TEXTURES_SKELETAL;
    }
}

