/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import team.cqr.cqrepoured.client.models.ModelChestLeft;
import team.cqr.cqrepoured.client.models.ModelChestNormal;
import team.cqr.cqrepoured.client.models.ModelChestRight;
import team.cqr.cqrepoured.objects.blocks.BlockExporterChest;
import team.cqr.cqrepoured.objects.blocks.BlockExporterChestCustom;
import team.cqr.cqrepoured.tileentity.TileEntityExporterChest;

public class TileEntityExporterChestRenderer
extends TileEntitySpecialRenderer<TileEntityExporterChest> {
    private final ModelChestNormal chestNormal = new ModelChestNormal();
    private final ModelChestNormal chestRight = new ModelChestRight();
    private final ModelChestNormal chestLeft = new ModelChestLeft();

    public void render(TileEntityExporterChest te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        BlockPos pos = te.func_174877_v();
        World world = te.func_145831_w();
        Block block = te.func_145838_q();
        EnumFacing facing = EnumFacing.SOUTH;
        ModelChestNormal model = this.chestNormal;
        ResourceLocation texture = new ResourceLocation("cqrepoured", "textures/entity/chest/exporter_chest.png");
        ResourceLocation overlayTexture = new ResourceLocation("textures/items/stick.png");
        if (world != null) {
            facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            if (this.isDoubleChest(world, pos)) {
                if (this.isChest(world.func_180495_p(pos.func_177972_a(facing.func_176746_e())).func_177230_c())) {
                    model = this.chestRight;
                    texture = new ResourceLocation("cqrepoured", "textures/entity/chest/exporter_chest_right.png");
                } else {
                    model = this.chestLeft;
                    texture = new ResourceLocation("cqrepoured", "textures/entity/chest/exporter_chest_left.png");
                }
            }
        }
        if (block instanceof BlockExporterChest) {
            overlayTexture = ((BlockExporterChest)block).getOverlayTexture();
        }
        if (block instanceof BlockExporterChestCustom && this.field_147501_a.field_190057_j != null && te.func_174877_v().equals((Object)this.field_147501_a.field_190057_j.func_178782_a())) {
            this.func_190052_a(te, te.func_145748_c_().func_150254_d(), x, y, z, 16);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)facing.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        model.renderAll();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        this.renderOverlay(x, y, z, overlayTexture, facing.func_176734_d().func_185119_l());
    }

    private boolean isChest(Block block) {
        return block instanceof BlockExporterChest;
    }

    private boolean isDoubleChest(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!this.isChest(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    private void renderOverlay(double x, double y, double z, ResourceLocation texture, double rotation) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        for (EnumFacing side : EnumFacing.field_176754_o) {
            GL11.glPushMatrix();
            GL11.glRotated((double)side.func_185119_l(), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.4376);
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex3d((double)-0.5, (double)-0.5, (double)0.0);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex3d((double)0.5, (double)-0.5, (double)0.0);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.5, (double)0.5, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex3d((double)-0.5, (double)0.5, (double)0.0);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
        GL11.glTranslated((double)0.0, (double)0.3751, (double)0.0);
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.5);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.5);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.5);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.5);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

