/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.structureprot;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.structureprot.ProtectedRegionIndicator;
import team.cqr.cqrepoured.network.server.packet.SPacketAddOrResetProtectedRegionIndicator;

@Mod.EventBusSubscriber(modid="cqrepoured", value={Side.CLIENT})
public class ProtectedRegionClientEventHandler {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cqrepoured", "textures/protection_zone.png");
    private static final Map<UUID, ProtectedRegionIndicator> PROTECTED_REGION_INDICATORS = new HashMap<UUID, ProtectedRegionIndicator>();
    private static int displayList;

    private ProtectedRegionClientEventHandler() {
    }

    public static void addOrResetProtectedRegionIndicator(World world, UUID uuid, BlockPos start, BlockPos end, BlockPos pos, @Nullable EntityPlayerMP player) {
        if (world.field_72995_K) {
            RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
            if (result != null && result.field_72307_f != null) {
                world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (player != null) {
            CQRMain.NETWORK.sendTo((IMessage)new SPacketAddOrResetProtectedRegionIndicator(uuid, start, end, pos), player);
        }
    }

    @SubscribeEvent
    public static void onClientWorldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Iterator<ProtectedRegionIndicator> iterator = PROTECTED_REGION_INDICATORS.values().iterator();
        while (iterator.hasNext()) {
            ProtectedRegionIndicator protectedRegionIndicator = iterator.next();
            if (protectedRegionIndicator.getLifeTime() > 0) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = mc.func_184121_ak();
        Entity entity = mc.func_175606_aa();
        double x = MathHelper.func_151238_b((double)entity.field_70169_q, (double)entity.field_70165_t, (double)partialTicks);
        double y = MathHelper.func_151238_b((double)entity.field_70167_r, (double)entity.field_70163_u, (double)partialTicks);
        double z = MathHelper.func_151238_b((double)entity.field_70166_s, (double)entity.field_70161_v, (double)partialTicks);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        mc.func_110434_K().func_110577_a(TEXTURE);
        for (ProtectedRegionIndicator protectedRegionIndicator : PROTECTED_REGION_INDICATORS.values()) {
            BlockPos pos = protectedRegionIndicator.getStart();
            ProtectedRegionClientEventHandler.render(protectedRegionIndicator, (double)pos.func_177958_n() - x, (double)pos.func_177956_o() - y, (double)pos.func_177952_p() - z, partialTicks);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179141_d();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
    }

    private static void render(ProtectedRegionIndicator protectedRegionIndicator, double x, double y, double z, float partialTicks) {
        BlockPos pos1 = protectedRegionIndicator.getStart();
        BlockPos pos2 = protectedRegionIndicator.getEnd();
        int sizeX = pos2.func_177958_n() - pos1.func_177958_n() + 1;
        int sizeY = pos2.func_177956_o() - pos1.func_177956_o() + 1;
        int sizeZ = pos2.func_177952_p() - pos1.func_177952_p() + 1;
        GlStateManager.func_179094_E();
        float f1 = (float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + partialTicks;
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        float f2 = f1 * 0.005f;
        float f3 = f1 * 0.005f;
        GlStateManager.func_179109_b((float)f2, (float)f3, (float)0.0f);
        GlStateManager.func_179152_a((float)(0.25f * (float)sizeX), (float)(0.25f * (float)sizeY), (float)(0.25f * (float)sizeZ));
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)-0.0078125f, (float)-0.0078125f, (float)-0.0078125f);
        GlStateManager.func_179152_a((float)1.015625f, (float)1.015625f, (float)1.015625f);
        GlStateManager.func_179152_a((float)(1.0f * (float)sizeX), (float)(1.0f * (float)sizeY), (float)(1.0f * (float)sizeZ));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)protectedRegionIndicator.getLifeTime() / 60.0f));
        GL11.glCallList((int)displayList);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelRegistryEvent event) {
        displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)displayList, (int)4864);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(1.0, 0.0, 1.0);
        bufferbuilder.func_187315_a(1.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 0.0, 0.0);
        bufferbuilder.func_187315_a(0.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 0.0);
        bufferbuilder.func_187315_a(0.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 1.0);
        bufferbuilder.func_187315_a(1.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 0.0);
        bufferbuilder.func_187315_a(1.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 1.0);
        bufferbuilder.func_187315_a(0.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 1.0, 1.0);
        bufferbuilder.func_187315_a(0.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 1.0, 0.0);
        bufferbuilder.func_187315_a(1.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 0.0, 1.0);
        bufferbuilder.func_187315_a(1.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 1.0);
        bufferbuilder.func_187315_a(0.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 0.0);
        bufferbuilder.func_187315_a(0.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 0.0, 0.0);
        bufferbuilder.func_187315_a(1.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 0.0);
        bufferbuilder.func_187315_a(1.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 1.0, 0.0);
        bufferbuilder.func_187315_a(0.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 1.0, 1.0);
        bufferbuilder.func_187315_a(0.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 1.0);
        bufferbuilder.func_187315_a(1.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 0.0, 0.0);
        bufferbuilder.func_187315_a(1.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 0.0);
        bufferbuilder.func_187315_a(0.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 1.0, 0.0);
        bufferbuilder.func_187315_a(0.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 0.0);
        bufferbuilder.func_187315_a(1.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 1.0);
        bufferbuilder.func_187315_a(1.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 0.0, 1.0);
        bufferbuilder.func_187315_a(0.0, 0.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 1.0);
        bufferbuilder.func_187315_a(0.0, 1.0);
        bufferbuilder.func_181675_d();
        bufferbuilder.func_181662_b(0.0, 1.0, 1.0);
        bufferbuilder.func_187315_a(1.0, 1.0);
        bufferbuilder.func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187415_K();
    }
}

