/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.tileentity.TileEntityExporter;

public class CommandExport
extends CommandBase {
    public String func_71517_b() {
        return "cqr_export_all";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/cqr_export_all [override_files]";
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        LinkedList<TileEntityExporter> exporterList = new LinkedList<TileEntityExporter>();
        for (TileEntity tileEntity : sender.func_130014_f_().field_147482_g) {
            if (!(tileEntity instanceof TileEntityExporter)) continue;
            exporterList.add((TileEntityExporter)tileEntity);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Trying to export " + exporterList.size() + " structures..."));
        HashSet<String> fileNames = new HashSet<String>();
        for (int i = 0; i < exporterList.size(); ++i) {
            TileEntityExporter exporter = (TileEntityExporter)exporterList.get(i);
            if (fileNames.add(exporter.getStructureName())) continue;
            exporterList.remove(i--);
            sender.func_145747_a((ITextComponent)new TextComponentString("Couldn't export structure " + exporter.getStructureName() + " because there is another exporter which wants to write to that file."));
        }
        for (TileEntityExporter exporter : exporterList) {
            File file = new File(CQRMain.CQ_EXPORT_FILES_FOLDER, exporter.getStructureName() + ".nbt");
            if (!file.exists() || args.length >= 1 && args[0].equals("true")) {
                exporter.saveStructure((EntityPlayer)sender);
                continue;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Couldn't export structure " + exporter.getStructureName() + " because a file with that name already exists and file overriding is disabled."));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("false");
            list.add("true");
            return list;
        }
        return Collections.emptyList();
    }
}

