/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.customtextures;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.customtextures.CompressionUtil;
import team.cqr.cqrepoured.customtextures.TextureSet;
import team.cqr.cqrepoured.customtextures.TextureUtil;
import team.cqr.cqrepoured.network.server.packet.SPacketCustomTextures;

public class TextureSetManager {
    private Map<String, TextureSet> textureSets = new HashMap<String, TextureSet>();
    private static TextureSetManager INSTANCE;

    private TextureSetManager() {
    }

    public static TextureSetManager getInstance() {
        try {
            return INSTANCE.get();
        }
        catch (NullPointerException npe) {
            INSTANCE = new TextureSetManager();
            return INSTANCE;
        }
    }

    TextureSetManager get() {
        return this;
    }

    public static void registerTextureSet(TextureSet set) {
        TextureSetManager.getInstance().registerTextureSetImpl(set);
    }

    public static void unloadTextures() {
        try {
            TextureSetManager.getInstance().unloadTexturesImpl();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static void loadTextureSetsFromFolder(File folder) {
        TextureSetManager.getInstance().clearData();
        TextureSetManager.unloadTextures();
        if (folder.isDirectory()) {
            ArrayList files = new ArrayList(FileUtils.listFiles((File)folder, (String[])new String[]{"cfg", "prop", "properties"}, (boolean)true));
            int loadedSets = 0;
            for (File file : files) {
                boolean flag = true;
                Properties prop = new Properties();
                try (FileInputStream inputStream = new FileInputStream(file);){
                    prop.load(inputStream);
                    flag = true;
                }
                catch (IOException e) {
                    CQRMain.logger.error("Failed to load file" + file.getName(), (Throwable)e);
                    flag = false;
                    continue;
                }
                if (!flag) continue;
                try {
                    new TextureSet(prop, file.getName().substring(0, file.getName().lastIndexOf(46)));
                    CQRMain.logger.info("Successfully loaded texture set: " + file.getName().substring(0, file.getName().lastIndexOf(46)) + "!");
                    ++loadedSets;
                }
                catch (Exception exception) {}
            }
            CQRMain.logger.info("Loaded " + loadedSets + " texture Sets!");
            if (!FMLCommonHandler.instance().getSide().isServer()) {
                for (Map.Entry entry : TextureSet.getLoadedTextures().entrySet()) {
                    TextureUtil.loadTextureInternal((File)entry.getValue(), TextureSet.getResLocOfTexture((String)entry.getKey()));
                }
                TextureUtil.reloadResourcepacks();
            }
        }
    }

    private void clearData() {
        if (!this.textureSets.isEmpty()) {
            this.textureSets.clear();
        }
    }

    public static void sendTexturesToClient(EntityPlayerMP joiningPlayer) {
        try {
            TextureSetManager.getInstance().sendTexturesToClientImpl(joiningPlayer);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void sendTexturesToClientImpl(EntityPlayerMP joiningPlayer) {
        SPacketCustomTextures packet = new SPacketCustomTextures();
        for (Map.Entry<String, File> entry : TextureSet.getLoadedTextures().entrySet()) {
            byte[] base64 = CompressionUtil.encodeFileToBase64(entry.getValue());
            String path = entry.getKey();
            packet.addPair(base64, path);
        }
        for (TextureSet ts : this.textureSets.values()) {
            packet.addTextureSet(ts);
        }
        CQRMain.NETWORK.sendTo((IMessage)packet, joiningPlayer);
    }

    private void registerTextureSetImpl(TextureSet set) {
        this.textureSets.put(set.getName(), set);
    }

    @SideOnly(value=Side.CLIENT)
    private void unloadTexturesImpl() {
        for (TextureSet set : this.textureSets.values()) {
            for (ResourceLocation rs : set.getTextures()) {
                try {
                    TextureUtil.unloadTexture(rs);
                }
                catch (Exception exception) {}
            }
            set.clearTextureCache();
        }
        this.textureSets.clear();
    }

    @Nullable
    public TextureSet getTextureSet(String name) {
        return this.textureSets.getOrDefault(name, null);
    }

    public static List<TextureSet> getAllTextureSets() {
        return TextureSetManager.getInstance().getAllTextureSetsImpl();
    }

    private List<TextureSet> getAllTextureSetsImpl() {
        return new ArrayList<TextureSet>(this.textureSets.values());
    }
}

