/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.customtextures;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.customtextures.CTResourcepack;

public class TextureUtil {
    @SideOnly(value=Side.CLIENT)
    public static boolean loadTextureInternal(File textureFile, ResourceLocation resLoc) {
        if (textureFile != null && textureFile.exists() && resLoc != null) {
            try {
                CTResourcepack.add(resLoc, textureFile);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean unloadTexture(ResourceLocation texture) {
        try {
            CTResourcepack.remove(texture);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void reloadResourcepacks() {
        CTResourcepack.loadAllTextures();
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        if (rm instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)rm).func_110545_a((IResourcePack)CTResourcepack.getInstance());
        } else {
            FMLClientHandler.instance().refreshResources(new IResourceType[]{VanillaResourceType.TEXTURES});
        }
    }
}

