/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.factions;

public enum EReputationState {
    ARCH_ENEMY(-1000),
    ENEMY(-500),
    HATED(-250),
    AVOIDED(-125),
    NEUTRAL(0),
    ACCEPTED(125),
    FRIEND(250),
    ALLY(500),
    MEMBER(1000);

    private int value = 0;

    private EReputationState(int index) {
        this.value = index;
    }

    public int getValue() {
        return this.value;
    }

    public static EReputationState getByInt(int amount) {
        if (amount < -750) {
            return ARCH_ENEMY;
        }
        if (amount < -375) {
            return ENEMY;
        }
        if (amount < -187) {
            return HATED;
        }
        if (amount < -62) {
            return AVOIDED;
        }
        if (amount < 62) {
            return NEUTRAL;
        }
        if (amount < 187) {
            return ACCEPTED;
        }
        if (amount < 375) {
            return FRIEND;
        }
        if (amount < 750) {
            return ALLY;
        }
        return MEMBER;
    }

    public static enum EReputationStateRough {
        NEUTRAL(250, -249),
        ENEMY(-250, -10000),
        ALLY(10000, 251);

        private final int high;
        private final int low;

        private EReputationStateRough(int highBound, int lowBound) {
            this.high = highBound;
            this.low = lowBound;
        }

        public int getHighBound() {
            return this.high;
        }

        public int getLowBound() {
            return this.low;
        }

        public static EReputationStateRough getByRepuScore(int score) {
            if (score < NEUTRAL.getLowBound()) {
                return ENEMY;
            }
            if (score > NEUTRAL.getHighBound()) {
                return ALLY;
            }
            return NEUTRAL;
        }
    }
}

