/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.factions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.customtextures.TextureSet;
import team.cqr.cqrepoured.customtextures.TextureSetManager;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.factions.EDefaultFaction;
import team.cqr.cqrepoured.factions.EReputationState;
import team.cqr.cqrepoured.network.server.packet.SPacketInitialFactionInformation;
import team.cqr.cqrepoured.network.server.packet.SPacketUpdatePlayerReputation;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.PropertyFileHelper;
import team.cqr.cqrepoured.util.data.FileIOUtil;

public class FactionRegistry {
    private static FactionRegistry instance;
    private volatile Map<String, CQRFaction> factions = new ConcurrentHashMap<String, CQRFaction>();
    private volatile List<UUID> uuidsBeingLoaded = Collections.synchronizedList(new ArrayList());
    private Map<UUID, Map<String, Integer>> playerFactionRepuMap = new ConcurrentHashMap<UUID, Map<String, Integer>>();
    private Map<ResourceLocation, CQRFaction> entityFactionMap = new ConcurrentHashMap<ResourceLocation, CQRFaction>();
    public static final int LOWEST_REPU;
    public static final int HIGHEST_REPU;

    public FactionRegistry() {
        instance = this;
    }

    public void loadFactions() {
        if (!this.factions.isEmpty()) {
            this.factions.clear();
        }
        if (!this.playerFactionRepuMap.isEmpty()) {
            this.playerFactionRepuMap.clear();
        }
        if (!this.entityFactionMap.isEmpty()) {
            this.entityFactionMap.clear();
        }
        this.loadFactionsInConfigFolder();
        this.loadDefaultFactions();
        this.loadEntityFactionRelations();
    }

    @SideOnly(value=Side.CLIENT)
    public synchronized void addFaction(CQRFaction faction) {
        this.factions.put(faction.getName(), faction);
    }

    @SideOnly(value=Side.CLIENT)
    public synchronized void setReputation(UUID player, int reputation, CQRFaction faction) {
        if (faction.canRepuChange()) {
            Map factionsOfPlayer = this.playerFactionRepuMap.computeIfAbsent(player, key -> new ConcurrentHashMap());
            factionsOfPlayer.put(faction.getName(), reputation);
        }
    }

    public void changeReputationTo(@Nonnull EntityPlayerMP player, int reputation, @Nonnull CQRFaction faction) {
        Map factionsOfPlayer = this.playerFactionRepuMap.computeIfAbsent(player.getPersistentID(), key -> new ConcurrentHashMap());
        factionsOfPlayer.put(faction.getName(), reputation);
        this.sendRepuUpdatePacket(player, reputation, faction.getName());
    }

    private void loadEntityFactionRelations() {
        File file = new File(CQRMain.CQ_CONFIG_FOLDER, "entityFactionRelation.properties");
        if (file.exists()) {
            Properties prop = new Properties();
            boolean flag = true;
            try (FileInputStream inputStream = new FileInputStream(file);){
                prop.load(inputStream);
                flag = true;
            }
            catch (IOException e) {
                CQRMain.logger.error("Failed to load file" + file.getName(), (Throwable)e);
                flag = false;
            }
            if (flag) {
                for (String key : prop.stringPropertyNames()) {
                    if (key.startsWith("#")) continue;
                    String rlkey = key.replace('.', ':');
                    ResourceLocation resLoc = new ResourceLocation(rlkey);
                    String faction = prop.getProperty(key, null);
                    if (faction == null || !this.factions.containsKey(faction)) continue;
                    this.entityFactionMap.put(resLoc, this.factions.get(faction));
                }
            }
        }
    }

    private void loadFactionsInConfigFolder() {
        ArrayList files = new ArrayList(FileUtils.listFiles((File)CQRMain.CQ_FACTION_FOLDER, (String[])new String[]{"cfg", "prop", "properties"}, (boolean)true));
        int fileCount = files.size();
        if (fileCount > 0) {
            int i;
            ArrayList<String> fIDs = new ArrayList<String>(fileCount + 1);
            ArrayList allyTmp = new ArrayList();
            ArrayList enemyTmp = new ArrayList();
            boolean flag = true;
            for (i = 0; i < fileCount; ++i) {
                File file = (File)files.get(i);
                Properties prop = new Properties();
                try (FileInputStream inputStream = new FileInputStream(file);){
                    prop.load(inputStream);
                    flag = true;
                }
                catch (IOException e) {
                    CQRMain.logger.error("Failed to load file" + file.getName(), (Throwable)e);
                    flag = false;
                    continue;
                }
                if (!flag) continue;
                ArrayList<String> fAlly = new ArrayList<String>();
                ArrayList<String> fEnemy = new ArrayList<String>();
                String fName = prop.getProperty("name", "FACTION_NAME");
                int repuChangeAlly = PropertyFileHelper.getIntProperty(prop, "repuChangeOnKillAlly", 2);
                int repuChangeEnemy = PropertyFileHelper.getIntProperty(prop, "repuChangeOnKillEnemy", 1);
                int repuChangeMember = PropertyFileHelper.getIntProperty(prop, "repuChangeOnKillMember", 5);
                EReputationState defRepu = EReputationState.valueOf(prop.getProperty("defaultReputation", EReputationState.NEUTRAL.toString()));
                boolean staticRepu = PropertyFileHelper.getBooleanProperty(prop, "staticReputation", false);
                for (String ally : PropertyFileHelper.getStringArrayProperty(prop, "allies", new String[0], true)) {
                    fAlly.add(ally);
                }
                for (String enemy : PropertyFileHelper.getStringArrayProperty(prop, "enemies", new String[0], true)) {
                    fEnemy.add(enemy);
                }
                fIDs.add(fName);
                allyTmp.add(fAlly);
                enemyTmp.add(fEnemy);
                Optional<Integer> optionMember = Optional.of(repuChangeMember);
                Optional<Integer> optionAlly = Optional.of(repuChangeAlly);
                Optional<Integer> optionEnemy = Optional.of(repuChangeEnemy);
                String textureSetName = prop.getProperty("textureSet", "");
                TextureSet ts = TextureSetManager.getInstance().getTextureSet(textureSetName);
                CQRFaction f = new CQRFaction(fName, ts, defRepu, true, !staticRepu, optionMember, optionAlly, optionEnemy);
                this.factions.put(fName, f);
            }
            for (i = 0; i < fIDs.size(); ++i) {
                String name = (String)fIDs.get(i);
                CQRFaction fac = this.factions.get(name);
                for (String s : (List)allyTmp.get(i)) {
                    fac.addAlly(this.factions.getOrDefault(s, null));
                }
                for (String s : (List)enemyTmp.get(i)) {
                    fac.addEnemy(this.factions.getOrDefault(s, null));
                }
            }
        }
    }

    private void loadDefaultFactions() {
        String[][] allies = new String[EDefaultFaction.values().length][];
        String[][] enemies = new String[EDefaultFaction.values().length][];
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < EDefaultFaction.values().length; ++i) {
            EDefaultFaction edf = EDefaultFaction.values()[i];
            if (this.factions.containsKey(edf.name())) continue;
            indices.add(i);
            allies[i] = edf.getAllies();
            enemies[i] = edf.getEnemies();
            Optional<Integer> optionMember = Optional.empty();
            Optional<Integer> optionAlly = Optional.empty();
            Optional<Integer> optionEnemy = Optional.empty();
            CQRFaction fac = new CQRFaction(edf.name(), null, edf.getDefaultReputation(), false, edf.canRepuChange(), optionMember, optionAlly, optionEnemy);
            this.factions.put(edf.name(), fac);
        }
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int j;
            int i = (Integer)iterator.next();
            String name = EDefaultFaction.values()[i].name();
            CQRFaction fac = this.factions.get(name);
            for (j = 0; j < allies[i].length; ++j) {
                fac.addAlly(this.factions.get(allies[i][j]));
            }
            for (j = 0; j < enemies[i].length; ++j) {
                fac.addEnemy(this.factions.get(enemies[i][j]));
            }
        }
        CQRMain.logger.info("Default factions loaded and initialized!");
    }

    @Nullable
    public CQRFaction getFactionOf(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (CQRConfig.advanced.enableOldFactionMemberTeams && entity.func_96124_cp() != null && this.factions.containsKey(entity.func_96124_cp().func_96661_b()) && this.factions.get(entity.func_96124_cp().func_96661_b()) != null) {
            return this.factions.get(entity.func_96124_cp().func_96661_b());
        }
        if (entity instanceof EntityPlayer) {
            return this.factions.get(EDefaultFaction.PLAYERS.name());
        }
        if (entity instanceof MultiPartEntityPart && ((MultiPartEntityPart)entity).field_70259_a instanceof Entity) {
            return this.getFactionOf((Entity)((MultiPartEntityPart)entity).field_70259_a);
        }
        if (entity.func_184179_bs() != null) {
            return this.getFactionOf(entity.func_184179_bs());
        }
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70902_q() != null) {
            return this.getFactionOf((Entity)((EntityTameable)entity).func_70902_q());
        }
        if (entity instanceof IEntityOwnable && ((IEntityOwnable)entity).func_70902_q() != null) {
            return this.getFactionOf(((IEntityOwnable)entity).func_70902_q());
        }
        if (entity instanceof AbstractEntityCQR) {
            return ((AbstractEntityCQR)entity).getFaction();
        }
        ResourceLocation registryName = EntityList.func_191301_a((Entity)entity);
        if (registryName != null && this.entityFactionMap.containsKey(registryName)) {
            return this.entityFactionMap.get(registryName);
        }
        if (entity instanceof EntityArmorStand) {
            return this.factions.get(EDefaultFaction.ALL_ALLY.name());
        }
        if (entity instanceof EntityVillager || entity instanceof EntityGolem) {
            return this.factions.get(EDefaultFaction.VILLAGERS.name());
        }
        if (entity instanceof AbstractIllager || entity instanceof EntityVex) {
            return this.factions.get(EDefaultFaction.ILLAGERS.name());
        }
        if (entity instanceof EntityEnderman || entity instanceof EntityEndermite || entity instanceof EntityDragon) {
            return this.factions.get(EDefaultFaction.ENDERMEN.name());
        }
        if (entity instanceof EntityAnimal) {
            return this.factions.get(EDefaultFaction.NEUTRAL.name());
        }
        if (entity instanceof EntityMob) {
            return this.factions.get(EDefaultFaction.UNDEAD.name());
        }
        if (entity instanceof EntityWaterMob) {
            return this.factions.get(EDefaultFaction.TRITONS.name());
        }
        return null;
    }

    public FactionRegistry get() {
        return this;
    }

    public static FactionRegistry instance() {
        try {
            return instance.get();
        }
        catch (NullPointerException npe) {
            new FactionRegistry();
            return instance.get();
        }
    }

    public CQRFaction getFactionInstance(String factionName) {
        if (this.factions.containsKey(factionName)) {
            return this.factions.get(factionName);
        }
        return this.factions.get(EDefaultFaction.NEUTRAL.name());
    }

    public EReputationState.EReputationStateRough getReputationOf(UUID playerID, CQRFaction faction) {
        return EReputationState.EReputationStateRough.getByRepuScore(this.getExactReputationOf(playerID, faction));
    }

    public int getExactReputationOf(UUID playerID, CQRFaction faction) {
        if (!faction.canRepuChange()) {
            return faction.getDefaultReputation().getValue();
        }
        if (playerID != null && this.playerFactionRepuMap.containsKey(playerID) && this.playerFactionRepuMap.get(playerID).containsKey(faction.getName())) {
            return this.playerFactionRepuMap.get(playerID).get(faction.getName());
        }
        return faction.getDefaultReputation().getValue();
    }

    void incrementRepuOf(EntityPlayer player, String faction, int score) {
        this.changeRepuOf(player, faction, Math.abs(score));
    }

    void decrementRepuOf(EntityPlayer player, String faction, int score) {
        this.changeRepuOf(player, faction, -Math.abs(score));
    }

    private void changeRepuOf(EntityPlayer player, String faction, int score) {
        if (this.canDecrementRepu(player, faction) || this.canIncrementRepu(player, faction)) {
            Map factionsOfPlayer = this.playerFactionRepuMap.computeIfAbsent(player.getPersistentID(), key -> new ConcurrentHashMap());
            int oldScore = factionsOfPlayer.getOrDefault(faction, this.factions.get(faction).getDefaultReputation().getValue());
            factionsOfPlayer.put(faction, oldScore + score);
            if (player instanceof EntityPlayerMP) {
                this.sendRepuUpdatePacket((EntityPlayerMP)player, score + oldScore, faction);
            }
        }
    }

    private void sendRepuUpdatePacket(EntityPlayerMP player, int reputation, String faction) {
        SPacketUpdatePlayerReputation packet = new SPacketUpdatePlayerReputation(player, faction, reputation);
        CQRMain.NETWORK.sendTo((IMessage)packet, player);
    }

    private boolean canDecrementRepu(EntityPlayer player, String faction) {
        if (this.canRepuChange(player)) {
            Map factionsOfPlayer = this.playerFactionRepuMap.getOrDefault(player.getPersistentID(), new ConcurrentHashMap());
            if (factionsOfPlayer != null) {
                if (factionsOfPlayer.containsKey(faction)) {
                    return (Integer)factionsOfPlayer.get(faction) >= LOWEST_REPU;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean canIncrementRepu(EntityPlayer player, String faction) {
        if (this.canRepuChange(player)) {
            Map factionsOfPlayer = this.playerFactionRepuMap.getOrDefault(player.getPersistentID(), new ConcurrentHashMap());
            if (factionsOfPlayer != null) {
                if (factionsOfPlayer.containsKey(faction)) {
                    return (Integer)factionsOfPlayer.get(faction) <= HIGHEST_REPU;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean canRepuChange(EntityPlayer player) {
        return !player.func_130014_f_().func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL) && !player.func_184812_l_() && !player.func_175149_v() && !this.uuidsBeingLoaded.contains(player.getPersistentID());
    }

    public void handlePlayerLogin(final EntityPlayerMP player) {
        String path = FileIOUtil.getAbsoluteWorldPath() + "/data/CQR/reputation/";
        final File f = new File(path, player.getPersistentID() + ".nbt");
        CQRMain.logger.info("Loading player reputation...");
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NBTTagCompound root;
                UUID uuid = player.getPersistentID();
                if (f.exists() && !(root = FileIOUtil.getRootNBTTagOfFile(f)).func_82582_d()) {
                    while (FactionRegistry.this.uuidsBeingLoaded.contains(uuid)) {
                    }
                    FactionRegistry.this.uuidsBeingLoaded.add(uuid);
                    try {
                        Map mapping = FactionRegistry.this.playerFactionRepuMap.computeIfAbsent(player.getPersistentID(), key -> new ConcurrentHashMap());
                        for (String key2 : root.func_150296_c()) {
                            try {
                                int value = root.func_74762_e(key2);
                                mapping.put(key2, value);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        FactionRegistry.this.uuidsBeingLoaded.remove(uuid);
                    }
                }
                SPacketInitialFactionInformation packet = new SPacketInitialFactionInformation(uuid);
                CQRMain.NETWORK.sendTo((IMessage)packet, player);
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public void handlePlayerLogout(final EntityPlayerMP player) {
        if (this.playerFactionRepuMap.containsKey(player.getPersistentID())) {
            CQRMain.logger.info("Saving player reputation...");
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    FactionRegistry.this.savePlayerReputation(player.getPersistentID(), true);
                }
            });
            t.setName("CQR-Reputation-Data-Saver");
            t.setDaemon(true);
            t.start();
        }
    }

    public void saveAllReputationData(final boolean removeMapsFromMemory) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                for (UUID playerID : FactionRegistry.this.playerFactionRepuMap.keySet()) {
                    try {
                        FactionRegistry.this.savePlayerReputation(playerID, removeMapsFromMemory);
                    }
                    catch (Exception ex) {
                        System.out.println("Unable to save reputation data of " + playerID + "!");
                        ex.printStackTrace();
                    }
                }
            }
        });
        t.setName("CQR-Reputation-Data-Saver");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePlayerReputation(UUID playerID, boolean removeFromMap) {
        Map<String, Integer> mapping = this.playerFactionRepuMap.get(playerID);
        UUID uuid = playerID;
        String path = FileIOUtil.getAbsoluteWorldPath() + "/data/CQR/reputation/";
        File f = FileIOUtil.getOrCreateFile(path, uuid + ".nbt");
        if (f != null) {
            while (this.uuidsBeingLoaded.contains(uuid)) {
            }
            this.uuidsBeingLoaded.add(uuid);
            try {
                NBTTagCompound root = FileIOUtil.getRootNBTTagOfFile(f);
                for (Map.Entry<String, Integer> entry : mapping.entrySet()) {
                    root.func_74768_a(entry.getKey(), entry.getValue().intValue());
                }
                FileIOUtil.saveNBTCompoundToFile(root, f);
            }
            finally {
                if (removeFromMap) {
                    this.playerFactionRepuMap.remove(playerID);
                }
                this.uuidsBeingLoaded.remove(uuid);
            }
        }
        return true;
    }

    public List<CQRFaction> getLoadedFactions() {
        return new ArrayList<CQRFaction>(this.factions.values());
    }

    static {
        LOWEST_REPU = EReputationState.ARCH_ENEMY.getValue();
        HIGHEST_REPU = EReputationState.MEMBER.getValue();
    }
}

