/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.init;

import java.util.Random;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.objects.entity.projectiles.ProjectileBubble;
import team.cqr.cqrepoured.objects.items.ItemSoulBottle;
import team.cqr.cqrepoured.objects.items.guns.ItemBubblePistol;

public class CQRDispenseBehaviors {
    private static final Random rng = new Random();
    public static final IBehaviorDispenseItem DISPENSE_BEHAVIOR_BUBBLE_GUN = new IBehaviorDispenseItem(){

        public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
            Vec3d velocity = new Vec3d(0.0, 0.0, 0.0);
            switch ((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)) {
                case DOWN: {
                    velocity = new Vec3d(0.0, -1.0, 0.0);
                    break;
                }
                case EAST: {
                    velocity = new Vec3d(1.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    velocity = new Vec3d(0.0, 0.0, -1.0);
                    break;
                }
                case SOUTH: {
                    velocity = new Vec3d(0.0, 0.0, 1.0);
                    break;
                }
                case UP: {
                    velocity = new Vec3d(0.0, 1.0, 0.0);
                    break;
                }
                case WEST: {
                    velocity = new Vec3d(-1.0, 0.0, 0.0);
                    break;
                }
            }
            IPosition disPos = BlockDispenser.func_149939_a((IBlockSource)source);
            Vec3d startLoc = new Vec3d(disPos.func_82615_a(), disPos.func_82617_b(), disPos.func_82616_c());
            Item item = stack.func_77973_b();
            double acc = 0.5;
            if (item instanceof ItemBubblePistol) {
                ItemBubblePistol pistol = (ItemBubblePistol)item;
                acc = pistol.getInaccurary();
            }
            Vec3d v = new Vec3d(-acc + velocity.field_72450_a + 2.0 * acc * rng.nextDouble(), -acc + velocity.field_72448_b + 2.0 * acc * rng.nextDouble(), -acc + velocity.field_72449_c + 2.0 * acc * rng.nextDouble());
            v = v.func_72432_b();
            v = v.func_186678_a(1.4);
            ProjectileBubble bubble = new ProjectileBubble(source.func_82618_k(), startLoc.field_72450_a, startLoc.field_72448_b, startLoc.field_72449_c);
            bubble.field_70159_w = v.field_72450_a;
            bubble.field_70181_x = v.field_72448_b;
            bubble.field_70179_y = v.field_72449_c;
            bubble.field_70133_I = true;
            source.func_82618_k().func_72838_d((Entity)bubble);
            source.func_82618_k().func_184134_a(disPos.func_82615_a(), disPos.func_82617_b(), disPos.func_82616_c(), CQRSounds.BUBBLE_BUBBLE, SoundCategory.BLOCKS, 1.0f, 0.75f + 0.5f * rng.nextFloat(), false);
            stack.func_96631_a(1, source.func_82618_k().field_73012_v, null);
            if (stack.func_77952_i() >= stack.func_77958_k()) {
                stack = ItemStack.field_190927_a;
            }
            return stack;
        }
    };
    public static final IBehaviorDispenseItem DISPENSE_BEHAVIOR_SOUL_BOTTLE = new IBehaviorDispenseItem(){

        public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
            NBTTagCompound bottle;
            Vec3d velocity = new Vec3d(0.0, 0.0, 0.0);
            switch ((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)) {
                case DOWN: {
                    velocity = new Vec3d(0.0, -1.0, 0.0);
                    break;
                }
                case EAST: {
                    velocity = new Vec3d(1.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    velocity = new Vec3d(0.0, 0.0, -1.0);
                    break;
                }
                case SOUTH: {
                    velocity = new Vec3d(0.0, 0.0, 1.0);
                    break;
                }
                case UP: {
                    velocity = new Vec3d(0.0, 2.0, 0.0);
                    break;
                }
                case WEST: {
                    velocity = new Vec3d(-1.0, 0.0, 0.0);
                    break;
                }
            }
            IPosition disPos = BlockDispenser.func_149939_a((IBlockSource)source);
            Vec3d pos = new Vec3d(disPos.func_82615_a(), disPos.func_82617_b(), disPos.func_82616_c()).func_178787_e(velocity);
            if (stack.func_77942_o() && (bottle = stack.func_77978_p()).func_74764_b("EntityIn") && !source.func_82618_k().field_72995_K) {
                NBTTagCompound entityTag = (NBTTagCompound)bottle.func_74781_a("EntityIn");
                ((ItemSoulBottle)stack.func_77973_b()).createEntityFromNBT(entityTag, source.func_82618_k(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                stack = ItemStack.field_190927_a;
            }
            return stack;
        }
    };

    public static void registerDispenseBehaviors() {
        BlockDispenser.field_149943_a.func_82595_a((Object)CQRItems.BUBBLE_PISTOL, (Object)DISPENSE_BEHAVIOR_BUBBLE_GUN);
        BlockDispenser.field_149943_a.func_82595_a((Object)CQRItems.BUBBLE_RIFLE, (Object)DISPENSE_BEHAVIOR_BUBBLE_GUN);
        BlockDispenser.field_149943_a.func_82595_a((Object)CQRItems.SOUL_BOTTLE, (Object)DISPENSE_BEHAVIOR_SOUL_BOTTLE);
    }
}

