/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.magic;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import team.cqr.cqrepoured.capability.itemhandler.item.CapabilityItemHandlerItemProvider;
import team.cqr.cqrepoured.magic.AbstractSpell;
import team.cqr.cqrepoured.magic.MagicUtil;

public abstract class AbstractSpellCastingItem
extends Item {
    public AbstractSpellCastingItem() {
        this.func_77625_d(1);
    }

    abstract float getCastingSpeedModifier();

    abstract float getManaCostModifier();

    abstract float getSpellPowerModifier();

    abstract float getSpellCooldownModifier();

    abstract int getSpellSlotCount();

    public float getManaCostModifier(EntityLivingBase caster) {
        return 1.0f;
    }

    public float getSpellPowerModifier(EntityLivingBase caster) {
        return 1.0f;
    }

    public float getSpellCooldownModifier(EntityLivingBase caster) {
        return 1.0f;
    }

    @Nullable
    public AbstractSpell getCurrentSpell(ItemStack castingItem) {
        return null;
    }

    public int func_77626_a(ItemStack stack) {
        if (this.getCurrentSpell(stack) != null) {
            return Math.abs(Math.round((float)this.getCurrentSpell(stack).getCastingTime() * this.getCastingSpeedModifier()));
        }
        return 20;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase caster) {
        if (!worldIn.field_72995_K && this.getCurrentSpell(stack) != null) {
            int castingMana = Math.round((float)this.getCurrentSpell(stack).getSpellCosts() * this.getManaCostModifier() * this.getManaCostModifier(caster));
            if (MagicUtil.getMana(caster) >= castingMana && MagicUtil.subtractMana(caster, castingMana)) {
                Vec3d start = caster.func_174824_e(1.0f);
                Vec3d end = start.func_178787_e(caster.func_70040_Z().func_186678_a(5.0));
                RayTraceResult result = worldIn.func_72933_a(start, end);
                BlockPos pos = caster.func_180425_c();
                if (result != null) {
                    pos = result.func_178782_a();
                }
                if (this.getCurrentSpell(stack).castSpell(caster, worldIn, pos, this, stack, 1.0f * this.getSpellPowerModifier() * this.getSpellPowerModifier(caster)) && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_184811_cZ().func_185145_a((Item)this, Math.round((float)this.getCurrentSpell(stack).getSpellCooldown() * this.getSpellCooldownModifier() * this.getSpellCooldownModifier(caster)));
                }
            }
        }
        return super.func_77654_b(stack, worldIn, caster);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return CapabilityItemHandlerItemProvider.createProvider(stack, this.getSpellSlotCount());
    }
}

