/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.magic;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.cqr.cqrepoured.API.events.CQRMagicSystemRegisterSpellsEvent;
import team.cqr.cqrepoured.magic.AbstractSpell;

public class SpellRegistry {
    private static final Map<String, Map<String, AbstractSpell>> SPELL_REGISTRY = new ConcurrentHashMap<String, Map<String, AbstractSpell>>();

    public static void initialize() {
        HashSet<AbstractSpell> spells = new HashSet<AbstractSpell>();
        CQRMagicSystemRegisterSpellsEvent registerEvent = new CQRMagicSystemRegisterSpellsEvent(spells);
        if (MinecraftForge.EVENT_BUS.post((Event)registerEvent)) {
            for (AbstractSpell spell : spells) {
                try {
                    SpellRegistry.registerSpell(spell.getSpellId(), spell);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Nullable
    public static AbstractSpell getSpell(ResourceLocation spellId) {
        if (SPELL_REGISTRY.containsKey(spellId.func_110624_b())) {
            return SPELL_REGISTRY.get(spellId.func_110624_b()).getOrDefault(spellId.func_110623_a(), null);
        }
        return null;
    }

    private static void registerSpell(ResourceLocation spellId, AbstractSpell spell) {
        SPELL_REGISTRY.computeIfAbsent(spellId.func_110624_b(), key -> new ConcurrentHashMap()).put(spellId.func_110623_a(), spell);
    }
}

