/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import team.cqr.cqrepoured.network.datasync.DataEntry;

public class DataEntryByte
extends DataEntry<Byte> {
    private byte value;

    public DataEntryByte(String name, byte defaultValue, boolean isClientModificationAllowed) {
        super(name, isClientModificationAllowed);
        this.value = defaultValue;
    }

    @Override
    public NBTBase write() {
        return new NBTTagByte(this.value);
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        if (nbt instanceof NBTTagByte) {
            this.value = ((NBTTagByte)nbt).func_150290_f();
        }
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        buf.writeByte((int)this.value);
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.value = buf.readByte();
    }

    @Override
    @Deprecated
    public void set(@Nonnull Byte value) {
        if (value == null) {
            return;
        }
        this.set((byte)value);
    }

    @Override
    @Deprecated
    protected void setInternal(@Nonnull Byte value) {
        if (value == null) {
            return;
        }
        this.setInternal((byte)value);
    }

    @Override
    @Deprecated
    public boolean isSavedValueEqualTo(Byte value) {
        return this.isSavedValueEqualTo((byte)value);
    }

    @Override
    @Deprecated
    public Byte get() {
        return this.getByte();
    }

    @Override
    public void set(byte value) {
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    @Override
    protected void setInternal(byte value) {
        this.value = value;
    }

    @Override
    public boolean isSavedValueEqualTo(byte value) {
        return this.value == value;
    }

    public byte getByte() {
        return this.value;
    }
}

