/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagDouble;
import team.cqr.cqrepoured.network.datasync.DataEntry;

public class DataEntryDouble
extends DataEntry<Double> {
    private double value;

    public DataEntryDouble(String name, double defaultValue, boolean isClientModificationAllowed) {
        super(name, isClientModificationAllowed);
        this.value = defaultValue;
    }

    @Override
    public NBTBase write() {
        return new NBTTagDouble(this.value);
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        if (nbt instanceof NBTTagDouble) {
            this.value = ((NBTTagDouble)nbt).func_150286_g();
        }
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        buf.writeDouble(this.value);
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.value = buf.readDouble();
    }

    @Override
    @Deprecated
    public void set(@Nonnull Double value) {
        if (value == null) {
            return;
        }
        this.set((double)value);
    }

    @Override
    @Deprecated
    protected void setInternal(@Nonnull Double value) {
        if (value == null) {
            return;
        }
        this.setInternal((double)value);
    }

    @Override
    @Deprecated
    public boolean isSavedValueEqualTo(Double value) {
        return this.isSavedValueEqualTo((double)value);
    }

    @Override
    @Deprecated
    public Double get() {
        return this.getDouble();
    }

    @Override
    public void set(double value) {
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    @Override
    protected void setInternal(double value) {
        this.value = value;
    }

    @Override
    public boolean isSavedValueEqualTo(double value) {
        return this.value == value;
    }

    public double getDouble() {
        return this.value;
    }
}

