/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import team.cqr.cqrepoured.network.datasync.DataEntry;

public class DataEntryFloat
extends DataEntry<Float> {
    private float value;

    public DataEntryFloat(String name, float defaultValue, boolean isClientModificationAllowed) {
        super(name, isClientModificationAllowed);
        this.value = defaultValue;
    }

    @Override
    public NBTBase write() {
        return new NBTTagFloat(this.value);
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        if (nbt instanceof NBTTagFloat) {
            this.value = ((NBTTagFloat)nbt).func_150288_h();
        }
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        buf.writeFloat(this.value);
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.value = buf.readFloat();
    }

    @Override
    @Deprecated
    public void set(@Nonnull Float value) {
        if (value == null) {
            return;
        }
        this.set(value.floatValue());
    }

    @Override
    @Deprecated
    protected void setInternal(@Nonnull Float value) {
        if (value == null) {
            return;
        }
        this.setInternal(value.floatValue());
    }

    @Override
    @Deprecated
    public boolean isSavedValueEqualTo(Float value) {
        return this.isSavedValueEqualTo(value.floatValue());
    }

    @Override
    @Deprecated
    public Float get() {
        return Float.valueOf(this.getFloat());
    }

    @Override
    public void set(float value) {
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    @Override
    protected void setInternal(float value) {
        this.value = value;
    }

    @Override
    public boolean isSavedValueEqualTo(float value) {
        return this.value == value;
    }

    public float getFloat() {
        return this.value;
    }
}

