/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagShort;
import team.cqr.cqrepoured.network.datasync.DataEntry;

public class DataEntryShort
extends DataEntry<Short> {
    private short value;

    public DataEntryShort(String name, short defaultValue, boolean isClientModificationAllowed) {
        super(name, isClientModificationAllowed);
        this.value = defaultValue;
    }

    @Override
    public NBTBase write() {
        return new NBTTagShort(this.value);
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        if (nbt instanceof NBTTagShort) {
            this.value = ((NBTTagShort)nbt).func_150289_e();
        }
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        buf.writeShort((int)this.value);
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.value = buf.readShort();
    }

    @Override
    @Deprecated
    public void set(@Nonnull Short value) {
        if (value == null) {
            return;
        }
        this.set((short)value);
    }

    @Override
    @Deprecated
    protected void setInternal(@Nonnull Short value) {
        if (value == null) {
            return;
        }
        this.setInternal((short)value);
    }

    @Override
    @Deprecated
    public boolean isSavedValueEqualTo(Short value) {
        return this.isSavedValueEqualTo((short)value);
    }

    @Override
    @Deprecated
    public Short get() {
        return this.getShort();
    }

    @Override
    public void set(short value) {
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    @Override
    protected void setInternal(short value) {
        this.value = value;
    }

    @Override
    public boolean isSavedValueEqualTo(short value) {
        return this.value == value;
    }

    public short getShort() {
        return this.value;
    }
}

