/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.network.client.packet.CPacketSyncTileEntity;
import team.cqr.cqrepoured.network.datasync.DataEntry;
import team.cqr.cqrepoured.network.server.packet.SPacketSyncTileEntity;
import team.cqr.cqrepoured.tileentity.ITileEntitySyncable;

public class TileEntityDataManager {
    private final TileEntity tileEntity;
    private final List<DataEntry<?>> entries = new ArrayList();
    private final Set<String> usedNames = new HashSet<String>();
    private boolean isDirty = false;

    public TileEntityDataManager(@Nonnull TileEntity tileEntity) {
        if (tileEntity == null) {
            throw new NullPointerException();
        }
        if (!(tileEntity instanceof ITileEntitySyncable)) {
            throw new IllegalArgumentException();
        }
        this.tileEntity = tileEntity;
    }

    public void register(DataEntry<?> entry) {
        if (entry.isRegistered()) {
            return;
        }
        if (this.usedNames.contains(entry.getName())) {
            return;
        }
        entry.setDataManagerAndId(this, this.entries.size());
        this.entries.add(entry);
        this.usedNames.add(entry.getName());
    }

    public DataEntry<?> getById(int id) {
        if (id < 0 || id >= this.entries.size()) {
            return null;
        }
        return this.entries.get(id);
    }

    public NBTTagCompound write(NBTTagCompound compound) {
        for (DataEntry<?> entry : this.entries) {
            compound.func_74782_a(entry.getName(), entry.write());
        }
        return compound;
    }

    public void read(NBTTagCompound compound) {
        for (DataEntry<?> entry : this.entries) {
            if (!compound.func_74764_b(entry.getName())) continue;
            entry.read(compound.func_74781_a(entry.getName()));
        }
    }

    public void onDataEntryChanged(DataEntry<?> entry) {
    }

    public void checkIfDirtyAndSync() {
        if (this.isDirty) {
            World world = this.tileEntity.func_145831_w();
            if (world != null) {
                ArrayList entryList = new ArrayList();
                for (DataEntry<?> dataEntry : this.entries) {
                    if (!dataEntry.isDirty()) continue;
                    if (!world.field_72995_K || dataEntry.isClientModificationAllowed()) {
                        entryList.add(dataEntry);
                        continue;
                    }
                    dataEntry.clearDirty();
                }
                if (!entryList.isEmpty()) {
                    if (!world.field_72995_K) {
                        int dim = world.field_73011_w.getDimension();
                        BlockPos blockPos = this.tileEntity.func_174877_v();
                        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dim, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 0.0);
                        CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketSyncTileEntity(blockPos, entryList), targetPoint);
                    } else {
                        CQRMain.NETWORK.sendToServer((IMessage)new CPacketSyncTileEntity(this.tileEntity.func_174877_v(), entryList));
                    }
                    for (DataEntry dataEntry : entryList) {
                        dataEntry.clearDirty();
                    }
                }
            }
            this.clearDirty();
        }
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public Collection<DataEntry<?>> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    public void markDirty() {
        if (!this.tileEntity.func_145830_o()) {
            return;
        }
        this.isDirty = true;
        this.tileEntity.func_70296_d();
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

