/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.blocks;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import team.cqr.cqrepoured.tileentity.TileEntityExporterChest;

public abstract class BlockExporterChest
extends BlockHorizontal {
    private static final Set<BlockExporterChest> EXPORTER_CHESTS = new HashSet<BlockExporterChest>();
    protected static final AxisAlignedBB NORTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB SOUTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
    protected static final AxisAlignedBB WEST_CHEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB EAST_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);
    protected static final AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private final ResourceLocation overlayTexture;

    public BlockExporterChest(String resourceName) {
        this(new ResourceLocation(resourceName));
    }

    public BlockExporterChest(String resourceDomain, String resourcePath) {
        this(new ResourceLocation(resourceDomain, resourcePath));
    }

    public BlockExporterChest(ResourceLocation overlayTexture) {
        super(Material.field_151575_d);
        this.overlayTexture = overlayTexture;
        EXPORTER_CHESTS.add(this);
    }

    public static Set<BlockExporterChest> getExporterChests() {
        return Collections.unmodifiableSet(EXPORTER_CHESTS);
    }

    public abstract ResourceLocation getLootTable(World var1, BlockPos var2);

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (BlockExporterChest.isChest(source.func_180495_p(pos.func_177978_c()).func_177230_c())) {
            return NORTH_CHEST_AABB;
        }
        if (BlockExporterChest.isChest(source.func_180495_p(pos.func_177968_d()).func_177230_c())) {
            return SOUTH_CHEST_AABB;
        }
        if (BlockExporterChest.isChest(source.func_180495_p(pos.func_177976_e()).func_177230_c())) {
            return WEST_CHEST_AABB;
        }
        if (BlockExporterChest.isChest(source.func_180495_p(pos.func_177974_f()).func_177230_c())) {
            return EAST_CHEST_AABB;
        }
        return NOT_CONNECTED_AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing connectedChestDirection = null;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!BlockExporterChest.isChest(worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            connectedChestDirection = facing;
            break;
        }
        if (connectedChestDirection != null) {
            EnumFacing otherFacing;
            IBlockState connectedChestState = worldIn.func_180495_p(pos.func_177972_a(connectedChestDirection));
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
            if (facing != (otherFacing = (EnumFacing)connectedChestState.func_177229_b((IProperty)field_185512_D)) || facing == connectedChestDirection || facing.func_176734_d() == connectedChestDirection) {
                if (facing.func_176735_f() == connectedChestDirection || facing.func_176746_e() == connectedChestDirection) {
                    worldIn.func_180501_a(pos.func_177972_a(connectedChestDirection), connectedChestState.func_177226_a((IProperty)field_185512_D, (Comparable)facing), 3);
                } else if (otherFacing.func_176735_f() == connectedChestDirection.func_176734_d() || otherFacing.func_176746_e() == connectedChestDirection.func_176734_d()) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_185512_D, (Comparable)otherFacing), 3);
                } else {
                    worldIn.func_180501_a(pos.func_177972_a(connectedChestDirection), state.func_177226_a((IProperty)field_185512_D, (Comparable)facing.func_176746_e()), 3);
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_185512_D, (Comparable)facing.func_176746_e()), 3);
                }
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return BlockExporterChest.canPlaceChestAt(worldIn, pos);
    }

    private static boolean canPlaceChestAt(World worldIn, BlockPos pos) {
        int i = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!BlockExporterChest.isChest(worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            if (BlockExporterChest.isDoubleChest(worldIn, pos, facing)) {
                return false;
            }
            ++i;
        }
        return i <= 1;
    }

    private static boolean isChest(Block block) {
        return block instanceof BlockExporterChest || block == Blocks.field_150486_ae;
    }

    private static boolean isDoubleChest(World worldIn, BlockPos pos, EnumFacing facing) {
        if (BlockExporterChest.isChest(worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) {
            BlockPos blockpos = pos.func_177972_a(facing).func_177972_a(facing.func_176735_f());
            BlockPos blockpos1 = pos.func_177972_a(facing).func_177972_a(facing);
            BlockPos blockpos2 = pos.func_177972_a(facing).func_177972_a(facing.func_176746_e());
            if (BlockExporterChest.isChest(worldIn.func_180495_p(blockpos).func_177230_c())) {
                return true;
            }
            if (BlockExporterChest.isChest(worldIn.func_180495_p(blockpos1).func_177230_c())) {
                return true;
            }
            if (BlockExporterChest.isChest(worldIn.func_180495_p(blockpos2).func_177230_c())) {
                return true;
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityExporterChest();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Mod.EventBusSubscriber(modid="cqrepoured")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onPlaceBlockEvent(BlockEvent.EntityPlaceEvent event) {
            if (event.getPlacedBlock().func_177230_c() == Blocks.field_150486_ae && !BlockExporterChest.canPlaceChestAt(event.getWorld(), event.getPos())) {
                event.setCanceled(true);
            }
        }
    }
}

