/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai;

import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;

public abstract class AbstractEntityAIAttackSpecial {
    protected final Random random = new Random();
    protected boolean needsTargetToContinue;
    protected boolean needsSightToContinue;
    protected final int maxUseTime;
    protected final int cooldown;

    public AbstractEntityAIAttackSpecial(boolean needsTargetToContinue, boolean needsSightToContinue, int maxUseTime, int cooldown) {
        this.needsTargetToContinue = needsTargetToContinue;
        this.needsSightToContinue = needsSightToContinue;
        this.maxUseTime = maxUseTime;
        this.cooldown = cooldown;
    }

    public abstract boolean shouldStartAttack(AbstractEntityCQR var1, EntityLivingBase var2);

    public abstract boolean shouldContinueAttack(AbstractEntityCQR var1, EntityLivingBase var2);

    public abstract boolean isInterruptible(AbstractEntityCQR var1);

    public abstract void startAttack(AbstractEntityCQR var1, EntityLivingBase var2);

    public abstract void continueAttack(AbstractEntityCQR var1, EntityLivingBase var2, int var3);

    public abstract void stopAttack(AbstractEntityCQR var1, EntityLivingBase var2);

    public abstract void resetAttack(AbstractEntityCQR var1);

    public double getAttackRange(AbstractEntityCQR attacker, EntityLivingBase target) {
        return attacker.getAttackReach(target);
    }

    public double getAttackChance(AbstractEntityCQR attacker, EntityLivingBase target) {
        return 0.1;
    }

    public boolean needsTargetToContinue() {
        return this.needsTargetToContinue;
    }

    public boolean needsSightToContinue() {
        return this.needsSightToContinue;
    }

    public int getMaxUseTime() {
        return this.maxUseTime;
    }

    public int getCooldown(AbstractEntityCQR attacker) {
        return this.cooldown;
    }
}

