/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import team.cqr.cqrepoured.objects.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;

public class EntityAIAttack
extends AbstractCQREntityAI<AbstractEntityCQR> {
    protected int attackTick;
    private float attackCooldownOverhead;

    public EntityAIAttack(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        return attackTarget != null && this.entity.func_70635_at().func_75522_a((Entity)attackTarget);
    }

    public boolean func_75253_b() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        return attackTarget != null && this.entity.func_70635_at().func_75522_a((Entity)attackTarget);
    }

    public void func_75249_e() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        this.updatePath(attackTarget);
        this.checkAndPerformBlock();
    }

    public void func_75246_d() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget != null) {
            this.entity.func_70671_ap().func_75651_a((Entity)attackTarget, 12.0f, 12.0f);
            this.updatePath(attackTarget);
            this.checkAndPerformAttack(this.entity.func_70638_az());
            this.checkAndPerformBlock();
        }
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.entity.func_184602_cy();
    }

    protected void updatePath(EntityLivingBase target) {
        this.entity.func_70661_as().func_75497_a((Entity)target, 1.0);
    }

    protected void checkAndPerformBlock() {
        ItemStack offhand;
        if (this.entity.getLastTimeHitByAxeWhileBlocking() + 80 > this.entity.field_70173_aa) {
            if (this.entity.func_184585_cz()) {
                this.entity.func_184602_cy();
            }
        } else if (this.attackTick + this.getBlockCooldownPeriod() <= this.entity.field_70173_aa && !this.entity.func_184585_cz() && (offhand = this.entity.func_184592_cb()).func_77973_b().isShield(offhand, (EntityLivingBase)this.entity)) {
            this.entity.func_184598_c(EnumHand.OFF_HAND);
        }
    }

    protected void checkAndPerformAttack(EntityLivingBase attackTarget) {
        if (this.attackTick + (int)this.getAttackCooldownPeriod() <= this.entity.field_70173_aa && this.entity.isInAttackReach(attackTarget)) {
            if (this.entity.func_184585_cz()) {
                this.entity.func_184602_cy();
            }
            this.attackCooldownOverhead = (float)this.attackTick + this.getAttackCooldownPeriod() > (float)this.entity.field_70173_aa ? this.getAttackCooldownPeriod() % 1.0f : 0.0f;
            this.attackTick = this.entity.field_70173_aa;
            this.entity.func_184609_a(EnumHand.MAIN_HAND);
            this.entity.func_70652_k((Entity)attackTarget);
        }
    }

    public float getAttackCooldownPeriod() {
        return (float)(1.0 / this.entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0) + this.attackCooldownOverhead;
    }

    public int getBlockCooldownPeriod() {
        return 30;
    }
}

