/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.EnumDifficulty;
import team.cqr.cqrepoured.objects.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.objects.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.IRangedWeapon;

public class EntityAIAttackRanged
extends AbstractCQREntityAI<AbstractEntityCQR> {
    protected int prevTimeAttacked;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public EntityAIAttackRanged(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.isRangedWeapon(this.entity.func_184614_ca().func_77973_b())) {
            return false;
        }
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget == null) {
            return false;
        }
        return this.entity.func_70635_at().func_75522_a((Entity)attackTarget);
    }

    public boolean func_75253_b() {
        if (!this.isRangedWeapon(this.entity.func_184614_ca().func_77973_b())) {
            return false;
        }
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget == null) {
            return false;
        }
        return this.entity.getLastTimeSeenAttackTarget() + 100 >= this.entity.field_70173_aa;
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.entity.func_184602_cy();
        this.entity.field_82175_bq = false;
    }

    public void func_75246_d() {
        EntityLivingBase attackTarget = this.entity.func_70638_az();
        if (attackTarget == null) {
            return;
        }
        double distance = this.entity.func_70032_d((Entity)attackTarget);
        if (this.entity.func_70635_at().func_75522_a((Entity)attackTarget) && (distance < this.getAttackRange() * 0.9 || distance < this.getAttackRange() && !this.entity.func_70781_l())) {
            this.entity.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
            this.checkAndPerformAttack(attackTarget);
            this.entity.func_70661_as().func_75499_g();
            ++this.strafingTime;
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)attackTarget, 1.0);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if (this.random.nextDouble() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if (this.random.nextDouble() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.canStrafe() && this.strafingTime > -1) {
            if (distance > this.getAttackRange() * 0.75) {
                this.strafingBackwards = false;
            } else if (distance < this.getAttackRange() * 0.25) {
                this.strafingBackwards = true;
            }
            float f = (float)(this.entity.func_184222_aU() ? CQRConfig.mobs.entityStrafingSpeed : CQRConfig.mobs.entityStrafingSpeedBoss);
            this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -f : f, this.strafingClockwise ? f : -f);
        }
    }

    private boolean canStrafe() {
        if (!this.entity.canStrafe()) {
            return false;
        }
        return this.entity.func_184222_aU() ? CQRConfig.mobs.enableEntityStrafing : CQRConfig.mobs.enableEntityStrafingBoss;
    }

    protected void checkAndPerformAttack(EntityLivingBase attackTarget) {
        if (this.entity.field_70173_aa > this.prevTimeAttacked + this.getAttackCooldown()) {
            if (this.getAttackChargeTicks() > 0) {
                this.entity.func_184598_c(EnumHand.MAIN_HAND);
                this.entity.field_82175_bq = true;
            }
            if (this.entity.func_184612_cw() >= this.getAttackChargeTicks()) {
                ItemStack stack = this.entity.func_184614_ca();
                Item item = stack.func_77973_b();
                if (item instanceof ItemBow) {
                    ItemStack arrowItem = this.entity.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.ARROW);
                    if (arrowItem.func_190926_b() || !(arrowItem.func_77973_b() instanceof ItemArrow)) {
                        arrowItem = new ItemStack(Items.field_151032_g);
                    }
                    EntityArrow arrow = ((ItemArrow)arrowItem.func_77973_b()).func_185052_a(this.world, arrowItem, (EntityLivingBase)this.entity);
                    double x = attackTarget.field_70165_t - this.entity.field_70165_t;
                    double y = attackTarget.field_70163_u + (double)attackTarget.field_70131_O * 0.5 - arrow.field_70163_u;
                    double z = attackTarget.field_70161_v - this.entity.field_70161_v;
                    double distance = Math.sqrt(x * x + z * z);
                    float inaccuracy = 4.0f;
                    if (this.world.func_175659_aa() == EnumDifficulty.HARD) {
                        inaccuracy = 1.0f;
                    } else if (this.world.func_175659_aa() == EnumDifficulty.NORMAL) {
                        inaccuracy = 2.0f;
                    }
                    arrow.func_70186_c(x, y + distance * distance * 0.0045, z, 2.4f, inaccuracy);
                    arrow.field_70159_w += this.entity.field_70159_w;
                    arrow.field_70179_y += this.entity.field_70179_y;
                    if (!this.entity.field_70122_E) {
                        arrow.field_70181_x += this.entity.field_70181_x;
                    }
                    this.world.func_72838_d((Entity)arrow);
                    this.entity.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                } else if (item instanceof IRangedWeapon) {
                    ((IRangedWeapon)item).shoot(this.world, (EntityLivingBase)this.entity, (Entity)attackTarget, EnumHand.MAIN_HAND);
                    if (((IRangedWeapon)item).getShootSound() != null) {
                        this.entity.func_184185_a(((IRangedWeapon)item).getShootSound(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                    }
                }
                this.prevTimeAttacked = this.entity.field_70173_aa;
                if (this.getAttackChargeTicks() > 0) {
                    this.entity.func_184602_cy();
                    this.entity.field_82175_bq = false;
                } else {
                    this.entity.func_184609_a(EnumHand.MAIN_HAND);
                }
            }
        }
    }

    protected boolean isRangedWeapon(Item item) {
        return item instanceof ItemBow || item instanceof IRangedWeapon;
    }

    protected double getAttackRange() {
        ItemStack stack = this.entity.func_184614_ca();
        Item item = stack.func_77973_b();
        if (item instanceof ItemBow) {
            return 32.0;
        }
        if (item instanceof IRangedWeapon) {
            return ((IRangedWeapon)item).getRange();
        }
        return 32.0;
    }

    protected int getAttackCooldown() {
        ItemStack stack = this.entity.func_184614_ca();
        Item item = stack.func_77973_b();
        if (item instanceof ItemBow) {
            switch (this.world.func_175659_aa()) {
                case HARD: {
                    return 20;
                }
                case NORMAL: {
                    return 30;
                }
            }
            return 40;
        }
        if (item instanceof IRangedWeapon) {
            return ((IRangedWeapon)item).getCooldown();
        }
        return 40;
    }

    protected int getAttackChargeTicks() {
        ItemStack stack = this.entity.func_184614_ca();
        Item item = stack.func_77973_b();
        if (item instanceof ItemBow) {
            return 20;
        }
        if (item instanceof IRangedWeapon) {
            return ((IRangedWeapon)item).getChargeTicks();
        }
        return 40;
    }
}

