/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.objects.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.entity.pathfinding.Path;

public class EntityAIFollowPath
extends AbstractCQREntityAI<AbstractEntityCQR> {
    private boolean hasPath;
    private int ticksToWait;
    private int tick;

    public EntityAIFollowPath(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.entity.getPath().getSize() <= 1) {
            return false;
        }
        return this.entity.hasHomePositionCQR();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.hasPath = false;
        this.ticksToWait = 0;
        this.tick = 0;
    }

    public void func_75246_d() {
        Path path = this.entity.getPath();
        Path.PathNode currentNode = path.getNode(this.entity.getCurrentPathTargetPoint());
        if (currentNode != null) {
            BlockPos pos = this.entity.getHomePositionCQR().func_177971_a((Vec3i)currentNode.getPos());
            if (this.entity.func_70781_l()) {
                this.entity.func_70671_ap().func_75650_a((double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + this.entity.func_70047_e()), (double)pos.func_177952_p() + 0.5, 30.0f, 30.0f);
            } else if (this.hasPath) {
                this.hasPath = false;
                if (this.entity.func_70092_e((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5) <= 1.0) {
                    this.ticksToWait = MathHelper.func_76136_a((Random)this.random, (int)currentNode.getWaitingTimeMin(), (int)currentNode.getWaitingTimeMax());
                }
            } else if (this.ticksToWait > 0) {
                --this.ticksToWait;
                this.entity.field_70177_z = currentNode.getWaitingRotation();
                long time = this.world.func_72820_D() % 24000L;
                if (time < (long)currentNode.getTimeMin() || time > (long)currentNode.getTimeMax()) {
                    this.ticksToWait = 0;
                }
            } else {
                this.calculateNextNode();
            }
        } else {
            this.entity.func_70661_as().func_75499_g();
            this.calculateNextNode();
        }
    }

    private void calculateNextNode() {
        BlockPos pos;
        if (this.tick > 0) {
            --this.tick;
            return;
        }
        Path path = this.entity.getPath();
        Path.PathNode prevNode = path.getNode(this.entity.getPrevPathTargetPoint());
        Path.PathNode currentNode = path.getNode(this.entity.getCurrentPathTargetPoint());
        Path.PathNode nextNode = null;
        if (currentNode != null) {
            nextNode = currentNode.getNextNode(this.world, this.entity.func_70681_au(), prevNode);
        } else {
            pos = new BlockPos((Entity)this.entity).func_177973_b((Vec3i)this.entity.getHomePositionCQR());
            double min = Double.MAX_VALUE;
            for (Path.PathNode node : path.getNodes()) {
                double dist = pos.func_177951_i((Vec3i)node.getPos());
                if (!(dist < min)) continue;
                min = dist;
                nextNode = node;
            }
        }
        if (nextNode != null) {
            this.entity.setCurrentPathTargetPoint(nextNode.getIndex());
            pos = this.entity.getHomePositionCQR().func_177971_a((Vec3i)nextNode.getPos());
            this.entity.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), Math.sqrt(0.75));
            this.hasPath = true;
        } else {
            this.tick = 40;
        }
    }
}

