/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise;

import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationAI;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.objects.entity.boss.EntityCQRGiantTortoise;
import team.cqr.cqrepoured.objects.entity.projectiles.ProjectileBubble;

public class BossAITortoiseSpinAttack
extends AnimationAI<EntityCQRGiantTortoise> {
    private Vec3d movementVector;
    private static final int COOLDOWN = 10;
    private int cooldown = 5;
    private int previousBlocks = 0;
    private static final int MAX_BLOCKED_SPINS = 1;
    private final int AFTER_IDLE_TIME = 5;
    private final int BUBBLE_SHOOT_DURATION = 20;
    static final int MAX_DISTANCE_TO_BEGIN_SPIN = 16;
    static final int MAX_DISTANCE_TO_TARGET = 20;
    private int explosionCooldown = 0;
    private static final int MAX_EXPLOSION_COOLDOWN = 20;

    public BossAITortoiseSpinAttack(EntityCQRGiantTortoise entity) {
        super((Entity)entity);
    }

    private EntityCQRGiantTortoise getBoss() {
        return (EntityCQRGiantTortoise)this.entity;
    }

    public Animation getAnimation() {
        return EntityCQRGiantTortoise.ANIMATION_SPIN;
    }

    public boolean func_75250_a() {
        --this.cooldown;
        if (!this.getBoss().isStunned() && this.getBoss().func_70638_az() != null && !this.getBoss().func_70638_az().field_70128_L) {
            if (this.getBoss().func_70032_d((Entity)this.getBoss().func_70638_az()) > 16.0f) {
                return false;
            }
        } else {
            return false;
        }
        if (this.cooldown <= 0 && !this.getBoss().isHealing()) {
            this.getBoss().setWantsToSpin(true);
            this.cooldown = 0;
            this.previousBlocks = 0;
            if (this.getBoss().isInShell() && this.getBoss().isReadyToSpin()) {
                this.getBoss().setCanBeStunned(false);
                this.getBoss().setSpinning(true);
                this.getBoss().setWantsToSpin(false);
                return true;
            }
            this.getBoss().targetNewState(-1);
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.getBoss() != null && this.getBoss().getAnimation() == this.getAnimation() && !this.getBoss().isStunned() && this.getBoss().getSpinsBlocked() <= 1 && super.func_75253_b() && !this.getBoss().field_70128_L && this.getBoss().func_70638_az() != null && !this.getBoss().func_70638_az().field_70128_L && !this.getBoss().isHealing();
    }

    private void calculateVelocity() {
        this.movementVector = this.getBoss().func_70638_az().func_174791_d().func_178788_d(this.getBoss().func_174791_d());
        if (this.movementVector.field_72448_b >= 2.0) {
            this.movementVector = this.movementVector.func_178786_a(0.0, this.movementVector.field_72448_b, 0.0);
        }
        this.movementVector = this.movementVector.func_72432_b();
        this.movementVector = this.movementVector.func_186678_a(1.125);
    }

    public boolean isAutomatic() {
        return false;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.getBoss().setSpinning(true);
        this.getBoss().setCanBeStunned(false);
        this.getBoss().setInShell(true);
        this.getBoss().setReadyToSpin(false);
        this.getBoss().setAnimation(this.getAnimation());
        this.getBoss().currentAnim = this;
        this.getBoss().setAnimationTick(0);
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.getBoss().getSpinsBlocked() >= 1) {
            this.getBoss().setSpinning(false);
            this.getBoss().setStunned(true);
        } else if (this.getBoss().getAnimationTick() > this.BUBBLE_SHOOT_DURATION && this.getAnimation().getDuration() - this.getBoss().getAnimationTick() > this.AFTER_IDLE_TIME) {
            if (this.explosionCooldown > 0) {
                --this.explosionCooldown;
            }
            if (this.getBoss().field_70123_F || this.movementVector == null || this.getBoss().func_70032_d((Entity)this.getBoss().func_70638_az()) >= 20.0f || this.previousBlocks != this.getBoss().getSpinsBlocked()) {
                if (this.getBoss().field_70123_F && !this.getBoss().func_82194_d().field_72995_K && this.explosionCooldown <= 0) {
                    this.explosionCooldown = 20;
                    this.getBoss().func_82194_d().func_72885_a((Entity)this.getBoss(), ((EntityCQRGiantTortoise)this.entity).func_174791_d().field_72450_a, ((EntityCQRGiantTortoise)this.entity).func_174791_d().field_72448_b, ((EntityCQRGiantTortoise)this.entity).func_174791_d().field_72449_c, 2.0f, false, false);
                }
                if (this.hitHardBlock(this.movementVector)) {
                    this.getBoss().setSpinning(false);
                    this.getBoss().setStunned(true);
                }
                this.calculateVelocity();
                float damage = 1.0f;
                if (this.previousBlocks != this.getBoss().getSpinsBlocked()) {
                    this.previousBlocks = this.getBoss().getSpinsBlocked();
                    damage *= 1.5f;
                    this.getBoss().attackEntityFrom(DamageSource.field_76368_d, damage /= (float)Math.max(1, this.getBoss().func_82194_d().func_175659_aa().func_151525_a()), true);
                }
            }
            this.getBoss().setSpinning(true);
            this.getBoss().setCanBeStunned(false);
            this.getBoss().setInShell(true);
            this.getBoss().field_70159_w = this.movementVector.field_72450_a;
            this.getBoss().field_70179_y = this.movementVector.field_72449_c;
            this.getBoss().field_70181_x = ((EntityCQRGiantTortoise)this.entity).field_70123_F ? this.movementVector.field_72448_b : 0.5 * this.movementVector.field_72448_b;
            this.getBoss().field_70133_I = true;
        } else if (this.getBoss().getAnimationTick() <= this.BUBBLE_SHOOT_DURATION) {
            this.getBoss().setSpinning(false);
            if (this.getBoss().getAnimationTick() % 5 == 0) {
                this.getBoss().func_184185_a(CQRSounds.BUBBLE_BUBBLE, 1.0f, 0.75f + 0.5f * this.getBoss().func_70681_au().nextFloat());
            }
            Vec3d v = new Vec3d(((EntityCQRGiantTortoise)this.entity).func_70681_au().nextDouble() - 0.5, 0.125 * (((EntityCQRGiantTortoise)this.entity).func_70681_au().nextDouble() - 0.5), ((EntityCQRGiantTortoise)this.entity).func_70681_au().nextDouble() - 0.5);
            v = v.func_72432_b();
            v = v.func_186678_a(1.4);
            ((EntityCQRGiantTortoise)this.entity).func_70625_a((Entity)((EntityCQRGiantTortoise)this.entity).func_70638_az(), 30.0f, 30.0f);
            ProjectileBubble bubble = new ProjectileBubble(((EntityCQRGiantTortoise)this.entity).field_70170_p, (EntityLivingBase)this.entity);
            bubble.field_70159_w = v.field_72450_a;
            bubble.field_70181_x = v.field_72448_b;
            bubble.field_70179_y = v.field_72449_c;
            bubble.field_70133_I = true;
            ((EntityCQRGiantTortoise)this.entity).field_70170_p.func_72838_d((Entity)bubble);
        } else {
            this.getBoss().setSpinning(false);
            this.getBoss().resetSpinsBlocked();
        }
    }

    private boolean hitHardBlock(Vec3d velocity) {
        AxisAlignedBB aabb = this.getBoss().func_70046_E();
        if (aabb == null) {
            return false;
        }
        aabb = aabb.func_186662_g(0.5).func_191194_a(velocity.func_72432_b().func_186678_a((double)(this.getBoss().field_70130_N / 2.0f)));
        World world = this.getBoss().func_82194_d();
        int x1 = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int y1 = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int z1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int x2 = MathHelper.func_76128_c((double)aabb.field_72336_d);
        int y2 = MathHelper.func_76128_c((double)aabb.field_72337_e);
        int z2 = MathHelper.func_76128_c((double)aabb.field_72334_f);
        for (int k1 = x1; k1 <= x2; ++k1) {
            for (int l1 = y1; l1 <= y2; ++l1) {
                for (int i2 = z1; i2 <= z2; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = world.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (!EntityCQRGiantTortoise.isHardBlock(block.getRegistryName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.getBoss().setSpinning(false);
        this.getBoss().setReadyToSpin(true);
        this.getBoss().setCanBeStunned(true);
        this.cooldown = 10;
        if (this.getBoss().func_70638_az() == null || this.getBoss().func_70638_az().field_70128_L) {
            this.cooldown /= 3;
        }
        this.getBoss().setAnimationTick(0);
        if (this.getBoss().getSpinsBlocked() >= 1) {
            this.cooldown = (int)((double)this.cooldown * 1.5);
            this.getBoss().setStunned(true);
        }
        this.getBoss().resetSpinsBlocked();
    }
}

