/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai.spells;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import team.cqr.cqrepoured.objects.entity.ai.spells.IEntityAISpell;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;

public abstract class AbstractEntityAISpell<T extends AbstractEntityCQR>
implements IEntityAISpell {
    protected final Random random = new Random();
    protected final T entity;
    protected final World world;
    protected boolean needsTargetToStart;
    protected boolean needsSightToStart;
    protected boolean needsTargetToContinue;
    protected boolean needsSightToContinue;
    protected final int cooldown;
    protected final int chargingTicks;
    protected final int castingTicks;
    protected int prevTimeCasted;
    protected int tick;

    public AbstractEntityAISpell(T entity, int cooldown, int chargingTicks, int castingTicks) {
        this.entity = entity;
        this.world = ((AbstractEntityCQR)((Object)entity)).field_70170_p;
        this.cooldown = cooldown;
        this.chargingTicks = Math.max(chargingTicks, 0);
        this.castingTicks = Math.max(castingTicks, 1);
        this.prevTimeCasted = -this.random.nextInt(cooldown + 1) - 1;
    }

    @Override
    public boolean shouldExecute() {
        if (!this.entity.func_70089_S()) {
            return false;
        }
        if (this.needsTargetToStart) {
            EntityLivingBase attackTarget = this.entity.func_70638_az();
            if (attackTarget == null) {
                return false;
            }
            if (this.needsSightToStart && !this.entity.func_70635_at().func_75522_a((Entity)attackTarget)) {
                return false;
            }
        }
        return ((AbstractEntityCQR)((Object)this.entity)).field_70173_aa > this.prevTimeCasted + this.cooldown;
    }

    @Override
    public boolean shouldContinueExecuting() {
        if (!this.entity.func_70089_S()) {
            return false;
        }
        if (this.needsTargetToContinue) {
            EntityLivingBase attackTarget = this.entity.func_70638_az();
            if (attackTarget == null) {
                return false;
            }
            if (this.needsSightToContinue && !this.entity.func_70635_at().func_75522_a((Entity)attackTarget)) {
                return false;
            }
        }
        return this.tick < this.chargingTicks + this.castingTicks;
    }

    @Override
    public boolean isInterruptible() {
        return false;
    }

    @Override
    public void startExecuting() {
        this.tick = 0;
    }

    @Override
    public void resetTask() {
        this.prevTimeCasted = ((AbstractEntityCQR)((Object)this.entity)).field_70173_aa;
        this.tick = -1;
    }

    @Override
    public void updateTask() {
        if (this.tick < this.chargingTicks) {
            if (this.tick == 0) {
                this.startChargingSpell();
            }
            this.chargeSpell();
        } else {
            if (this.tick == this.chargingTicks) {
                this.startCastingSpell();
            }
            this.castSpell();
        }
        ++this.tick;
    }

    @Override
    public boolean isCharging() {
        return this.tick != -1 && this.tick < this.chargingTicks;
    }

    @Override
    public boolean isCasting() {
        return this.tick != -1 && this.tick < this.chargingTicks + this.castingTicks;
    }

    @Override
    public void startChargingSpell() {
        if (this.getStartChargingSound() != null) {
            this.entity.func_184185_a(this.getStartChargingSound(), 1.0f, 0.9f + 0.2f * this.random.nextFloat());
        }
    }

    @Override
    public void chargeSpell() {
    }

    @Override
    public void startCastingSpell() {
        if (this.getStartCastingSound() != null) {
            this.entity.func_184185_a(this.getStartCastingSound(), 1.0f, 0.9f + 0.2f * this.random.nextFloat());
        }
    }

    @Override
    public void castSpell() {
    }

    @Nullable
    protected SoundEvent getStartChargingSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getStartCastingSound() {
        return null;
    }

    protected void setup(boolean needsTargetToStart, boolean needsSightToStart, boolean needsTargetToContinue, boolean needsSightToContinue) {
        this.needsTargetToStart = needsTargetToStart;
        this.needsSightToStart = needsSightToStart;
        this.needsTargetToContinue = needsTargetToContinue;
        this.needsSightToContinue = needsSightToContinue;
    }
}

