/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai.target;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.objects.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.objects.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.items.IFakeWeapon;
import team.cqr.cqrepoured.objects.items.ISupportWeapon;

public class EntityAICQRNearestAttackTarget
extends AbstractCQREntityAI<AbstractEntityCQR> {
    public EntityAICQRNearestAttackTarget(AbstractEntityCQR entity) {
        super(entity);
    }

    public boolean func_75250_a() {
        if (this.world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.entity.func_70624_b(null);
            return false;
        }
        if (this.isStillSuitableTarget(this.entity.func_70638_az())) {
            return false;
        }
        this.entity.func_70624_b(null);
        if (!this.entity.hasFaction()) {
            return false;
        }
        return this.random.nextInt(3) == 0;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        AxisAlignedBB aabb = this.entity.func_174813_aQ().func_186662_g(32.0);
        List possibleTargets = this.world.func_72872_a(EntityLivingBase.class, aabb);
        LinkedList<EntityLivingBase> possibleTargetsAlly = new LinkedList<EntityLivingBase>();
        LinkedList<EntityLivingBase> possibleTargetsEnemy = new LinkedList<EntityLivingBase>();
        this.fillLists(possibleTargets, possibleTargetsAlly, possibleTargetsEnemy);
        if (!possibleTargetsAlly.isEmpty()) {
            this.entity.func_70624_b(TargetUtil.getNearestEntity((EntityLiving)this.entity, possibleTargetsAlly));
        } else if (!possibleTargetsEnemy.isEmpty()) {
            this.entity.func_70624_b(TargetUtil.getNearestEntity((EntityLiving)this.entity, possibleTargetsEnemy));
        }
    }

    private void fillLists(List<EntityLivingBase> list, List<EntityLivingBase> allies, List<EntityLivingBase> enemies) {
        for (EntityLivingBase possibleTarget : list) {
            if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)possibleTarget) || !EntitySelectors.field_94557_a.apply((Object)possibleTarget) || possibleTarget == this.entity) continue;
            if (this.canTargetAlly() && this.isSuitableTargetAlly(possibleTarget)) {
                allies.add(possibleTarget);
                continue;
            }
            if (!this.isSuitableTargetEnemy(possibleTarget)) continue;
            enemies.add(possibleTarget);
        }
    }

    private boolean canTargetAlly() {
        Item item = this.entity.func_184614_ca().func_77973_b();
        return item instanceof ISupportWeapon || item instanceof IFakeWeapon;
    }

    private boolean isSuitableTargetAlly(EntityLivingBase possibleTarget) {
        CQRFaction faction = this.entity.getFaction();
        if (faction == null) {
            return false;
        }
        if (!faction.isAlly((Entity)possibleTarget) && possibleTarget != this.entity.getLeader()) {
            return false;
        }
        if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
            return false;
        }
        if (!this.entity.isInSightRange((Entity)possibleTarget)) {
            return false;
        }
        return this.entity.func_70635_at().func_75522_a((Entity)possibleTarget);
    }

    private boolean isSuitableTargetEnemy(EntityLivingBase possibleTarget) {
        CQRFaction faction = this.entity.getFaction();
        if (faction == null) {
            return false;
        }
        if (!faction.isEnemy((Entity)possibleTarget)) {
            return false;
        }
        if (possibleTarget == this.entity.getLeader()) {
            return false;
        }
        if (!this.entity.func_70635_at().func_75522_a((Entity)possibleTarget)) {
            return false;
        }
        if (this.entity.isInAttackReach(possibleTarget)) {
            return true;
        }
        if (this.entity.isEntityInFieldOfView(possibleTarget)) {
            return this.entity.isInSightRange((Entity)possibleTarget);
        }
        return !possibleTarget.func_70093_af() && (double)this.entity.func_70032_d((Entity)possibleTarget) < 12.0;
    }

    private boolean isStillSuitableTarget(EntityLivingBase possibleTarget) {
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)possibleTarget)) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply((Object)possibleTarget)) {
            return false;
        }
        if (possibleTarget == this.entity) {
            return false;
        }
        if ((double)this.entity.func_70032_d((Entity)possibleTarget) > 64.0) {
            return false;
        }
        CQRFaction faction = this.entity.getFaction();
        if (faction == null) {
            return false;
        }
        if (faction.isAlly((Entity)possibleTarget) || possibleTarget == this.entity.getLeader()) {
            if (!this.canTargetAlly()) {
                return false;
            }
            if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
                return false;
            }
        }
        return true;
    }
}

