/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai.target;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.objects.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.objects.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.items.staves.ItemStaffHealing;
import team.cqr.cqrepoured.util.CQRConfig;

public class EntityAIHurtByTarget
extends AbstractCQREntityAI<AbstractEntityCQR> {
    protected EntityLivingBase attackTarget;
    protected int prevRevengeTimer;

    public EntityAIHurtByTarget(AbstractEntityCQR entity) {
        super(entity);
    }

    public boolean func_75250_a() {
        if (this.world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (this.entity.func_142015_aE() == this.prevRevengeTimer) {
            return false;
        }
        EntityLivingBase revengeTarget = this.entity.func_70643_av();
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)revengeTarget)) {
            return false;
        }
        if (!revengeTarget.func_70089_S()) {
            return false;
        }
        CQRFaction faction = this.entity.getFaction();
        if (faction != null && faction.isAlly((Entity)revengeTarget)) {
            return false;
        }
        if (revengeTarget == this.entity.getLeader()) {
            return false;
        }
        if (!this.entity.isInSightRange((Entity)revengeTarget)) {
            return false;
        }
        this.attackTarget = revengeTarget;
        return true;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        this.prevRevengeTimer = this.entity.func_142015_aE();
        this.trySetAttackTarget((EntityLiving)this.entity);
        CQRFaction faction = this.entity.getFaction();
        if (faction != null && faction.isEnemy((Entity)this.attackTarget)) {
            this.callForHelp();
        }
    }

    protected void callForHelp() {
        double radius = CQRConfig.mobs.alertRadius;
        Vec3d eyeVec = this.entity.func_174824_e(1.0f);
        Vec3d vec1 = eyeVec.func_178786_a(radius, radius * 0.5, radius);
        Vec3d vec2 = eyeVec.func_72441_c(radius, radius * 0.5, radius);
        AxisAlignedBB aabb = new AxisAlignedBB(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
        List allies = this.world.func_175647_a(EntityLiving.class, aabb, this::isSuitableAlly);
        for (EntityLiving ally : allies) {
            this.trySetAttackTarget(ally);
        }
    }

    protected boolean isSuitableAlly(EntityLiving possibleAlly) {
        if (!EntitySelectors.field_94557_a.apply((Object)possibleAlly)) {
            return false;
        }
        if (possibleAlly == this.entity) {
            return false;
        }
        CQRFaction faction = this.entity.getFaction();
        if (faction == null || !faction.isAlly((Entity)possibleAlly)) {
            return false;
        }
        Path path = possibleAlly.func_70661_as().func_75494_a((Entity)this.entity);
        return path != null && path.func_75874_d() <= 20;
    }

    protected boolean trySetAttackTarget(EntityLiving entityLiving) {
        AbstractEntityCQR entityCQR;
        CQRFaction faction;
        if (entityLiving.func_184614_ca().func_77973_b() instanceof ItemStaffHealing) {
            return false;
        }
        if (entityLiving instanceof AbstractEntityCQR && (faction = (entityCQR = (AbstractEntityCQR)entityLiving).getFaction()) != null && faction.isAlly((Entity)this.attackTarget)) {
            return false;
        }
        EntityLivingBase oldAttackTarget = entityLiving.func_70638_az();
        if (oldAttackTarget != null && entityLiving.func_70635_at().func_75522_a((Entity)oldAttackTarget) && entityLiving.func_70032_d((Entity)oldAttackTarget) < entityLiving.func_70032_d((Entity)this.attackTarget)) {
            return false;
        }
        entityLiving.func_70624_b(this.attackTarget);
        return true;
    }
}

