/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai.target;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.objects.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.objects.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.objects.entity.boss.EntityCQRNetherDragon;

public class EntityAINetherDragonNearestAttackTarget
extends AbstractCQREntityAI<EntityCQRNetherDragon> {
    protected final Predicate<EntityLivingBase> predicate = input -> {
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply(input)) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply(input)) {
            return false;
        }
        return this.isSuitableTarget((EntityLivingBase)input);
    };

    public EntityAINetherDragonNearestAttackTarget(EntityCQRNetherDragon entity) {
        super(entity);
    }

    public boolean func_75250_a() {
        if (((EntityCQRNetherDragon)this.entity).field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            ((EntityCQRNetherDragon)this.entity).func_70624_b(null);
            return false;
        }
        if (this.isStillSuitableTarget(((EntityCQRNetherDragon)this.entity).func_70638_az())) {
            return false;
        }
        ((EntityCQRNetherDragon)this.entity).func_70624_b(null);
        return true;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        AxisAlignedBB aabb = ((EntityCQRNetherDragon)this.entity).func_174813_aQ().func_186662_g(32.0);
        List possibleTargets = ((EntityCQRNetherDragon)this.entity).field_70170_p.func_175647_a(EntityLivingBase.class, aabb, this.predicate);
        if (!possibleTargets.isEmpty()) {
            ((EntityCQRNetherDragon)this.entity).func_70624_b((EntityLivingBase)TargetUtil.getNearestEntity((EntityLiving)this.entity, possibleTargets));
        }
    }

    private boolean isSuitableTarget(EntityLivingBase possibleTarget) {
        if (possibleTarget == this.entity) {
            return false;
        }
        CQRFaction faction = ((EntityCQRNetherDragon)this.entity).getFaction();
        if (((EntityCQRNetherDragon)this.entity).func_184614_ca().func_77973_b() == CQRItems.STAFF_HEALING) {
            if (faction == null || !faction.isAlly((Entity)possibleTarget) && ((EntityCQRNetherDragon)this.entity).getLeader() != possibleTarget) {
                return false;
            }
            if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
                return false;
            }
            return this.isInHomeZone(possibleTarget);
        }
        if (faction == null || !((EntityCQRNetherDragon)this.entity).getFaction().isEnemy((Entity)possibleTarget) || ((EntityCQRNetherDragon)this.entity).getLeader() == possibleTarget) {
            return false;
        }
        if (((EntityCQRNetherDragon)this.entity).isInAttackReach(possibleTarget)) {
            return true;
        }
        return !possibleTarget.func_70093_af() && (double)((EntityCQRNetherDragon)this.entity).func_70032_d((Entity)possibleTarget) < 32.0;
    }

    private boolean isStillSuitableTarget(EntityLivingBase possibleTarget) {
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)possibleTarget)) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply((Object)possibleTarget)) {
            return false;
        }
        if (possibleTarget == this.entity) {
            return false;
        }
        CQRFaction faction = ((EntityCQRNetherDragon)this.entity).getFaction();
        if (((EntityCQRNetherDragon)this.entity).func_184614_ca().func_77973_b() == CQRItems.STAFF_HEALING) {
            if (faction == null || !faction.isAlly((Entity)possibleTarget) && ((EntityCQRNetherDragon)this.entity).getLeader() != possibleTarget) {
                return false;
            }
            if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
                return false;
            }
            return this.isInHomeZone(possibleTarget);
        }
        if (faction == null || !((EntityCQRNetherDragon)this.entity).getFaction().isEnemy((Entity)possibleTarget) || ((EntityCQRNetherDragon)this.entity).getLeader() == possibleTarget) {
            return false;
        }
        return this.isInHomeZone(possibleTarget);
    }

    private boolean isInHomeZone(EntityLivingBase possibleTarget) {
        double distance = possibleTarget.func_180425_c().func_185332_f(((EntityCQRNetherDragon)this.entity).getCirclingCenter().func_177958_n(), ((EntityCQRNetherDragon)this.entity).getCirclingCenter().func_177956_o(), ((EntityCQRNetherDragon)this.entity).getCirclingCenter().func_177952_p());
        return distance <= (double)(24 + 8 * this.world.func_175659_aa().ordinal());
    }
}

