/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.ai.target;

import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.objects.entity.bases.EntityCQRMountBase;

public class TargetUtil {
    public static final Predicate<EntityLivingBase> PREDICATE_ATTACK_TARGET = input -> {
        if (input == null) {
            return false;
        }
        return EntitySelectors.field_188444_d.apply(input);
    };
    public static final Predicate<EntityLiving> PREDICATE_MOUNTS = input -> {
        if (input == null) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply(input)) {
            return false;
        }
        if (input.func_184207_aI()) {
            return false;
        }
        if (input instanceof AbstractHorse && ((AbstractHorse)input).func_110248_bS()) {
            return false;
        }
        return input.func_82171_bF() || input instanceof EntityCQRMountBase || input instanceof AbstractHorse || input instanceof EntityPig;
    };
    public static final Predicate<EntityTameable> PREDICATE_PETS = input -> {
        if (input == null) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply(input)) {
            return false;
        }
        if (input.func_184753_b() != null) {
            return false;
        }
        return input instanceof EntityOcelot || input instanceof EntityWolf;
    };
    public static final Predicate<Entity> PREDICATE_LIVING = input -> {
        if (input == null) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply(input)) {
            return false;
        }
        return input instanceof EntityLivingBase;
    };

    public static final Predicate<Entity> createPredicateAlly(CQRFaction faction) {
        return input -> faction.isAlly((Entity)input);
    }

    public static final Predicate<Entity> createPredicateNonAlly(CQRFaction faction) {
        return input -> !faction.isAlly((Entity)input);
    }

    public static final <T extends Entity> T getNearestEntity(EntityLiving entity, List<T> list) {
        Entity nearestEntity = null;
        double min = Double.MAX_VALUE;
        for (Entity otherEntity : list) {
            double distance = entity.func_70068_e(otherEntity);
            if (!(distance < min)) continue;
            nearestEntity = otherEntity;
            min = distance;
        }
        return (T)nearestEntity;
    }

    @Nullable
    public static final Vec3d getPositionNearTarget(World world, EntityLiving entity, BlockPos target, double minDist, double dxz, double dy) {
        return TargetUtil.getPositionNearTarget(world, entity, new Vec3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5), minDist, dxz, dy);
    }

    @Nullable
    public static final Vec3d getPositionNearTarget(World world, EntityLiving entity, Entity target, double minDist, double dxz, double dy) {
        return TargetUtil.getPositionNearTarget(world, entity, target.func_174791_d(), minDist, dxz, dy);
    }

    @Nullable
    public static final Vec3d getPositionNearTarget(World world, EntityLiving entity, Vec3d target, double minDist, double dxz, double dy) {
        return TargetUtil.getPositionNearTarget(world, entity, target, target, minDist, dxz, dy);
    }

    @Nullable
    public static final Vec3d getPositionNearTarget(World world, EntityLiving entity, Vec3d target, Vec3d vec, double minDist, double dxz, double dy) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int tries = 200;
        for (int i = 0; i < tries; ++i) {
            double x = target.field_72450_a + world.field_73012_v.nextDouble() * dxz * 2.0 - dxz;
            double y = target.field_72448_b + 1.0 + world.field_73012_v.nextDouble() * dy * 2.0 - dy;
            double z = target.field_72449_c + world.field_73012_v.nextDouble() * dxz * 2.0 - dxz;
            if (i < tries * 3 / 5 && (x - vec.field_72450_a) * (x - vec.field_72450_a) + (z - vec.field_72449_c) * (z - vec.field_72449_c) < minDist * minDist) continue;
            boolean flag = false;
            mutablePos.func_181079_c(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
            for (int k = 0; k < 4; ++k) {
                IBlockState state = world.func_180495_p((BlockPos)mutablePos);
                if (state.func_185904_a().func_76230_c()) {
                    AxisAlignedBB aabb = state.func_185900_c((IBlockAccess)world, (BlockPos)mutablePos);
                    if (y >= (double)mutablePos.func_177956_o() + aabb.field_72337_e) {
                        y = (double)mutablePos.func_177956_o() + aabb.field_72337_e;
                        flag = true;
                        break;
                    }
                }
                mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
            }
            if (!flag || world.func_184143_b(entity.func_174813_aQ().func_72317_d(x - entity.field_70165_t, y - entity.field_70163_u, z - entity.field_70161_v))) continue;
            if (i < tries * 3 / 5) {
                double oldX = entity.field_70165_t;
                double oldY = entity.field_70163_u;
                double oldZ = entity.field_70161_v;
                entity.func_70107_b(x, y, z);
                entity.field_70122_E = true;
                Path path = entity.func_70661_as().func_75488_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                int l = path != null ? path.func_75874_d() : 100;
                entity.func_70107_b(oldX, oldY, oldZ);
                if ((double)l > dxz * 2.0) continue;
            }
            return new Vec3d(x, y, z);
        }
        return null;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double d2;
            double d1 = this.entity.func_70068_e(entity1);
            if (d1 < (d2 = this.entity.func_70068_e(entity2))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

