/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.bases;

import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.CQRConfig;

public abstract class AbstractEntityCQRBoss
extends AbstractEntityCQR {
    public int deathTicks = 0;
    public static final int MAX_DEATH_TICKS = 200;

    public AbstractEntityCQRBoss(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 50;
        this.enableBossBar();
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount, boolean sentFromPart) {
        int nearbyPlayerCount = 0;
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (!(this.func_70068_e((Entity)player) < 10000.0)) continue;
            ++nearbyPlayerCount;
        }
        for (int i = 0; i < nearbyPlayerCount - 1; ++i) {
            amount = (float)((double)amount * (1.0 - CQRConfig.mobs.bossDamageReductionPerPlayer));
        }
        return super.attackEntityFrom(source, amount, sentFromPart);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfoServer.func_186739_a(this.func_145748_c_());
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (CQRConfig.bosses.enableHealthRegen && !this.hasAttackTarget() && this.lastTickWithAttackTarget + 100 < this.field_70173_aa && this.field_70173_aa % 5 == 0) {
            this.func_70691_i(this.func_110138_aP() * 0.005f);
        }
        super.func_70636_d();
    }

    protected void func_70609_aI() {
        if (this.usesEnderDragonDeath()) {
            if (this.isSitting()) {
                this.setSitting(false);
            }
            ++this.deathTicks;
            if (this.deathTicks >= 180 && this.deathTicks <= 200) {
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                this.field_70170_p.func_175688_a(this.getDeathAnimParticles(), this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_189654_d(true);
            this.func_70091_d(MoverType.SELF, 0.0, 0.05, 0.0);
            if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFinalDeathSound(), SoundCategory.MASTER, 1.0f, 1.0f, false);
                this.func_70106_y();
                if (this.doesExplodeOnDeath()) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, true);
                }
                this.onFinalDeath();
            }
        } else {
            super.func_70609_aI();
        }
    }

    protected void onFinalDeath() {
    }

    protected SoundEvent getFinalDeathSound() {
        return this.func_184615_bR();
    }

    protected boolean doesExplodeOnDeath() {
        return false;
    }

    protected boolean usesEnderDragonDeath() {
        return false;
    }

    protected EnumParticleTypes getDeathAnimParticles() {
        return EnumParticleTypes.EXPLOSION_HUGE;
    }

    @Override
    public boolean canTameEntity() {
        return false;
    }

    @Override
    public boolean canMountEntity() {
        return false;
    }

    @Override
    protected boolean damageCapEnabled() {
        return CQRConfig.bossDamageCaps.enableDamageCapForBosses;
    }

    @Override
    protected float maxDamageInPercentOfMaxHP() {
        return CQRConfig.bossDamageCaps.maxDamageInPercentOfMaxHP;
    }

    @Override
    protected float maxUncappedDamage() {
        return CQRConfig.bossDamageCaps.maxUncappedDamage;
    }
}

