/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.boss;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.factions.FactionRegistry;
import team.cqr.cqrepoured.util.math.BoundingBox;

public abstract class AbstractEntityLaser
extends Entity
implements IEntityAdditionalSpawnData {
    protected EntityLivingBase caster;
    public float length;
    public float rotationYawCQR;
    public float rotationPitchCQR;
    public float prevRotationYawCQR;
    public float prevRotationPitchCQR;
    private final Object2IntMap<EntityLivingBase> hitInfoMap = new Object2IntOpenHashMap();
    private final Object2IntMap<BlockPos> blockBreakMap = new Object2IntOpenHashMap();

    public AbstractEntityLaser(World worldIn) {
        this(worldIn, null, 4.0f);
    }

    public AbstractEntityLaser(World worldIn, EntityLivingBase caster, float length) {
        super(worldIn);
        this.caster = caster;
        this.length = length;
        this.func_70105_a(0.1f, 0.1f);
        this.field_70158_ak = true;
        this.field_70145_X = true;
    }

    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public boolean func_184198_c(NBTTagCompound compound) {
        return false;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        return compound;
    }

    protected double laserEffectRadius() {
        return 0.25;
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && !this.caster.func_70089_S()) {
            this.func_70106_y();
        }
        super.func_70030_z();
        this.updatePositionAndRotation();
        if (!this.field_70170_p.field_72995_K) {
            Vec3d end;
            Vec3d start = this.func_174791_d();
            RayTraceResult result = this.field_70170_p.func_147447_a(start, end = start.func_178787_e(Vec3d.func_189986_a((float)this.rotationPitchCQR, (float)this.rotationYawCQR).func_186678_a((double)this.length)), false, true, false);
            double d = result != null ? (double)((float)result.field_72307_f.func_178788_d(this.func_174791_d()).func_72433_c()) : (double)this.length;
            Vec3d vec1 = new Vec3d(-this.laserEffectRadius(), -this.laserEffectRadius(), 0.0);
            Vec3d vec2 = new Vec3d(this.laserEffectRadius(), this.laserEffectRadius(), d);
            BoundingBox bb = new BoundingBox(vec1, vec2, Math.toRadians(this.rotationYawCQR), Math.toRadians(this.rotationPitchCQR), start);
            CQRFaction faction = FactionRegistry.instance().getFactionOf((Entity)this.caster);
            for (EntityLivingBase entity : BoundingBox.getEntitiesInsideBB(this.field_70170_p, this.caster, EntityLivingBase.class, bb)) {
                if (faction != null && faction.isAlly((Entity)entity) || this.field_70173_aa - this.hitInfoMap.getInt((Object)entity) < 10) continue;
                this.hitInfoMap.put((Object)entity, this.field_70173_aa);
                entity.func_70097_a(new DamageSource("ray").func_76348_h(), 3.0f);
            }
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.field_70170_p.func_175715_c(this.func_145782_y(), BlockPos.field_177992_a, -1);
    }

    public abstract void updatePositionAndRotation();

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.caster.func_145782_y());
        buffer.writeFloat(this.length);
        buffer.writeFloat(this.rotationYawCQR);
        buffer.writeFloat(this.rotationPitchCQR);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.caster = (EntityLivingBase)this.field_70170_p.func_73045_a(additionalData.readInt());
        this.length = additionalData.readFloat();
        this.rotationYawCQR = additionalData.readFloat();
        this.rotationPitchCQR = additionalData.readFloat();
        this.prevRotationYawCQR = this.rotationYawCQR;
        this.prevRotationPitchCQR = this.rotationPitchCQR;
    }

    public float getColorR() {
        return 0.1f;
    }

    public float getColorG() {
        return 0.7f;
    }

    public float getColorB() {
        return 0.9f;
    }
}

