/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.boss;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.factions.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.objects.entity.ai.boss.boarmage.BossAIBoarmageExplodeAreaAttack;
import team.cqr.cqrepoured.objects.entity.ai.boss.boarmage.BossAIBoarmageTeleportSpell;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAIExplodeAreaStartSpell;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAIExplosionRay;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAISummonFireWall;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAISummonMeteors;
import team.cqr.cqrepoured.objects.entity.bases.ISummoner;
import team.cqr.cqrepoured.objects.entity.boss.AbstractEntityCQRMageBase;
import team.cqr.cqrepoured.util.CQRConfig;

public class EntityCQRBoarmage
extends AbstractEntityCQRMageBase
implements ISummoner {
    protected List<Entity> summonedMinions = new ArrayList<Entity>();
    protected boolean startedExplodeAreaAttack = false;

    public EntityCQRBoarmage(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void startExplodeAreaAttack() {
        this.startedExplodeAreaAttack = true;
    }

    public boolean isExecutingExplodeAreaAttack() {
        return this.startedExplodeAreaAttack;
    }

    public void stopExplodeAreaAttack() {
        this.startedExplodeAreaAttack = false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        ArrayList<Entity> tmp = new ArrayList<Entity>();
        for (Entity ent : this.summonedMinions) {
            if (ent != null && !ent.field_70128_L) continue;
            tmp.add(ent);
        }
        for (Entity e : tmp) {
            this.summonedMinions.remove(e);
        }
        if ((this.func_180799_ab() || this.func_70027_ad()) && this.field_70173_aa % 5 == 0) {
            this.func_70691_i(1.0f);
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        for (Entity e : this.summonedMinions) {
            if (e == null || e.field_70128_L) continue;
            if (e instanceof EntityLivingBase) {
                ((EntityLivingBase)e).func_70645_a(cause);
            }
            if (e == null) continue;
            e.func_70106_y();
        }
        this.summonedMinions.clear();
        super.func_70645_a(cause);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new BossAIBoarmageTeleportSpell(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new BossAIBoarmageExplodeAreaAttack(this));
        this.spellHandler.addSpell(0, new EntityAISummonMeteors(this, 75, 20));
        this.spellHandler.addSpell(3, new EntityAIExplosionRay(this, 100, 10));
        this.spellHandler.addSpell(2, new EntityAISummonFireWall(this, 50, 25));
        this.spellHandler.addSpell(1, new EntityAIExplodeAreaStartSpell(this, 200, 20, 5));
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_BOARMAGE;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.Boarmage;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.UNDEAD;
    }

    @Override
    public CQRFaction getSummonerFaction() {
        return this.getFaction();
    }

    @Override
    public List<Entity> getSummonedEntities() {
        return this.summonedMinions;
    }

    @Override
    public EntityLivingBase getSummoner() {
        return this;
    }

    @Override
    public void addSummonedEntityToList(Entity summoned) {
        this.summonedMinions.add(summoned);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public boolean canPutOutFire() {
        return false;
    }
}

