/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.boss;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.factions.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.objects.entity.ai.EntityAIAttack;
import team.cqr.cqrepoured.objects.entity.ai.EntityAIFollowAttackTarget;
import team.cqr.cqrepoured.objects.entity.ai.EntityAIFollowPath;
import team.cqr.cqrepoured.objects.entity.ai.EntityAIMoveToHome;
import team.cqr.cqrepoured.objects.entity.ai.EntityAIMoveToLeader;
import team.cqr.cqrepoured.objects.entity.ai.boss.giantspider.BossAISpiderHook;
import team.cqr.cqrepoured.objects.entity.ai.boss.giantspider.BossAISpiderLeapAttack;
import team.cqr.cqrepoured.objects.entity.ai.boss.giantspider.BossAISpiderSummonMinions;
import team.cqr.cqrepoured.objects.entity.ai.boss.giantspider.BossAISpiderWebshot;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAIShootPoisonProjectiles;
import team.cqr.cqrepoured.objects.entity.ai.target.EntityAICQRNearestAttackTarget;
import team.cqr.cqrepoured.objects.entity.ai.target.EntityAIHurtByTarget;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.objects.entity.bases.ISummoner;
import team.cqr.cqrepoured.util.CQRConfig;

public class EntityCQRGiantSpider
extends AbstractEntityCQRBoss
implements ISummoner {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityCQRGiantSpider.class, (DataSerializer)DataSerializers.field_187191_a);
    protected List<Entity> activeEggs = new ArrayList<Entity>();

    public EntityCQRGiantSpider(World worldIn) {
        super(worldIn);
    }

    @Override
    public float getDefaultHeight() {
        return 1.0f;
    }

    @Override
    public float getDefaultWidth() {
        return 2.3f;
    }

    @Override
    public boolean canOpenDoors() {
        return false;
    }

    @Override
    protected void func_184651_r() {
        this.spellHandler = this.createSpellHandler();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new BossAISpiderSummonMinions(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new BossAISpiderWebshot(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new BossAISpiderHook(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new BossAISpiderLeapAttack((EntityLiving)this, 1.2f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIAttack(this));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new EntityAIFollowAttackTarget(this));
        this.field_70714_bg.func_75776_a(30, (EntityAIBase)new EntityAIMoveToLeader(this));
        this.field_70714_bg.func_75776_a(31, (EntityAIBase)new EntityAIFollowPath(this));
        this.field_70714_bg.func_75776_a(32, (EntityAIBase)new EntityAIMoveToHome(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)this.spellHandler);
        this.spellHandler.addSpell(0, new EntityAIShootPoisonProjectiles(this, 80, 20){

            @Override
            protected SoundEvent getStartChargingSound() {
                return SoundEvents.field_187821_fM;
            }

            @Override
            protected SoundEvent getStartCastingSound() {
                return SoundEvents.field_187817_fK;
            }
        });
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAICQRNearestAttackTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)CQRItems.SPIDERHOOK, 1));
    }

    public void func_180430_e(float p_180430_1_, float p_180430_2_) {
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        ArrayList<Entity> tmp = new ArrayList<Entity>();
        for (Entity ent : this.activeEggs) {
            if (ent != null && !ent.field_70128_L) continue;
            tmp.add(ent);
        }
        for (Entity e : tmp) {
            this.activeEggs.remove(e);
        }
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u || potioneffectIn.func_188419_a() == MobEffects.field_76437_t || potioneffectIn.func_188419_a() == MobEffects.field_82731_v) {
            return;
        }
        super.func_70690_d(potioneffectIn);
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111266_c).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24000000953674316);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean result = super.func_70652_k(entityIn);
        if (result) {
            int effectlvl = 1;
            if (this.func_70681_au().nextDouble() > 0.7) {
                effectlvl = 2;
                this.func_70691_i(Math.min(CQRConfig.bosses.giantSpiderMaxHealByBite, ((EntityLivingBase)entityIn).func_110143_aJ() * 0.25f));
            }
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 20 + entityIn.field_70170_p.func_175659_aa().ordinal() * 40, effectlvl));
        }
        return result;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_SPIDER;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.GiantSpider;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.BEASTS;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public void func_70110_aj() {
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((EntityLivingBase)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    @Override
    public CQRFaction getSummonerFaction() {
        return this.getFaction();
    }

    @Override
    public List<Entity> getSummonedEntities() {
        return this.activeEggs;
    }

    @Override
    public EntityLivingBase getSummoner() {
        return this;
    }

    @Override
    public void addSummonedEntityToList(Entity summoned) {
        this.activeEggs.add(summoned);
    }

    public boolean func_70104_M() {
        return false;
    }
}

