/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.boss;

import java.util.ArrayList;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationAI;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemShield;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import team.cqr.cqrepoured.factions.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.objects.entity.ai.EntityAIIdleSit;
import team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise.BossAITortoiseHealing;
import team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise.BossAITortoiseMoveToHome;
import team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise.BossAITortoiseMoveToLeader;
import team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise.BossAITortoiseSpinAttack;
import team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise.BossAITortoiseStun;
import team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise.BossAITortoiseSwimming;
import team.cqr.cqrepoured.objects.entity.ai.boss.gianttortoise.BossAITortoiseSwitchStates;
import team.cqr.cqrepoured.objects.entity.ai.target.EntityAICQRNearestAttackTarget;
import team.cqr.cqrepoured.objects.entity.ai.target.EntityAIHurtByTarget;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.objects.entity.boss.subparts.EntityCQRGiantTortoisePart;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityCQRGiantTortoise
extends AbstractEntityCQRBoss
implements IEntityMultiPart,
IRangedAttackMob,
IAnimatedEntity {
    private static final DataParameter<Boolean> IN_SHELL = EntityDataManager.func_187226_a(EntityCQRGiantTortoise.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IN_SHELL_BYPASS = EntityDataManager.func_187226_a(EntityCQRGiantTortoise.class, (DataSerializer)DataSerializers.field_187198_h);
    protected EntityCQRGiantTortoisePart[] parts = new EntityCQRGiantTortoisePart[5];
    static int EAnimStateGlobalID = 0;
    public static final int TARGET_MOVE_OUT = 1;
    public static final int TARGET_MOVE_IN = -1;
    private int targetedState = 0;
    private boolean partSoundFlag = false;
    private boolean stunned = false;
    private boolean canBeStunned = true;
    private boolean wantsToSpin = false;
    private boolean readyToSpin = true;
    private boolean spinning = false;
    private int spinsBlocked = 0;
    private int timesHealed = 1;
    private boolean isHealing = false;
    private Vec3d lastTickPos = null;
    private int stuckTicks = 0;
    private static final int MAX_STUCK_TICKS = 60;
    private Animation animation = NO_ANIMATION;
    private int animationTick;
    public AnimationAI<EntityCQRGiantTortoise> currentAnim;
    private static ArrayList<ResourceLocation> hardBlocks = new ArrayList();
    public static final Animation ANIMATION_MOVE_LEGS_IN = Animation.create((int)30).setLooping(false);
    public static final Animation ANIMATION_MOVE_LEGS_OUT = Animation.create((int)50).setLooping(false);
    public static final Animation ANIMATION_SPIN = Animation.create((int)250).setLooping(false);
    public static final Animation ANIMATION_IDLE = Animation.create((int)100);
    public static final Animation ANIMATION_STUNNED = Animation.create((int)140).setLooping(false);
    public static final Animation ANIMATION_DEATH = Animation.create((int)300);
    private static final Animation[] ANIMATIONS = new Animation[]{ANIMATION_MOVE_LEGS_IN, ANIMATION_MOVE_LEGS_OUT, ANIMATION_SPIN, ANIMATION_IDLE, ANIMATION_STUNNED, ANIMATION_DEATH};

    public EntityCQRGiantTortoise(World worldIn) {
        super(worldIn);
        this.field_70138_W = 2.1f;
        for (int i = 0; i < this.parts.length - 1; ++i) {
            this.parts[i] = new EntityCQRGiantTortoisePart(this, "tortoise_leg" + i, 0.7f, 1.1f, false);
        }
        this.parts[this.parts.length - 1] = new EntityCQRGiantTortoisePart(this, "tortoise_head", 0.7f, 0.7f, true);
        this.field_70145_X = false;
        this.func_189654_d(false);
        this.field_70178_ae = true;
        this.field_70728_aV = 100;
        this.field_70158_ak = true;
    }

    @Override
    public void enableBossBar() {
        super.enableBossBar();
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186745_a(BossInfo.Color.GREEN);
        }
    }

    public static void realoadHardBlocks() {
        hardBlocks.clear();
        for (String s : CQRConfig.bosses.giantTortoiseHardBlocks) {
            ResourceLocation rs = new ResourceLocation(s);
            hardBlocks.add(rs);
        }
    }

    public static boolean isHardBlock(ResourceLocation rl) {
        return !hardBlocks.isEmpty() && hardBlocks.contains(rl);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new BossAITortoiseSwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new BossAITortoiseSwitchStates(this, ANIMATION_MOVE_LEGS_IN, ANIMATION_MOVE_LEGS_OUT));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new BossAITortoiseStun(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new BossAITortoiseHealing(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new BossAITortoiseSpinAttack(this));
        this.field_70714_bg.func_75776_a(19, (EntityAIBase)new BossAITortoiseMoveToLeader(this));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new BossAITortoiseMoveToHome(this));
        this.field_70714_bg.func_75776_a(21, (EntityAIBase)new EntityAIIdleSit(this){

            @Override
            public boolean func_75250_a() {
                if (super.func_75250_a() && ((EntityCQRGiantTortoise)this.entity).isInShell() && !EntityCQRGiantTortoise.this.isHealing && !EntityCQRGiantTortoise.this.isStunned() && !EntityCQRGiantTortoise.this.isSpinning()) {
                    return true;
                }
                if (super.func_75250_a() && !EntityCQRGiantTortoise.this.isHealing && !EntityCQRGiantTortoise.this.isStunned() && !EntityCQRGiantTortoise.this.isSpinning()) {
                    ((EntityCQRGiantTortoise)this.entity).targetNewState(-1);
                }
                return false;
            }
        });
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAICQRNearestAttackTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this));
    }

    @Override
    public float getDefaultWidth() {
        return 2.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 1.7f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IN_SHELL, (Object)true);
        this.field_70180_af.func_187214_a(IN_SHELL_BYPASS, (Object)false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.99);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.125);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart dragonPart, DamageSource source, float damage) {
        return this.attackEntityFrom(source, damage, true);
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount, boolean sentFromPart) {
        if (source.func_76357_e() || source == DamageSource.field_76380_i) {
            return super.attackEntityFrom(source, amount, sentFromPart);
        }
        this.partSoundFlag = sentFromPart;
        if (source.func_76346_g() instanceof EntityLivingBase && !(source.func_76346_g() instanceof EntityPlayer) && this.func_70681_au().nextBoolean() && !sentFromPart) {
            sentFromPart = true;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (!sentFromPart) {
            amount = 0.0f;
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184601_bQ(source), SoundCategory.HOSTILE, 1.0f, 1.0f, true);
        }
        if (sentFromPart && (!this.isInShell() || source == DamageSource.field_76368_d)) {
            if (this.stunned) {
                amount *= 2.0f;
            }
            return super.attackEntityFrom(source, amount, sentFromPart);
        }
        return true;
    }

    public boolean isInShell() {
        return (Boolean)this.field_70180_af.func_187225_a(IN_SHELL);
    }

    public boolean isStunned() {
        return this.stunned;
    }

    public boolean canBeStunned() {
        return this.canBeStunned;
    }

    public void setCanBeStunned(boolean value) {
        this.canBeStunned = value;
    }

    public void setStunned(boolean value) {
        this.stunned = value;
        this.readyToSpin = !this.stunned;
    }

    public boolean bypassInShell() {
        return (Boolean)this.field_70180_af.func_187225_a(IN_SHELL_BYPASS);
    }

    public void setBypassInShell(boolean val) {
        this.field_70180_af.func_187227_b(IN_SHELL_BYPASS, (Object)val);
    }

    public int func_70086_ai() {
        return 100;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_TURTLE;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.GiantTortoise;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.BEASTS;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70050_g(999);
        for (EntityCQRGiantTortoisePart part : this.parts) {
            this.field_70170_p.func_72866_a((Entity)part, true);
        }
        this.alignParts();
        this.breakBlocksInWay();
    }

    private void breakBlocksInWay() {
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177963_a((double)(this.field_70130_N + 1.0f), (double)this.field_70131_O, (double)(this.field_70130_N + 1.0f)), (BlockPos)this.func_180425_c().func_177963_a((double)(-this.field_70130_N - 1.0f), -1.0, (double)(-this.field_70130_N - 1.0f)))) {
            Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
            if (block.func_149703_v() && !block.func_176205_b((IBlockAccess)this.field_70170_p, pos) || block == Blocks.field_150358_i || block == Blocks.field_150355_j || block == Blocks.field_150356_k || block == Blocks.field_150353_l) continue;
            this.field_70170_p.func_175698_g(pos);
        }
    }

    private void alignParts() {
        Vec3d v = new Vec3d(0.0, 0.0, (double)(this.field_70130_N / 2.0f) + (double)this.field_70130_N * 0.1);
        v = VectorUtil.rotateVectorAroundY(v, (double)this.field_70759_as);
        float vy = this.isInShell() || this.getAnimation() == ANIMATION_STUNNED ? 0.1f : 0.5f;
        this.parts[this.parts.length - 1].func_70107_b(this.field_70165_t + v.field_72450_a, this.field_70163_u + (double)vy, this.field_70161_v + v.field_72449_c);
        this.parts[this.parts.length - 1].func_70101_b(this.field_70759_as, this.field_70125_A);
        v = VectorUtil.rotateVectorAroundY(v, 45.0);
        for (int i = 0; i < this.parts.length - 1; ++i) {
            if (i > 0) {
                v = VectorUtil.rotateVectorAroundY(v, 90.0);
            }
            double x = this.field_70165_t + v.field_72450_a;
            double y = this.field_70163_u;
            double z = this.field_70161_v + v.field_72449_c;
            this.parts[i].func_70107_b(x, y, z);
            this.parts[i].func_70101_b(this.field_70177_z + (float)i * 45.0f, this.field_70125_A);
        }
    }

    public Entity[] func_70021_al() {
        return this.parts;
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (EntityCQRGiantTortoisePart part : this.parts) {
            this.field_70170_p.func_72973_f((Entity)part);
        }
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        if (this.isInShell()) {
            return SoundEvents.field_187603_D;
        }
        if (this.partSoundFlag) {
            this.partSoundFlag = false;
            return SoundEvents.field_187880_fp;
        }
        return SoundEvents.field_187603_D;
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.isSpinning()) {
            boolean blocked = false;
            if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184607_cu().func_77973_b() instanceof ItemShield) {
                if (this.func_70681_au().nextBoolean()) {
                    ++this.spinsBlocked;
                }
                ++this.spinsBlocked;
                blocked = true;
            }
            if (!blocked) {
                entityIn.func_70097_a(DamageSource.func_92087_a((Entity)this), 4.0f * ((float)Math.max(1, this.field_70170_p.func_175659_aa().func_151525_a()) * 1.5f));
            }
            Vec3d v = entityIn.func_174791_d().func_178788_d(this.func_174791_d());
            v = v.func_72432_b();
            v = blocked ? v.func_186678_a(0.8) : v.func_186678_a(1.5);
            entityIn.field_70159_w = v.field_72450_a;
            entityIn.field_70181_x = v.field_72448_b + 0.75;
            entityIn.field_70179_y = v.field_72449_c;
            entityIn.field_70133_I = true;
            if (blocked) {
                v = v.func_186678_a(1.7);
                this.field_70159_w = -v.field_72450_a;
                this.field_70181_x = v.field_72448_b + 0.25;
                this.field_70179_y = -v.field_72449_c;
                this.field_70133_I = true;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187603_D, SoundCategory.HOSTILE, 1.0f, 1.0f, true);
            }
        } else {
            super.func_82167_n(entityIn);
        }
    }

    public void func_70015_d(int seconds) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void setInShell(boolean val) {
        this.field_70180_af.func_187227_b(IN_SHELL, (Object)val);
        this.readyToSpin = val;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("timesHealed", this.timesHealed);
        compound.func_74757_a("inShell", this.isInShell());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTimesHealed(compound.func_74762_e("timesHealed"));
        if (this.getTimesHealed() < 1) {
            this.setTimesHealed(1);
        }
        this.setInShell(compound.func_74767_n("inShell"));
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (animation == NO_ANIMATION) {
            this.onAnimationFinish(this.animation);
            this.animation = animation;
            this.setAnimationTick(0);
        } else if (this.animation != animation) {
            this.animation = animation;
        }
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public Animation getDeathAnimation() {
        return ANIMATION_DEATH;
    }

    protected void onDeathAIUpdate() {
        if (this.getAnimation() != ANIMATION_DEATH) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ANIMATION_DEATH);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.hasAttackTarget()) {
            if (this.lastTickPos == null) {
                this.lastTickPos = this.func_174791_d();
            }
            if (this.getHomePositionCQR() == null) {
                this.setHomePositionCQR(this.func_180425_c());
            }
            Vec3d curPos = this.func_174791_d();
            if (this.getHomePositionCQR().func_177954_c(curPos.field_72450_a, curPos.field_72448_b, curPos.field_72449_c) > 16.0) {
                if (curPos.func_72438_d(this.lastTickPos) <= 0.05) {
                    ++this.stuckTicks;
                } else {
                    this.lastTickPos = curPos;
                }
                if (this.stuckTicks >= 60) {
                    this.func_70624_b(null);
                    this.stuckTicks = 0;
                }
            }
        } else {
            this.stuckTicks = 0;
        }
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.field_70170_p.field_72995_K && this.animationTick >= this.animation.getDuration()) {
                if (this.getAnimation() == ANIMATION_MOVE_LEGS_IN) {
                    this.setInShell(true);
                }
                this.setAnimation(NO_ANIMATION);
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, NO_ANIMATION);
            }
        }
    }

    public void targetNewState(int newStateID) {
        if (newStateID != this.targetedState) {
            this.targetedState = newStateID;
            if (newStateID != 0) {
                if (newStateID < 0) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ANIMATION_MOVE_LEGS_IN);
                } else {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ANIMATION_MOVE_LEGS_OUT);
                }
            } else {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, NO_ANIMATION);
            }
        }
    }

    public int getTargetedState() {
        return this.targetedState;
    }

    public boolean wantsToChangeState() {
        return this.targetedState != 0;
    }

    public void changedState() {
        this.targetedState = 0;
    }

    public int getTimesHealed() {
        return this.timesHealed;
    }

    public void setTimesHealed(int val) {
        this.timesHealed = val;
    }

    public void setHealing(boolean val) {
        this.isHealing = val;
        this.readyToSpin = !this.isHealing;
    }

    public boolean isHealing() {
        return this.isHealing;
    }

    public void setSpinning(boolean value) {
        this.spinning = value;
        this.readyToSpin = !this.spinning;
    }

    public boolean isSpinning() {
        return this.spinning;
    }

    @Override
    public boolean canOpenDoors() {
        return false;
    }

    public void setWantsToSpin(boolean value) {
        this.wantsToSpin = value;
    }

    public boolean wantsToSpin() {
        return this.wantsToSpin;
    }

    public void setReadyToSpin(boolean value) {
        this.readyToSpin = value;
    }

    public boolean isReadyToSpin() {
        return this.readyToSpin;
    }

    public Vec3d func_174824_e(float partialTicks) {
        Vec3d headPos = this.parts[this.parts.length - 1].func_174791_d();
        return headPos.func_178787_e(headPos.func_178786_a(this.field_70165_t, 0.0, this.field_70161_v)).func_72432_b().func_186678_a(0.25);
    }

    public int getSpinsBlocked() {
        return this.spinsBlocked;
    }

    public void resetSpinsBlocked() {
        this.spinsBlocked = 0;
    }

    @Override
    public boolean canPutOutFire() {
        return false;
    }

    @Override
    public boolean canIgniteTorch() {
        return false;
    }
}

