/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.boss;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.factions.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAIArmorSpell;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAIFangAttack;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAIShootPoisonProjectiles;
import team.cqr.cqrepoured.objects.entity.ai.spells.EntityAISummonMinionSpell;
import team.cqr.cqrepoured.objects.entity.bases.ISummoner;
import team.cqr.cqrepoured.objects.entity.boss.AbstractEntityCQRMageBase;
import team.cqr.cqrepoured.objects.entity.misc.EntitySummoningCircle;
import team.cqr.cqrepoured.util.CQRConfig;

public class EntityCQRLich
extends AbstractEntityCQRMageBase
implements ISummoner {
    protected List<Entity> summonedMinions = new ArrayList<Entity>();
    protected BlockPos currentPhylacteryPosition = null;

    public EntityCQRLich(World worldIn) {
        super(worldIn);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        ArrayList<Entity> tmp = new ArrayList<Entity>();
        for (Entity ent : this.summonedMinions) {
            if (ent != null && !ent.field_70128_L) continue;
            tmp.add(ent);
        }
        for (Entity e : tmp) {
            this.summonedMinions.remove(e);
        }
        if (this.currentPhylacteryPosition != null) {
            if (this.field_70170_p.func_180495_p(this.currentPhylacteryPosition).func_177230_c() == CQRBlocks.PHYLACTERY) {
                this.setMagicArmorActive(true);
            } else {
                this.currentPhylacteryPosition = null;
                this.setMagicArmorActive(false);
            }
        }
    }

    public void setCurrentPhylacteryBlock(BlockPos pos) {
        this.setMagicArmorActive(true);
        this.currentPhylacteryPosition = pos;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.spellHandler.addSpell(0, new EntityAIArmorSpell(this, 50, 30){

            @Override
            public boolean isInterruptible() {
                return true;
            }
        });
        this.spellHandler.addSpell(1, new EntityAISummonMinionSpell(this, 15, 10, new ResourceLocation("cqrepoured", "zombie"), EntitySummoningCircle.ECircleTexture.ZOMBIE, true, 25, 5, new Vec3d(0.0, 0.0, 0.0)){

            @Override
            public boolean isInterruptible() {
                return false;
            }
        });
        this.spellHandler.addSpell(2, new EntityAIFangAttack(this, 20, 5, 1, 12){

            @Override
            public boolean isInterruptible() {
                return false;
            }
        });
        this.spellHandler.addSpell(3, new EntityAIShootPoisonProjectiles(this, 40, 20){

            @Override
            public boolean isInterruptible() {
                return false;
            }
        });
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        for (Entity e : this.summonedMinions) {
            if (e == null || e.field_70128_L) continue;
            if (e instanceof EntityLivingBase) {
                ((EntityLivingBase)e).func_70645_a(cause);
            }
            if (e == null) continue;
            e.func_70106_y();
        }
        this.summonedMinions.clear();
        super.func_70645_a(cause);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_LICH;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.Lich;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.UNDEAD;
    }

    @Override
    public CQRFaction getSummonerFaction() {
        return this.getFaction();
    }

    @Override
    public List<Entity> getSummonedEntities() {
        return this.summonedMinions;
    }

    @Override
    public EntityLivingBase getSummoner() {
        return this;
    }

    @Override
    public void addSummonedEntityToList(Entity summoned) {
        this.summonedMinions.add(summoned);
    }

    @Override
    protected void updateCooldownForMagicArmor() {
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.currentPhylacteryPosition != null) {
            compound.func_74782_a("currentPhylactery", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.currentPhylacteryPosition));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("currentPhylactery")) {
            this.currentPhylacteryPosition = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("currentPhylactery"));
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean hasPhylactery() {
        return this.currentPhylacteryPosition != null && this.field_70170_p.func_180495_p(this.currentPhylacteryPosition).func_177230_c() == CQRBlocks.PHYLACTERY;
    }
}

