/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.boss.subparts;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.objects.entity.boss.EntityCQRNetherDragon;

public class EntityCQRNetherDragonSegment
extends MultiPartEntityPart {
    private EntityCQRNetherDragon dragon;
    private int partIndex = 0;
    private int realID = 0;
    private static final DataParameter<Integer> PART_INDEX = EntityDataManager.func_187226_a(EntityCQRNetherDragonSegment.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_SKELETAL = EntityDataManager.func_187226_a(EntityCQRNetherDragonSegment.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_REMOVED = EntityDataManager.func_187226_a(EntityCQRNetherDragonSegment.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityCQRNetherDragonSegment(EntityCQRNetherDragon dragon, int partID, boolean skeletal) {
        super((IEntityMultiPart)dragon, "dragonPart" + partID, 0.5f, 0.5f);
        this.func_70105_a(1.25f, 1.25f);
        this.dragon = dragon;
        this.partIndex = dragon.INITIAL_SEGMENT_COUNT - partID;
        this.realID = partID;
        this.field_70180_af.func_187227_b(PART_INDEX, (Object)this.partIndex);
        this.setIsSkeletal(skeletal);
        this.func_82142_c(false);
    }

    public void onRemovedFromBody() {
        this.field_70180_af.func_187227_b(IS_REMOVED, (Object)true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PART_INDEX, (Object)this.partIndex);
        this.field_70180_af.func_187214_a(IS_SKELETAL, (Object)false);
        this.field_70180_af.func_187214_a(IS_REMOVED, (Object)false);
    }

    public int getPartIndex() {
        return (Integer)this.field_70180_af.func_187225_a(PART_INDEX);
    }

    public boolean isSkeletal() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SKELETAL) != false || this.dragon == null || this.dragon.getSkeleProgress() >= this.realID;
    }

    private void setIsSkeletal(Boolean val) {
        this.field_70180_af.func_187227_b(IS_SKELETAL, (Object)val);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_94541_c() || source.func_76347_k() || this.dragon == null) {
            return false;
        }
        return this.dragon.func_70965_a(this, source, amount);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.field_70173_aa;
        if (((Boolean)this.field_70180_af.func_187225_a(IS_REMOVED)).booleanValue()) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && (this.dragon == null || this.dragon.field_70128_L)) {
            this.func_70106_y();
        }
    }

    public boolean func_184222_aU() {
        return this.dragon.func_184222_aU();
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.dragon == null || this.dragon.field_70128_L) {
            return false;
        }
        return this.dragon.func_184230_a(player, hand);
    }

    @Nullable
    public EntityCQRNetherDragon getParent() {
        return this.dragon;
    }

    public void explode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false);
        }
    }

    public void switchToSkeletalState() {
        this.setIsSkeletal(true);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, false);
        }
    }

    public void die() {
        this.explode();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("skeletal", this.isSkeletal());
        compound.func_74768_a("realID", this.realID);
        compound.func_74768_a("partIndex", this.partIndex);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setIsSkeletal(compound.func_74767_n("skeletal"));
        this.realID = compound.func_74762_e("realID");
        this.partIndex = compound.func_74762_e("partIndex");
    }
}

