/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.misc;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.EntityUtil;

public class EntityColoredLightningBolt
extends EntityLightningBolt
implements IEntityAdditionalSpawnData {
    private int lightningState;
    private int boltLivingTime;
    protected boolean hitEntities;
    protected boolean spreadFire;
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public EntityColoredLightningBolt(World worldIn) {
        this(worldIn, 0.0, 0.0, 0.0, false, false);
    }

    public EntityColoredLightningBolt(World worldIn, double x, double y, double z, boolean hitEntities, boolean spreadFire) {
        this(worldIn, x, y, z, hitEntities, spreadFire, 0.45f, 0.45f, 0.5f, 0.3f);
    }

    public EntityColoredLightningBolt(World worldIn, double x, double y, double z, boolean hitEntities, boolean spreadFire, float red, float green, float blue, float alpha) {
        super(worldIn, x, y, z, true);
        this.field_70178_ae = true;
        this.lightningState = 2;
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.hitEntities = hitEntities;
        this.spreadFire = spreadFire;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        BlockPos blockpos = new BlockPos((Entity)this);
        if (spreadFire && !worldIn.field_72995_K && worldIn.func_82736_K().func_82766_b("doFireTick") && (worldIn.func_175659_aa() == EnumDifficulty.NORMAL || worldIn.func_175659_aa() == EnumDifficulty.HARD) && worldIn.func_175697_a(blockpos, 10)) {
            if (worldIn.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(worldIn, blockpos)) {
                worldIn.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
            }
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (worldIn.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !Blocks.field_150480_ab.func_176196_c(worldIn, blockpos1)) continue;
                worldIn.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.lightningState == 2) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                if (this.spreadFire && !this.field_70170_p.field_72995_K) {
                    this.field_70264_a = this.field_70146_Z.nextLong();
                    BlockPos blockpos = new BlockPos((Entity)this);
                    if (this.field_70170_p.func_82736_K().func_82766_b("doFireTick") && this.field_70170_p.func_175697_a(blockpos, 10) && this.field_70170_p.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(this.field_70170_p, blockpos)) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175702_c(2);
            } else if (this.hitEntities) {
                AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 6.0 + 3.0, this.field_70161_v + 3.0);
                List list = this.field_70170_p.func_72839_b((Entity)this, aabb);
                for (Entity entity : list) {
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (EntityLightningBolt)this)) continue;
                    if (CQRConfig.advanced.flyingCowardPenaltyEnabled && (EntityUtil.isEntityFlying(entity) || EntityUtil.isEntityFlying(entity.func_184208_bv()))) {
                        entity.func_70097_a(DamageSource.field_76376_m, new Float(CQRConfig.advanced.flyingCowardPenaltyDamage).floatValue());
                    }
                    entity.func_70077_a((EntityLightningBolt)this);
                }
            }
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("red", this.red);
        compound.func_74776_a("green", this.green);
        compound.func_74776_a("blue", this.blue);
        compound.func_74776_a("alpha", this.alpha);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.red = compound.func_74760_g("red");
        this.green = compound.func_74760_g("green");
        this.blue = compound.func_74760_g("blue");
        this.alpha = compound.func_74760_g("alpha");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.alpha);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.red = additionalData.readFloat();
        this.green = additionalData.readFloat();
        this.blue = additionalData.readFloat();
        this.alpha = additionalData.readFloat();
    }
}

