/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.misc;

import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.objects.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityFlyingSkullMinion
extends EntityFlying {
    protected Entity summoner;
    protected Entity target;
    protected boolean attacking = false;
    protected boolean isLeftSkull = false;
    protected Vec3d direction = null;

    public EntityFlyingSkullMinion(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.func_189654_d(true);
        this.func_70606_j(1.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.field_70699_by = new PathNavigateFlying((EntityLiving)this, worldIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_94541_c()) {
            return false;
        }
        if (source.func_76346_g() != null && EntityUtil.isEntityFlying(source.func_76346_g())) {
            return false;
        }
        if (source.func_76364_f() instanceof EntitySpectralArrow) {
            Entity summonerTmp = this.summoner;
            this.summoner = source.func_76346_g();
            this.target = summonerTmp;
            return true;
        }
        if (this.func_70681_au().nextInt(10) == 9) {
            Entity summonerTmp = this.summoner;
            this.summoner = source.func_76346_g();
            this.target = summonerTmp;
            this.func_70106_y();
            return true;
        }
        this.explode(1.25f);
        this.func_70106_y();
        return true;
    }

    public PathNavigate func_70661_as() {
        return this.field_70699_by;
    }

    public void setSummoner(Entity ent) {
        this.summoner = ent;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70055_a(Material.field_151579_a)) {
            this.explode(1.25f);
            this.func_70106_y();
        }
        if (this.attacking) {
            if (this.target != null && !this.target.field_70128_L) {
                this.updateDirection();
            }
            Vec3d v = this.direction;
            v = v.func_72432_b();
            this.field_70159_w = v.field_72450_a * 0.4;
            this.field_70181_x = v.field_72448_b * 0.25;
            this.field_70179_y = v.field_72449_c * 0.4;
            this.field_70133_I = true;
            if (this.target != null && !this.target.field_70128_L) {
                this.func_70671_ap().func_75651_a(this.target, 30.0f, 30.0f);
            }
        } else if (this.summoner != null) {
            Vec3d v = this.summoner.func_70040_Z();
            v = new Vec3d(v.field_72450_a, 2.25, v.field_72449_c);
            v = v.func_72432_b();
            v = v.func_186678_a(2.5);
            v = VectorUtil.rotateVectorAroundY(v, this.isLeftSkull ? 270.0 : 90.0);
            Vec3d targetPos = this.summoner.func_174791_d().func_178787_e(v);
            this.func_70671_ap().func_75651_a(this.summoner, 30.0f, 30.0f);
            if (this.func_70011_f(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c) > 1.0) {
                Vec3d velo = targetPos.func_178788_d(this.func_174791_d());
                velo = velo.func_72432_b();
                velo = velo.func_186678_a(0.2);
                this.field_70159_w = velo.field_72450_a;
                this.field_70181_x = velo.field_72448_b * 2.5;
                this.field_70179_y = velo.field_72449_c;
                this.field_70133_I = true;
            }
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn != this.summoner) {
            super.func_82167_n(entityIn);
            if (EntityUtil.isEntityFlying(entityIn) && this.summoner instanceof EntityLivingBase && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)this.summoner).func_70691_i(((EntityLivingBase)entityIn).func_110143_aJ() / 2.0f);
                ((EntityLivingBase)entityIn).field_70181_x *= -2.0;
                ((EntityLivingBase)entityIn).field_70133_I = true;
            }
            this.explode(0.75f);
            this.func_70106_y();
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.explode(1.25f);
    }

    private void explode(float strengthMultiplier) {
        if (this.field_70170_p != null) {
            if (this.summoner != null && !this.summoner.field_70128_L && !this.field_70128_L) {
                this.field_70170_p.func_72885_a(this.summoner, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p(), 2.0f * strengthMultiplier, false, false);
            }
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() + 0.02, (double)this.func_180425_c().func_177952_p(), 0.5, 0.0, 0.5, new int[]{1});
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() + 0.02, (double)this.func_180425_c().func_177952_p(), 0.5, 0.0, -0.5, new int[]{1});
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() + 0.02, (double)this.func_180425_c().func_177952_p(), -0.5, 0.0, -0.5, new int[]{1});
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() + 0.02, (double)this.func_180425_c().func_177952_p(), -0.5, 0.0, 0.5, new int[]{1});
        }
    }

    public void setTarget(Entity target) {
        this.target = target;
        this.updateDirection();
    }

    public void startAttacking() {
        this.attacking = true;
    }

    private void updateDirection() {
        this.direction = this.target.func_174791_d().func_178788_d(this.func_174791_d());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("attacking", this.attacking);
        compound.func_74780_a("vX", this.direction == null ? 0.0 : this.direction.field_72450_a);
        compound.func_74780_a("vY", this.direction == null ? 0.0 : this.direction.field_72448_b);
        compound.func_74780_a("vZ", this.direction == null ? 0.0 : this.direction.field_72449_c);
        if (this.summoner != null && !this.summoner.field_70128_L) {
            compound.func_74782_a("summonerID", (NBTBase)NBTUtil.func_186862_a((UUID)this.summoner.getPersistentID()));
        }
        if (this.target != null && !this.target.field_70128_L) {
            compound.func_74782_a("targetID", (NBTBase)NBTUtil.func_186862_a((UUID)this.target.getPersistentID()));
        }
    }

    public boolean isAttacking() {
        return this.attacking;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.field_70128_L;
    }

    public void setSide(boolean left) {
        this.isLeftSkull = left;
    }

    public void func_70037_a(NBTTagCompound compound) {
        UUID id;
        super.func_70037_a(compound);
        this.attacking = compound.func_74767_n("attacking");
        double x = compound.func_74769_h("vX");
        double y = compound.func_74769_h("vY");
        double z = compound.func_74769_h("vZ");
        this.direction = new Vec3d(x, y, z);
        if (compound.func_74764_b("targetID")) {
            id = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("targetID"));
            if (this.field_70170_p != null) {
                for (Entity ent : this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_180425_c().func_177982_a(10, 10, 10), this.func_180425_c().func_177982_a(-10, -10, -10)), TargetUtil.PREDICATE_LIVING)) {
                    if (!ent.getPersistentID().equals(id)) continue;
                    this.target = ent;
                }
            }
        }
        if (compound.func_74764_b("summonerID")) {
            id = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("summonerID"));
            if (this.field_70170_p != null) {
                for (Entity ent : this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_180425_c().func_177982_a(10, 10, 10), this.func_180425_c().func_177982_a(-10, -10, -10)), TargetUtil.PREDICATE_LIVING)) {
                    if (!ent.getPersistentID().equals(id)) continue;
                    this.summoner = ent;
                }
            }
        }
    }
}

