/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.mobs;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.cqr.cqrepoured.factions.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRCreatureAttributes;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.CQRConfig;

public class EntityCQREnderman
extends AbstractEntityCQR {
    public EntityCQREnderman(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70619_bc() {
        if (this.func_70090_H() || this.func_70026_G() && this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.Enderman;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.ENDERMEN;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187529_aS;
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_ENDERMAN;
    }

    @Override
    public boolean isSitting() {
        return false;
    }

    @Override
    public boolean canMountEntity() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.875f;
    }

    @Override
    public float getDefaultWidth() {
        return 0.6f;
    }

    @Override
    public float getDefaultHeight() {
        return 2.9f;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return CQRCreatureAttributes.CREATURE_TYPE_ENDERMAN;
    }
}

