/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.pathfinding;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class Path {
    private static final String VERSION = "1.0.0";
    private final List<PathNode> nodes = new ArrayList<PathNode>();

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("version", VERSION);
        NBTTagList nbtTagList = new NBTTagList();
        for (PathNode node : this.nodes) {
            nbtTagList.func_74742_a((NBTBase)node.writeToNBT());
        }
        compound.func_74782_a("nodes", (NBTBase)nbtTagList);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.nodes.clear();
        String s = compound.func_74779_i("version");
        if (!s.equals(VERSION)) {
            CQRMain.logger.warn("Reading path: Expected version {} but got {}", (Object)VERSION, (Object)s);
        }
        for (NBTBase nbt : compound.func_150295_c("nodes", 10)) {
            this.nodes.add(new PathNode(this, (NBTTagCompound)nbt));
        }
        this.onPathChanged();
    }

    public boolean addNode(PathNode rootNode, BlockPos pos, int waitingTimeMin, int waitingTimeMax, float waitingRotation, int weight, int timeMin, int timeMax, boolean bidirectional) {
        if (this.nodes.isEmpty()) {
            PathNode node = new PathNode(this, pos, waitingTimeMin, waitingTimeMax, waitingRotation, weight, timeMin, timeMax, this.nodes.size());
            this.nodes.add(node);
            this.onPathChanged();
            return true;
        }
        if (rootNode != null && this.getNode(pos) == null) {
            PathNode node = new PathNode(this, pos, waitingTimeMin, waitingTimeMax, waitingRotation, weight, timeMin, timeMax, this.nodes.size());
            this.nodes.add(node);
            rootNode.addConnectedNode(node, bidirectional, false);
            this.onPathChanged();
            return true;
        }
        return false;
    }

    public boolean removeNode(PathNode node) {
        if (this.getNode(node.index) == node) {
            this.nodes.remove(node.index);
            for (PathNode otherNode : this.nodes) {
                otherNode.removeConnectedNode(node, false);
                otherNode.removeBlacklistedPrevNode(node, false);
            }
            for (PathNode otherNode : this.nodes) {
                int i;
                if (otherNode.index > node.index) {
                    otherNode.index--;
                }
                for (i = 0; i < otherNode.connectedNodes.size(); ++i) {
                    if ((Integer)otherNode.connectedNodes.get(i) <= node.index) continue;
                    otherNode.connectedNodes.set(i, (Integer)otherNode.connectedNodes.get(i) - 1);
                }
                for (i = 0; i < otherNode.blacklistedPrevNodes.size(); ++i) {
                    if ((Integer)otherNode.blacklistedPrevNodes.get(i) <= node.index) continue;
                    otherNode.blacklistedPrevNodes.set(i, (Integer)otherNode.blacklistedPrevNodes.get(i) - 1);
                }
            }
            this.onPathChanged();
            return true;
        }
        return false;
    }

    public void clear() {
        this.nodes.clear();
        this.onPathChanged();
    }

    public List<PathNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public int getSize() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Nullable
    public PathNode getNode(int index) {
        if (index < 0 || index >= this.nodes.size()) {
            return null;
        }
        return this.nodes.get(index);
    }

    @Nullable
    public PathNode getNode(BlockPos pos) {
        for (PathNode node : this.nodes) {
            if (!node.pos.equals((Object)pos)) continue;
            return node;
        }
        return null;
    }

    public void copyFrom(Path path) {
        this.copyFrom(path, BlockPos.field_177992_a);
    }

    public void copyFrom(Path path, BlockPos offset) {
        this.nodes.clear();
        for (PathNode node : path.nodes) {
            this.nodes.add(node.copy(this, offset));
        }
        this.onPathChanged();
    }

    public void onPathChanged() {
    }

    public class PathNode {
        private final Path path;
        private BlockPos pos;
        private int waitingTimeMin;
        private int waitingTimeMax;
        private float waitingRotation;
        private int weight;
        private int timeMin;
        private int timeMax;
        private int index;
        private final IntList connectedNodes = new IntArrayList();
        private final IntList blacklistedPrevNodes = new IntArrayList();

        private PathNode(Path path, BlockPos pos, int waitingTimeMin, int waitingTimeMax, float waitingRotation, int weight, int timeMin, int timeMax, int index) {
            this.path = path;
            this.pos = pos.func_185334_h();
            this.waitingTimeMin = MathHelper.func_76125_a((int)Math.min(waitingTimeMin, waitingTimeMax), (int)0, (int)24000);
            this.waitingTimeMax = MathHelper.func_76125_a((int)Math.max(waitingTimeMin, waitingTimeMax), (int)0, (int)24000);
            this.waitingRotation = MathHelper.func_76142_g((float)waitingRotation);
            this.weight = MathHelper.func_76125_a((int)weight, (int)1, (int)10000);
            this.timeMin = MathHelper.func_76125_a((int)timeMin, (int)0, (int)24000);
            this.timeMax = MathHelper.func_76125_a((int)timeMax, (int)0, (int)24000);
            this.index = index;
        }

        private PathNode(Path path, NBTTagCompound compound) {
            this.path = path;
            this.pos = DungeonGenUtils.readPosFromList(compound.func_150295_c("pos", 3));
            this.waitingTimeMin = compound.func_74762_e("waitingTimeMin");
            this.waitingTimeMax = compound.func_74762_e("waitingTimeMax");
            this.waitingRotation = compound.func_74760_g("waitingRotation");
            this.weight = compound.func_74762_e("weight");
            this.timeMin = compound.func_74762_e("timeMin");
            this.timeMax = compound.func_74762_e("timeMax");
            this.index = compound.func_74762_e("index");
            this.connectedNodes.addElements(0, compound.func_74759_k("connectedNodes"));
            this.blacklistedPrevNodes.addElements(0, compound.func_74759_k("blacklistedPrevNodes"));
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("pos", (NBTBase)DungeonGenUtils.writePosToList(this.pos));
            compound.func_74768_a("waitingTimeMin", this.waitingTimeMin);
            compound.func_74768_a("waitingTimeMax", this.waitingTimeMax);
            compound.func_74776_a("waitingRotation", this.waitingRotation);
            compound.func_74768_a("weight", this.weight);
            compound.func_74768_a("timeMin", this.timeMin);
            compound.func_74768_a("timeMax", this.timeMax);
            compound.func_74768_a("index", this.index);
            compound.func_74783_a("connectedNodes", this.connectedNodes.toIntArray());
            compound.func_74783_a("blacklistedPrevNodes", this.blacklistedPrevNodes.toIntArray());
            return compound;
        }

        public boolean addConnectedNode(PathNode node, boolean bidirectional) {
            return this.addConnectedNode(node, bidirectional, true);
        }

        private boolean addConnectedNode(PathNode node, boolean bidirectional, boolean updateWhenChanged) {
            boolean flag2;
            if (node == this) {
                return false;
            }
            boolean flag1 = this.connectedNodes.contains(node.index);
            boolean bl = flag2 = !bidirectional || node.connectedNodes.contains(this.index);
            if (flag1 && flag2) {
                return false;
            }
            if (!flag1) {
                this.connectedNodes.add(node.index);
            }
            if (!flag2) {
                node.connectedNodes.add(this.index);
            }
            if (updateWhenChanged) {
                Path.this.onPathChanged();
            }
            return true;
        }

        public boolean removeConnectedNode(PathNode node) {
            return this.removeConnectedNode(node, true);
        }

        private boolean removeConnectedNode(PathNode node, boolean updateWhenChanged) {
            boolean flag = this.connectedNodes.rem(node.index);
            boolean flag1 = node.connectedNodes.rem(this.index);
            if (!flag && !flag1) {
                return false;
            }
            if (updateWhenChanged) {
                Path.this.onPathChanged();
            }
            return true;
        }

        public boolean addBlacklistedPrevNode(PathNode node) {
            return this.addBlacklistedPrevNode(node, true);
        }

        private boolean addBlacklistedPrevNode(PathNode node, boolean updateWhenChanged) {
            if (node == this) {
                return false;
            }
            boolean flag = false;
            IntListIterator intListIterator = this.connectedNodes.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                IntListIterator intListIterator2 = ((PathNode)((Path)this.path).nodes.get((int)i)).connectedNodes.iterator();
                while (intListIterator2.hasNext()) {
                    int j = (Integer)intListIterator2.next();
                    if (j != node.index) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                break;
            }
            if (!flag) {
                return false;
            }
            this.blacklistedPrevNodes.add(node.index);
            if (updateWhenChanged) {
                Path.this.onPathChanged();
            }
            return true;
        }

        public boolean removeBlacklistedPrevNode(PathNode node) {
            return this.removeBlacklistedPrevNode(node, true);
        }

        private boolean removeBlacklistedPrevNode(PathNode node, boolean updateWhenChanged) {
            if (!this.blacklistedPrevNodes.rem(node.index)) {
                return false;
            }
            if (updateWhenChanged) {
                Path.this.onPathChanged();
            }
            return true;
        }

        @Nullable
        public PathNode getNextNode(World world, Random rand, @Nullable PathNode prevNode) {
            PathNode node;
            if (this.connectedNodes.isEmpty()) {
                return null;
            }
            long time = world.func_72820_D() % 24000L;
            int totalWeight = 0;
            int totalWeightIgnoreTime = 0;
            IntListIterator intListIterator = this.connectedNodes.iterator();
            while (intListIterator.hasNext()) {
                int connectedNode = (Integer)intListIterator.next();
                PathNode node2 = (PathNode)this.path.nodes.get(connectedNode);
                if (prevNode != null && (node2 == prevNode || node2.blacklistedPrevNodes.contains(prevNode.index)) || time < (long)node2.timeMin || time > (long)node2.timeMax) continue;
                totalWeight += node2.weight;
            }
            if (totalWeight == 0 && totalWeightIgnoreTime == 0) {
                return prevNode;
            }
            int o = rand.nextInt(totalWeight);
            IntListIterator intListIterator2 = this.connectedNodes.iterator();
            while (intListIterator2.hasNext()) {
                int connectedNode = (Integer)intListIterator2.next();
                node = (PathNode)this.path.nodes.get(connectedNode);
                if (prevNode != null && (node == prevNode || node.blacklistedPrevNodes.contains(prevNode.index)) || time < (long)node.timeMin || time > (long)node.timeMax || (o -= node.weight) >= 0) continue;
                return node;
            }
            o = rand.nextInt(totalWeightIgnoreTime);
            intListIterator2 = this.connectedNodes.iterator();
            while (intListIterator2.hasNext()) {
                int connectedNode = (Integer)intListIterator2.next();
                node = (PathNode)this.path.nodes.get(connectedNode);
                if (prevNode != null && (node == prevNode || node.blacklistedPrevNodes.contains(prevNode.index)) || (o -= node.weight) >= 0) continue;
                return node;
            }
            return prevNode;
        }

        public IntList getConnectedNodes() {
            return IntLists.unmodifiable((IntList)this.connectedNodes);
        }

        public int getSizeOfConnectedNodes() {
            return this.connectedNodes.size();
        }

        @Nullable
        public PathNode getConnectedNode(int index) {
            if (index < 0 || index >= this.connectedNodes.size()) {
                return null;
            }
            return (PathNode)this.path.nodes.get(this.connectedNodes.getInt(index));
        }

        public void setPos(BlockPos pos) {
            this.pos = pos.func_185334_h();
            Path.this.onPathChanged();
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void setWaitingTimeMin(int waitingTimeMin) {
            this.waitingTimeMin = waitingTimeMin;
            Path.this.onPathChanged();
        }

        public int getWaitingTimeMin() {
            return this.waitingTimeMin;
        }

        public void setWaitingTimeMax(int waitingTimeMax) {
            this.waitingTimeMax = waitingTimeMax;
            Path.this.onPathChanged();
        }

        public int getWaitingTimeMax() {
            return this.waitingTimeMax;
        }

        public void setWaitingRotation(float waitingRotation) {
            this.waitingRotation = waitingRotation;
            Path.this.onPathChanged();
        }

        public float getWaitingRotation() {
            return this.waitingRotation;
        }

        public void setWeight(int weight) {
            this.weight = weight;
            Path.this.onPathChanged();
        }

        public int getWeight() {
            return this.weight;
        }

        public void setTimeMin(int timeMin) {
            this.timeMin = timeMin;
            Path.this.onPathChanged();
        }

        public int getTimeMin() {
            return this.timeMin;
        }

        public void setTimeMax(int timeMax) {
            this.timeMax = timeMax;
            Path.this.onPathChanged();
        }

        public int getTimeMax() {
            return this.timeMax;
        }

        public int getIndex() {
            return this.index;
        }

        private PathNode copy(Path path, BlockPos offset) {
            PathNode copy = new PathNode(path, this.pos.func_177971_a((Vec3i)offset), this.waitingTimeMin, this.waitingTimeMax, this.waitingRotation, this.weight, this.timeMin, this.timeMax, this.index);
            copy.connectedNodes.addAll(this.connectedNodes);
            return copy;
        }
    }
}

